import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class BasicAlgebra {
    int mode;
    Point X;

    /**the convention is that choice =1  or choice=2*/

    public static PolygonWrapper domain(int choice,double s) {
	if(choice==1) return(domain1(s));
	else return(domain2(s));
    }

    public static PolygonWrapper domain1(double s) {
	PolygonWrapper P=new PolygonWrapper();
	P.count=4;
	P.z[0]=new Complex(0,0);
	P.z[1]=new Complex(2,0);
	P.z[2]=new Complex(2+2*s,2*s);
	P.z[3]=new Complex(2*s,2*s);
	Complex w=P.center();
	for(int i=0;i<4;++i) P.z[i]=Complex.minus(P.z[i],w);
	return(P);
    }

    public static PolygonWrapper domain2(double s) {
	PolygonWrapper P=domain1(s);
	for(int i=0;i<4;++i) P.z[i]=Complex.times(P.z[i],new Complex(0,1));
	return(P);
    }


    public static Matrix dynamicsLattice(int choice,double s) {
	if(choice==1) return(lattice1(s));
	else return(lattice2(s));
    }

    public static Matrix lattice1(double s) {
	Matrix M=new Matrix();
	M.size=2;
	M.a[0][0]=0;
	M.a[1][0]=2;
	M.a[0][1]=-2*s;
	M.a[1][1]=-2*s;
	return(M);
    }


    public static Matrix lattice2(double s) {
	Matrix M=new Matrix();
	M.size=2;
	M.a[0][0]=-2;
	M.a[1][0]=0;
	M.a[0][1]=2*s;
	M.a[1][1]=-2*s;
	return(M);
    }


    public static Matrix domainLattice(int choice,double s) {
	Matrix M=new Matrix();
	M.size=2;
	M.a[0][0]=2;
	M.a[1][0]=0;
	M.a[0][1]=2*s;
	M.a[1][1]=2*s;

	if(choice==2) {
	  M.a[0][0]=0;
	  M.a[1][0]=2;
	  M.a[0][1]=-2*s;
	  M.a[1][1]=2*s;
	}
	return(M);
    }


    public static Complex reduce(int choice,double s,Complex z) {
	return(reduce(choice,s,z,true));
    }


    public static Complex reduce(int choice,double s,Complex z,boolean DIR) {
	Complex w=reduce2(choice,s,z,DIR);
	w=reduce1(choice,s,w,DIR);
	return(w);
    }

    public static Complex reduce1(int choice,double s,Complex z) {
	return(reduce1(choice,s,z,true));
    }

    public static Complex reduce2(int choice,double s,Complex z) {
	return(reduce2(choice,s,z,true));
    }

    public static Complex reduce1(int choice,double s,Complex z,boolean DIR) {
	 PolygonWrapper P=domain(choice,s);
	 Matrix m=dynamicsLattice(choice,s);
	 if(DIR==false)  m=dynamicsLattice(3-choice,s);

	 for(int r=0;r<=100;++r) {
	   for(int i=-r;i<=r;++i) {
	    for(int j=-r;j<=r;++j) {
		double[] p={i,j};
		Vector V=new Vector(p);
		V=Matrix.act(m,V);
		Complex w=new Complex(V.x[0],V.x[1]);
		w=Complex.plus(z,w);
		if(P.contains(w)==true) return(w);
	    }
	   }
	 }
	return(null);
    }




    public static Complex reduce2(int choice,double s,Complex z,boolean DIR) {
	 Matrix m=dynamicsLattice(choice,s);
	 if(DIR==false)  m=dynamicsLattice(3-choice,s);
	 Matrix mi=m.inverse();
	 Vector Z=z.toVector();
	 Z=Matrix.act(mi,Z);
	 double x0=Math.floor(Z.x[0]+.5);
	 double x1=Math.floor(Z.x[1]+.5);
	 Z.x[0]=Z.x[0]-x0;
	 Z.x[1]=Z.x[1]-x1;
	 Z=Matrix.act(m,Z);
	 Complex w=Z.toComplex();
	 return(w);
    }

    /**here x should be nearly an integer*/

    public static int properCast(double x) {
	int sign=1;
	if(x<0) sign=-1;
	double y=Math.abs(x);
	int t=(int)(y+.5);
	t=sign*t;
	return(t);
    }

    /*This gets the fragment of the arithmetic graph associated to z*/
    public static int[] graph(double s,Complex z) {
	Complex w1=reduce(2,s,z,true);
	Complex w2=reduce(1,s,w1,true);
	Complex w3=Complex.minus(w1,z);
	Complex w4=Complex.minus(w2,w1);
	Matrix m1=dynamicsLattice(1,s);
	Matrix m2=dynamicsLattice(2,s);
	Vector W3=w3.toVector();
	Vector W4=w4.toVector();
	W3=Matrix.act(m2.inverse(),W3);
	W4=Matrix.act(m1.inverse(),W4);
	int[] t=new int[4];
	t[0]=properCast(W3.x[0]+.000001);
	t[1]=properCast(W3.x[1]+.000001);
	t[2]=properCast(W4.x[0]+.000001);
	t[3]=properCast(W4.x[1]+.000001);
	return(t);
    }



    /**The point should start in domain1**/

    public static Complex map(double s,Complex z) {
	Complex w=reduce(2,s,z,true);
	w=reduce(1,s,w,true);
	return(w);
    }

    /**The point should start in domain1**/

    public static Complex mapHalf(double s,Complex z) {
	Complex w=reduce(2,s,z,true);
	return(w);
    }

    /**The point should start in domain1**/

    public static Complex invMap(double s,Complex z) {
	Complex w=reduce(2,s,z,false);
	w=reduce(1,s,w,false);
	return(w);
    }



    public static Vector getLocation(int choice,double s,Complex z) {
	Matrix m=domainLattice(choice,s);
	double[] p={z.x,z.y};
	m=m.inverse();
	Vector V=new Vector(p);
	V=Matrix.act(m,V);
	return(V);
    }

    public static Vector[] getBounds(int choice,double s,Complex z) {
	Vector V=getLocation(choice,s,z);
	double[] min={-.5-V.x[0],-.5-V.x[1]};
	double[] max={+.5-V.x[0],+.5-V.x[1]};
	Vector MIN=new Vector(min);
	Vector MAX=new Vector(max);
	Vector[] W={MIN,MAX};
	return(W);
    }

    /**This realizes a parallelogram with specified bounds.*/

    public static PolygonWrapper realize(int choice,double s,Vector MIN,Vector MAX) {
	Matrix M=domainLattice(choice,s);
        Vector[] V=new Vector[4];

        for(int i=0;i<4;++i) {
	    V[i]=new Vector();
            V[i].size=2;
	}

        V[0].x[0]=MIN.x[0];
        V[0].x[1]=MIN.x[1];
        V[1].x[0]=MIN.x[0];
        V[1].x[1]=MAX.x[1];
        V[2].x[0]=MAX.x[0];
        V[2].x[1]=MAX.x[1];
        V[3].x[0]=MAX.x[0];
        V[3].x[1]=MIN.x[1];
        for(int i=0;i<4;++i) V[i]=Matrix.act(M,V[i]);
	PolygonWrapper P=new PolygonWrapper();
	P.count=4;
	for(int i=0;i<4;++i) P.z[3-i]=new Complex(V[i].x[0],V[i].x[1]);
	return(P);
    }

    /*This realizes the intersection of two parallelograms. This is the tile creator.
      The input is a length 4 list of vectors:  MIN1,MAX1,MIN2,MAX2.  MINk,MAXk specifies
      parallelogram k, and then parallelograms 1 and 2 are intersected.  The tile
      here is centered at the origin.*/


    public static PolygonWrapper realize(double s,Vector[] BOUND) {
	Vector MIN1=BOUND[0];
	Vector MAX1=BOUND[1];
	Vector MIN2=BOUND[2];
	Vector MAX2=BOUND[3];
	PolygonWrapper P1=realize(1,s,MIN1,MAX1);
	PolygonWrapper P2=realize(2,s,MIN2,MAX2);
	PolygonWrapper P3=PolygonWrapper.intersect(P1,P2);
	return(P3);
    }

    /*This routine is the same, but the tile is translated to
      the location of the given point.*/

    public static PolygonWrapper realize(double s,Complex w,Vector[] BOUND) {
	PolygonWrapper P=realize(s,BOUND);
	for(int i=0;i<P.count;++i) P.z[i]=Complex.plus(P.z[i],w);
	return(P);
    }


}
