import java.awt.event.*;
import java.awt.*;
import java.math.*;

/*This is a class used in our rigorous computations.
  It is a vector in Z^3.  With each routine, we check
  to make sure that there is no overflow error*/



public class BigVector {
    BigInteger[] x=new BigInteger[3];

    public BigVector(){}

    public BigVector(LongVector V) {
	for(int i=0;i<3;++i) {
	    Long a=new Long(V.x[i]);
	    x[i]=new BigInteger(a.toString());
	}
    }

    public static BigVector plus(BigVector v1,BigVector v2) {
	BigVector w=new BigVector();
	for(int i=0;i<3;++i) {
            w.x[i]=v1.x[i].add(v2.x[i]);
	}
	return(w);
    }

    public static BigVector minus(BigVector v1,BigVector v2) {
	BigVector w=new BigVector();
	for(int i=0;i<3;++i) {
            w.x[i]=v1.x[i].subtract(v2.x[i]);
	}
	return(w);
    }

    public static BigInteger dot(BigVector v,BigVector w) {	
	BigInteger a=new BigInteger("0");
	for(int i=0;i<3;++i) a=a.add(v.x[i].multiply(w.x[i]));
	return(a);
    }

    public static BigVector cross(BigVector v,BigVector w) {
	BigVector X=new BigVector();
	X.x[0]=new BigInteger("0");
	X.x[1]=new BigInteger("0");
	X.x[2]=new BigInteger("0");
	X.x[0]=X.x[0].add(v.x[1].multiply(w.x[2]));
	X.x[0]=X.x[0].subtract(w.x[1].multiply(v.x[2]));
	X.x[1]=X.x[1].add(v.x[2].multiply(w.x[0]));
	X.x[1]=X.x[1].subtract(w.x[2].multiply(v.x[0]));
	X.x[2]=X.x[2].add(v.x[0].multiply(w.x[1]));
	X.x[2]=X.x[2].subtract(w.x[0].multiply(v.x[1]));
	return(X);
    }



    public static BigInteger volumePrism3(BigVector V,BigVector[] W) {
	BigInteger ZERO=new BigInteger("0");
	BigVector[] X=new BigVector[3];
	for(int i=0;i<3;++i) X[i]=BigVector.minus(W[i],V);
	BigInteger t=BigVector.dot(X[0],BigVector.cross(X[1],X[2]));
	if(t.compareTo(ZERO)==-1) t=t.negate();
	t=t.multiply(new BigInteger("2"));
	return(t);
    }



    public static BigInteger volumePrism4(BigVector V,BigVector[] W) {
	BigVector[] X=new BigVector[4];
	for(int i=0;i<4;++i) X[i]=BigVector.minus(W[i],V);
	BigInteger t1=BigVector.dot(X[0],BigVector.cross(X[1],X[2]));
	BigInteger t2=BigVector.dot(X[0],BigVector.cross(X[1],X[3]));
	BigInteger t3=BigVector.dot(X[0],BigVector.cross(X[2],X[3]));
	BigInteger t4=BigVector.dot(X[1],BigVector.cross(X[2],X[3]));
	BigInteger[] t={t1,t2,t3,t4};
	BigInteger ZERO=new BigInteger("0");
	BigInteger u=new BigInteger("0");
	for(int i=0;i<4;++i) {
	   if(t[i].compareTo(ZERO)==-1) t[i]=t[i].negate();
	   u=u.add(t[i]);
	}
	return(u);
    }

}




