
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class does the math for the outer billiards map*/

public class BilliardsMap {

    public BilliardsMap() {}

    /**This routine tests whether the point z is contained in the kth sector determined by a polygon**/

    public static boolean testSector(PolygonWrapper P,Complex z,int k) {
	double[] d=positionSector(P,z,k);
	if((d[0]>0)&&(d[1]>0)) return(true);
	return(false);
    }

    public static double[] positionSector(PolygonWrapper P,Complex z,int k) {
	int k1=(k+0)%P.count;
	int k2=(k+1)%P.count;
	int k3=(k+2)%P.count;
	Complex z1=P.z[k1];
	Complex z2=P.z[k2];
	Complex z3=P.z[k3];
	double d1=Complex.area(z,z1,z2);
	double d2=Complex.area(z,z3,z2);
	d1=d1/Complex.dist(z1,z2);
	d2=d2/Complex.dist(z3,z2);
	double[] d={d1,d2};
	return(d);
    }



    /**This routine determines which sector a point lies in**/

    public static  int testSector(PolygonWrapper P,Complex z) {
	int test=-1;
	for(int i=0;i<P.count;++i) {  
            boolean test2=testSector(P,z,i);
	    if(test2==true) test=i;
	}
	return(test);
    }


    /**This routine updates the list of distances, based on the point
       location*/

    public static double[] updateList(PolygonWrapper P,Complex z,double[] D,int shift) {
	int k=testSector(P,z);
	double[] d=positionSector(P,z,k);
	int k1=(k+shift+0)%P.count;
	int k2=(k+shift+5)%P.count;
	double[] E=new double[D.length];
	for(int i=0;i<D.length;++i) E[i]=D[i];
	E[k1]=Math.min(D[k1],d[0]);
	E[k2]=Math.min(D[k2],d[1]);
	return(E);
    }


    /**This is the basic outer billiards map*/

    public static Complex nextPoint(Complex z,PolygonWrapper Q) {
	Complex w=previousPoint(z.conjugate(),Q.conjugate());
        return(w.conjugate());
    }

    /**The inverse map**/

    public static Complex previousPoint(Complex z,PolygonWrapper Q) {
	int k=BilliardsMap.testSector(Q,z);
	k=(k+1)%Q.count;
	Complex q=Q.z[k];
	Complex w=new Complex(2*q.x-z.x,2*q.y-z.y);
        return(w);
    }

    /**This is the first return map to the union of the two dogbones*/

    public static int[] dogboneInt(int SHIFT,Complex z,double s,PolygonWrapper Q) {
	PolygonWrapper P1=BilliardsShapes.dogbone(s,0,SHIFT-0,0);
	PolygonWrapper P2=BilliardsShapes.dogbone(s,0,SHIFT-1,1);
	GeneralPath gp1=P1.toGeneralPath();
	GeneralPath gp2=P2.toGeneralPath();
	boolean test=false;
	Complex w=new Complex(z);
	int[] list0=new int[100];
	int count=0;
	int v=0;
	while(test==false) {
	    w=nextPoint(w,Q); 
            v=testSector(Q,w);
	    list0[count]=(v+1)%8;
	    ++count;
	    w=nextPoint(w,Q); 
            v=testSector(Q,w);
	    list0[count]=(v+1)%8;
	    ++count;
	    if(gp1.contains(w.x,w.y)==true) test=true;
	    if(gp2.contains(w.x,w.y)==true) test=true;
	}
	int[] list1=new int[count];
	for(int i=0;i<count;++i) list1[i]=list0[i];
	return(list1);
    }

    /**This generates the sequence for the octagon tile*/

    public static int[] octagonInt(int SHIFT,Complex z,double s,PolygonWrapper Q) {
	boolean test=false;
	Complex w=new Complex(z);
	int[] list0=new int[100];
	int count=0;
	int v=0;
	while(test==false) {
	    w=nextPoint(w,Q); 
            v=testSector(Q,w);
	    list0[count]=(v+1)%8;
	    ++count;
	    w=nextPoint(w,Q); 
            v=testSector(Q,w);
	    list0[count]=(v+1)%8;
	    ++count;
	    if(Complex.dist(z,w)<.0001) test=true;
	}
	int[] list1=new int[count];
	for(int i=0;i<count;++i) list1[i]=list0[i];
	return(list1);
    }




    public static Complex dogbone(int SHIFT,Complex z,double s,PolygonWrapper Q) {
	Complex w=preDogbone(SHIFT,z,s,Q);
	PolygonWrapper P1=BilliardsShapes.dogbone(s,0,SHIFT-0,0);
	PolygonWrapper P2=BilliardsShapes.dogbone(s,0,SHIFT-1,1);	
        GeneralPath gp1=P1.toGeneralPath();
	GeneralPath gp2=P2.toGeneralPath();
	boolean t1=gp1.contains(z.x,z.y);
	boolean t2=gp2.contains(w.x,w.y);

	if((t1==true)&&(t2==true)) w=Complex.minus(w,new Complex(-2+2*s,2*s));
	if((t1==false)&&(t2==false)) w=Complex.plus(w,new Complex(-2+2*s,2*s));
	return(w);
    }

    public static Complex preDogbone(int SHIFT,Complex z,double s,PolygonWrapper Q) {
	PolygonWrapper P1=BilliardsShapes.dogbone(s,0,SHIFT-0,0);
	PolygonWrapper P2=BilliardsShapes.dogbone(s,0,SHIFT-1,1);
	GeneralPath gp1=P1.toGeneralPath();
	GeneralPath gp2=P2.toGeneralPath();
	boolean test=false;
	Complex w=new Complex(z);
	int count=0;
	while((count<1000)&&(test==false)) {
	    w=nextPoint(w,Q); 
	    w=nextPoint(w,Q); 
	    if(gp1.contains(w.x,w.y)==true) test=true;
	    if(gp2.contains(w.x,w.y)==true) test=true;
	    ++count;
	}
	return(w);
    }



    public static int[] halfboneInt(int SHIFT,Complex z,double s,PolygonWrapper Q) {
	PolygonWrapper P1=BilliardsShapes.dogbone(s,0,SHIFT,0);
	PolygonWrapper P2=BilliardsShapes.halfbone(s,SHIFT,0);
	PolygonWrapper P3=BilliardsShapes.halfbone(s,SHIFT,1);
	GeneralPath gp1=P1.toGeneralPath();
	GeneralPath gp2=P2.toGeneralPath();
	GeneralPath gp3=P3.toGeneralPath();
	boolean test=false;
	Complex w=new Complex(z);
	int[] list0=new int[100];
	int count=0;
	int v=0;
	while(test==false) {
	    w=nextPoint(w,Q); 
            v=testSector(Q,w);
	    list0[count]=(v+1)%8;
	    ++count;
	    w=nextPoint(w,Q); 
            v=testSector(Q,w);
	    list0[count]=(v+1)%8;
	    ++count;
	    if(gp1.contains(w.x,w.y)==true) test=true;
	    if(gp2.contains(w.x,w.y)==true) test=true;
	    if(gp3.contains(w.x,w.y)==true) test=true;
	}
	int[] list1=new int[count];
	for(int i=0;i<count;++i) list1[i]=list0[i];
	return(list1);
    }





    public static Complex halfbone(int SHIFT,Complex z,double s,PolygonWrapper Q) {
	PolygonWrapper P1=BilliardsShapes.dogbone(s,0,SHIFT,0);
	PolygonWrapper P2=BilliardsShapes.halfbone(s,SHIFT,0);
	PolygonWrapper P3=BilliardsShapes.halfbone(s,SHIFT,1);
	GeneralPath gp1=P1.toGeneralPath();
	GeneralPath gp2=P2.toGeneralPath();
	GeneralPath gp3=P3.toGeneralPath();
	boolean test=false;
	Complex w=new Complex(z);
	int count=0;
	while((count<1000)&&(test==false)) {
	    w=nextPoint(w,Q); 
	    w=nextPoint(w,Q); 
	    if(gp1.contains(w.x,w.y)==true) test=true;
	    if(gp2.contains(w.x,w.y)==true) test=true;
	    if(gp3.contains(w.x,w.y)==true) test=true;
	    ++count;
	}
	return(w);
    }

}
