 import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Random;




public class BilliardsShapes {


    /*The strips*/

    public static PolygonWrapper strip0(double s,int j,int k) {
	PolygonWrapper P=strip0(s);
	if(j==1) P=P.conjugate();
	if(k==1) {
	    for(int i=0;i<4;++i) P.z[i]=Complex.times(P.z[i],new Complex(0,1));
	}
	return(P);
    }

    public static PolygonWrapper strip1(double s,int j,int k) {
	PolygonWrapper P=strip1(s);
	if(j==1) P=P.conjugate();
	if(k==1) {
	    for(int i=0;i<4;++i) P.z[i]=Complex.times(P.z[i],new Complex(-1,0));
	}
	return(P);
    }

    public static PolygonWrapper strip0(double s) {
	PolygonWrapper P=new PolygonWrapper();
	P.count=4;
	P.z[0]=new Complex(-100,-s);
	P.z[1]=new Complex(-100,3*s);
	P.z[2]=new Complex(+100,3*s);	
        P.z[3]=new Complex(+100,-s);
	return(P);
    }

    public static PolygonWrapper strip1(double s) {
	PolygonWrapper P=new PolygonWrapper();
	P.count=4;
	P.z[0]=new Complex(-100,101);
	P.z[1]=new Complex(100,-99);
	P.z[2]=new Complex(97,-100);	
        P.z[3]=new Complex(-100,97);

	return(P);
    }


    public static PolygonWrapper barrier(double s) {
	PolygonWrapper P=new PolygonWrapper();
	P.count=8;
	P.z[0]=new Complex(6,0);
	P.z[1]=new Complex(+6*s,+6*s);
	P.z[2]=new Complex(0,6);
	P.z[3]=new Complex(-6*s,+6*s);
	P.z[4]=new Complex(-6,0);
	P.z[5]=new Complex(-6*s,-6*s);
	P.z[6]=new Complex(0,-6);
	P.z[7]=new Complex(+6*s,-6*s);
	return(P);
    }



    /**This is the general octagon.
       s is the parameter
       k (1-7) is the rotation
       m is the outward distance
       n is the upward lift.
    **/

    public static PolygonWrapper octagon(double s,int k,int m,int n) {
	PolygonWrapper P=octagon(s);
	double t=2*Math.PI*k/8;
	Complex w1=new Complex(Math.cos(t),Math.sin(t));
	Complex w2=new Complex(Math.cos(t),Math.sin(t));
	Complex z11=new Complex(2*m,0);
	Complex z12=new Complex(2*Math.sqrt(2)*s*m,0);
	Complex z21=new Complex(2*n*s,2*n*s);
	Complex z22=new Complex(Math.sqrt(2)*n,Math.sqrt(2)*n);
	if(k%2==0) w1=Complex.times(w1,z11);
	if(k%2==1) w1=Complex.times(w1,z12);
	if(k%2==0) w2=Complex.times(w2,z21);
	if(k%2==1) w2=Complex.times(w2,z22);
	for(int i=0;i<8;++i) P.z[i]=Complex.plus(P.z[i],w1);
	for(int i=0;i<8;++i) P.z[i]=Complex.plus(P.z[i],w2);
	return(P);
    }

    /**This is the central octagon*/

    public static PolygonWrapper octagon(double s) {
	PolygonWrapper P=new PolygonWrapper();
	P.count=8;
	Complex w=new Complex(0,1);
	P.z[0]=new Complex(s,1-s);
	P.z[1]=new Complex(1-s,s);
	for(int i=0;i<3;++i) {
	    P.z[2*i+2]=Complex.times(w,P.z[2*i+0]);
	    P.z[2*i+3]=Complex.times(w,P.z[2*i+1]);
	}
	return(P);
    }

    public static PolygonWrapper dogbone(double s,int k,int m,int n) {
	PolygonWrapper P1=octagon(s,k,m,n);
	PolygonWrapper P2=new PolygonWrapper(P1);
	for(int i=0;i<8;++i) P2.z[i].x=P2.z[i].x+2;
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=8;
	Q.z[0]=P1.z[6];
	Q.z[1]=P1.z[7];
	Q.z[2]=P1.z[0];
	Q.z[3]=P1.z[1];
	Q.z[4]=P2.z[2];
	Q.z[5]=P2.z[3];
	Q.z[6]=P2.z[4];
	Q.z[7]=P2.z[5];
	return(Q);
    }




    public static PolygonWrapper halfbone(double s,int j,int k) {
	PolygonWrapper P=halfbone(s,k);
	if(j==0) return(P);
	for(int i=0;i<4;++i) P.z[i].x=P.z[i].x+2;
	return(P);
    }

    public static PolygonWrapper halfbone(double s,int j) {
	if(j==0) return(halfbone0(s));
	return(halfbone1(s));
    }


    public static PolygonWrapper halfbone0(double s) {
	PolygonWrapper P1=octagon(s,0,0,0);
	PolygonWrapper P2=octagon(s,1,1,0);
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=4;
	Q.z[0]=P1.z[2];
	Q.z[1]=P2.z[3];
	Q.z[2]=P2.z[4];
	Q.z[3]=P2.z[5];
	return(Q);
    }

    public static PolygonWrapper halfbone1(double s) {
	PolygonWrapper P1=octagon(s,0,0,0);
	PolygonWrapper P2=octagon(s,7,1,0);
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=4;
	Q.z[0]=P1.z[5];
	Q.z[1]=P2.z[2];
	Q.z[2]=P2.z[3];
	Q.z[3]=P2.z[4];
	return(Q);
    }

    public static PolygonWrapper parallelogram(int k,double s) {
	if(k%2==0) return(parallelogram0(k,s));
	if(k%2==1) return(parallelogram1(k,s));
	return(null);
    }

    public static PolygonWrapper parallelogram(int k,int m,int n,double s) {
	PolygonWrapper P=parallelogram(k,s);
	double t=2*Math.PI*k/8;
	Complex w1=new Complex(Math.cos(t),Math.sin(t));
	Complex w2=new Complex(Math.cos(t),Math.sin(t));
	Complex z11=new Complex(2*m,0);
	Complex z12=new Complex(2*Math.sqrt(2)*s*m,0);
	Complex z21=new Complex(2*n*s,2*n*s);
	Complex z22=new Complex(Math.sqrt(2)*n,Math.sqrt(2)*n);
	if(k%2==0) w1=Complex.times(w1,z11);
	if(k%2==1) w1=Complex.times(w1,z12);
	if(k%2==0) w2=Complex.times(w2,z21);
	if(k%2==1) w2=Complex.times(w2,z22);
	for(int i=0;i<4;++i) P.z[i]=Complex.plus(P.z[i],w1);
	for(int i=0;i<4;++i) P.z[i]=Complex.plus(P.z[i],w2);

	//for(int i=0;i<4;++i) P.z[i]=P.z[i].conjugate();


	return(P);
    }

    /*k even*/

    public static PolygonWrapper parallelogram0(int k,double s) {
	double t=2*Math.PI*k/8;
	Complex w=new Complex(Math.cos(t),Math.sin(t));
	PolygonWrapper P=new PolygonWrapper();
	P.count=4;
	P.z[0]=new Complex(1-s,-s);
	P.z[1]=new Complex(1+s,+s);
	P.z[2]=new Complex(3+s,+s);
	P.z[3]=new Complex(3-s,-s);
	for(int i=0;i<4;++i) P.z[i]=Complex.times(w,P.z[i]);
	return(P);
    }

    /*k odd*/
    public static PolygonWrapper parallelogram1(int k,double s) {
	double t=2*Math.PI*(k+1)/8;
	Complex w=new Complex(Math.cos(t),Math.sin(t));
	PolygonWrapper P=parallelogram0(0,s);
	for(int i=0;i<4;++i) {
             P.z[i]=Complex.minus(P.z[i],new Complex(2-2*s,0));
	     P.z[i]=P.z[i].conjugate();
	     P.z[i]=Complex.minus(P.z[i],new Complex(0,2*s));
	     P.z[i]=Complex.times(P.z[i],w);
	}
	return(P);
    }


    public static int[] locateParallelogram(double s,Complex z) {
	for(int i=0;i<8;++i) {
	    for(int a=0;a<10;++a) {
	       for(int j=0;j<=a;++j) {
		for(int k=0;k<=a;++k) {
		    PolygonWrapper P=parallelogram(i,j,k,s);
		    GeneralPath gp=P.toGeneralPath();
		    if(gp.contains(z.x,z.y)==true) {
			int[] I={i,j,k};
			return(I);
		    }
		}
	       }
	    }
	}
	int[] I={0,0,0};
	return(I);
    }

    public static Color getColor(int i,int j,int k) {
	Color[] COL={new Color(255,0,0),new Color(255,150,0),new Color(0,0,255),new Color(70,120,255),new Color(0,150,0),new Color(0,255,0),new Color(150,0,150),new Color(255,0,255)};
	int h=2*(i%4)+(j+k)%2;
	return(COL[h]);
    }
}

