
import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class does the math for the outer billiards map*/

public class BilliardsVerify {

    public BilliardsVerify() {}

    /*The parameter s is scaled up by SCALE*/

    public static long[] getLines(long s,int k,long SCALE) {
	long[][] t={{1,1,SCALE},{0,1,s},{-1,1,SCALE},{-1,0,s},{-1,-1,SCALE},{0,-1,s},{1,-1,SCALE},{1,0,s}};
	return(t[k]);
    }


    public static boolean testSector(LongPolygon P,LongComplex z,int k,long SCALE) {
	long s=P.z[0].x;
	int k0=(k+7)%8;
	int k1=(k+0)%8;
	long[] t0=getLines(s,k0,SCALE);
	long[] t1=getLines(s,k1,SCALE);
	long u0=z.x*t0[0]+z.y*t0[1]-t0[2];
	long u1=z.x*t1[0]+z.y*t1[1]-t1[2];
 	if(u0<0) return(false);
	if(u1>0) return(false);
	return(true);
    }

    public static LongComplex map(int k,LongComplex z, LongPolygon Q) {
	LongComplex q=Q.z[k];
	LongComplex w=new LongComplex(2*q.x-z.x,2*q.y-z.y);
        return(w);
    }

    /*This is the semiregular octagon scaled up by SCALE.
      For all the parameters under consideration,
      this leads to an integer polygon.  The parameter s
      itself has been scaled up by SCALE.*/

    public static LongPolygon getShape(long s,long SCALE) {
	LongPolygon P=new LongPolygon();
	P.count=8;
	LongComplex w=new LongComplex(0,1);
	P.z[0]=new LongComplex(s,SCALE-s);
	P.z[1]=new LongComplex(SCALE-s,s);
	for(int i=0;i<3;++i) {
	    P.z[2*i+2]=LongComplex.times(w,P.z[2*i+0]);
	    P.z[2*i+3]=LongComplex.times(w,P.z[2*i+1]);
	}
	return(P);
    }

    /*Here are the main routines.  This first one checks if the given
      point has the given vertex itinerary relative to the
      polygon P. Since we are handling boundary cases, all
      we must check is that the itinerary is feasible. An
      exception is thrown if the test fails.*/




    public static LongComplex getDisplacement(LongPolygon P,LongComplex z,int[] t,long SCALE) {
	LongComplex w=new LongComplex(z);
	boolean test=BilliardsVerify.testSector(P,w,t[0],SCALE);
	if(test==false) throw new ProofException ("halfbone");
	for(int i=0;i<t.length-1;++i) {
	    w=map(t[i],w,P);
            test=testSector(P,w,t[i+1],SCALE);
	    if(test==false) throw new ProofException("halfbone");
	}
	int i=t.length-1;
	w=map(t[i],w,P);
	LongComplex h=LongComplex.minus(w,z);
	return(h);
    }



    /*This does the same as the previous routine, but also
      computes the final map*/

    public static LongComplex dogbone(LongPolygon P,LongComplex z,int[] t,int u,boolean up,long SCALE) {
	LongComplex w=new LongComplex(z);
	boolean test=BilliardsVerify.testSector(P,w,t[0],SCALE);
	if(test==false) throw new ProofException("dogbone fail 0");
	for(int i=0;i<t.length-1;++i) {
	    w=map(t[i],w,P);
            test=testSector(P,w,t[i+1],SCALE);
	    if(test==false) throw new ProofException("dogbone fail "+i);
	}
	int i=t.length-1;
	w=map(t[i],w,P);
	long s=P.z[0].x;
	if((up==false)&&(u==1)) w=LongComplex.minus(w,new LongComplex(-2*SCALE+2*s,2*s));
	if((up==true)&&(u==1)) w=LongComplex.plus(w,new LongComplex(-2*SCALE+2*s,2*s));
	w=LongComplex.minus(w,z);
	return(w);
    }


}
