import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of complex numbers */

public class Complex {
    double x,y;
    
    public Complex() {
        this.x=0.0;
        this.y=0.0;
    } 
    
    public Complex(double x,double y) {
        this.x=x;
        this.y=y;
    }
    
    public Complex(Complex z) {
        this.x=z.x;
        this.y=z.y;
    }

    public static Complex random(Complex z1,Complex z2) {
	double s=Math.random();
	double t=Math.random();
	double x=(1-s)*z1.x+s*z2.x;
	double y=(1-t)*z1.y+t*z2.y;
	Complex z=new Complex(x,y);
	return(z);
    }
    
    public Vector toVector() {
	Vector V=new Vector();
	V.x[0]=this.x;
	V.x[1]=this.y;
	V.x[2]=0;
	V.size=3;
	return(V);
    }


    public static double norm(Complex z) {
        return Math.sqrt(z.x*z.x+z.y*z.y);
    }

    public static Complex unit(Complex z) {
        double d=z.norm(z);
        return new Complex(z.x/d,z.y/d);
    }

    public static Complex plus(Complex z1,Complex z2) {
        return new Complex(z1.x+z2.x, z1.y+z2.y);
    }

    public static Complex minus(Complex z1,Complex z2) {
        return new Complex(z1.x-z2.x, z1.y-z2.y);
    }

    public static Complex times(Complex z1,Complex z2) {
        return new Complex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }

    public static Complex inverse(Complex z) {
        double d=z.x*z.x+z.y*z.y;
        return new Complex(z.x/d,-z.y/d);
    }
    
    public static Complex divide(Complex z1,Complex z2) {
        return times(z1,inverse(z2));
    }
    
    public static Complex conjugate(Complex z) {
        return new Complex(z.x,-z.y);
    }

    public static double dot(Complex a, Complex b) {
        return a.x*b.x+a.y*b.y;
    }
    
    public static double dist(Complex a,Complex b) {
        Complex z=minus(a,b);
        return(norm(z));
    }
    
    public double norm() {
        return Math.sqrt(x*x+y*y);
    }
    
    public Complex conjugate() {
        return new Complex(x,-y);
    }

    
  public static double area(Complex z1,Complex z2,Complex z3) {
        double a;
        Complex[] z=new Complex[5];
        z[1]=z1.minus(z2,z1);
        z[2]=z1.minus(z3,z1);
        z[3]=z1.conjugate(z[2]);
        z[4]=z1.times(z[1],z[3]);
        a=-z[4].y;
        return(a);
    }

    public static int  isPositivelyOriented(Complex z1,Complex z2,Complex z3) {
        Complex[] z=new Complex[5];
        for(int i=1;i<=4;++i) z[i]=new Complex();
        z[1]=Complex.minus(z2,z1);
        z[2]=Complex.minus(z3,z1);
        z[3]=Complex.conjugate(z[2]);
        z[4]=Complex.times(z[1],z[3]);
	if(z[4].y<0) return(1);
	return(0);
    }


    public void print() {
	System.out.println("Complex: "+this.x+" "+this.y);
    }
}

