import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ComputeBilliards implements Runnable {
    boolean HALT;
    Manager M;
    PolygonWrapper P;
    Complex SOURCE;
    double SHAPE;
    int SKIP;


    public ComputeBilliards() {
	HALT=true;
    }

    public ComputeBilliards(Manager MM) {
	this.M=MM;
	SOURCE=new Complex(M.P.SOURCE);
	SHAPE=M.C.SHAPE.getParameter();
	HALT=true;
	SKIP=M.C.SKIP2.val;
    }

    public void run() { 
	HALT=false;
	int mode=M.C.DYN2.mode;
	if(mode==1) drawOrbit(SOURCE,false);
	if(mode==2) drawOrbit(SOURCE,true);
	if(mode==3) carpetPlot();
	if(mode==4) carpetPlotWide();
	if(mode==5) dogbone(SOURCE,false,true);
	if(mode==6) dogbone(SOURCE,false,false);
	HALT=true;
    }


    public void drawTile(Complex z) {
	PolygonWrapper Q=tile(z);
	GeneralPath gp=Q.toGeneralPath();
	sendTile(gp);
	M.P.repaint();
    }

    public PolygonWrapper translateTile(PolygonWrapper P,Complex z0,Complex z) {
	Complex w=Complex.minus(z,z0);
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=P.count;
	for(int i=0;i<P.count;++i) Q.z[i]=Complex.plus(P.z[i],w);
	return(Q);
    }

    public void sendTile(GeneralPath gp) {
	M.P.GP[M.P.COUNT]=new GeneralPath(gp);
	M.P.COL[M.P.COUNT]=M.C.CS.C;
	++M.P.COUNT;
    }


    public PolygonWrapper tile(Complex z) {
	double[] D=getList(z);
	PolygonWrapper Q=preTile(D);
	for(int i=0;i<Q.count;++i) Q.z[i]=Complex.plus(Q.z[i],z);
	return(Q);
    }

    public void drawOrbit(Complex zz,boolean total) {
	PolygonWrapper Q0=tile(zz);
	PolygonWrapper P=BilliardsShapes.octagon(SHAPE);
	Complex z0=new Complex(zz);
	Complex z=new Complex(z0);
	boolean test=false;
	int count=0;
	int lim=(int)(Math.pow(2,M.C.LIMIT.val));
	GeneralPath gp2=new GeneralPath();
	while((test==false)&&(count<lim)) {
	    PolygonWrapper Q=translateTile(Q0,z0,z);
	    GeneralPath gp=Q.toGeneralPath();
	    sendTile(gp);   
            ++count;
            for(int q=0;q<SKIP;++q) z=BilliardsMap.nextPoint(z,P);
	    if(Complex.dist(z,z0)<.0000001) test=true;
	    if((total==false)&&(count==M.C.NUMBER.val)) test=true;
	}
	M.P.repaint();
    }

    public void dogbone(Complex zz,boolean total,boolean choice) {
	int SHIFT=M.C.DOG.val;
	PolygonWrapper Q0=tile(zz);
	PolygonWrapper P=BilliardsShapes.octagon(SHAPE);
	Complex z0=new Complex(zz);
	Complex z=new Complex(z0);
	boolean test=false;
	int count=0;
	while((test==false)&&(count<M.C.LIMIT.val)) {
	    PolygonWrapper Q=translateTile(Q0,z0,z);
	    GeneralPath gp=Q.toGeneralPath();
	    sendTile(gp);   
            ++count;
            if(choice==true) z=BilliardsMap.dogbone(SHIFT,z,SHAPE,P);
            if(choice==false) z=BilliardsMap.halfbone(SHIFT,z,SHAPE,P);
	    if(Complex.dist(z,z0)<.0000001) test=true;
	    if((total==false)&&(count==M.C.NUMBER.val)) test=true;
	}
	M.P.repaint();
    }


    public double[] getList(Complex zz) {
	double[] D=new double[8];
	for(int i=0;i<8;++i) D[i]=2;
	PolygonWrapper P=BilliardsShapes.octagon(SHAPE);
	Complex z0=new Complex(zz);
	Complex z=new Complex(z0);
	boolean test=false;
	int count=0;
	while((test==false)&&(count<100000)) {
	    if(count%2==0) D=BilliardsMap.updateList(P,z,D,0);
	    if(count%2==1) D=BilliardsMap.updateList(P,z,D,4);
	    z=BilliardsMap.nextPoint(z,P);
	    if(Complex.dist(z,z0)<.000000001) test=true;
	    ++count;
	}
	return(D);
    }

    public PolygonWrapper preTile(double[] D) {
	PolygonWrapper P=BilliardsShapes.octagon(SHAPE);
	PolygonWrapper Q1=new PolygonWrapper();
	Q1.count=4;
	Q1.z[0]=new Complex(+D[7],+D[1]);
	Q1.z[1]=new Complex(-D[3],+D[1]);
	Q1.z[2]=new Complex(-D[3],-D[5]);
	Q1.z[3]=new Complex(+D[7],-D[5]);

	double t=Math.sqrt(2)/2;
	PolygonWrapper Q2=new PolygonWrapper();
	Q2.count=4;
	Q2.z[0]=new Complex(t*(+D[0]-D[2]),t*(+D[0]+D[2]));
	Q2.z[1]=new Complex(t*(-D[2]-D[4]),t*(+D[2]-D[4]));
	Q2.z[2]=new Complex(t*(-D[4]+D[6]),t*(-D[4]-D[6]));
	Q2.z[3]=new Complex(t*(+D[6]+D[0]),t*(-D[6]+D[0]));


	PolygonWrapper Q=PolygonWrapper.intersect(Q1,Q2);
	return(Q);
    }


    public void carpetPlot() {
        PolygonWrapper P=BilliardsShapes.dogbone(SHAPE,0,1,0);
	GeneralPath gp=P.toGeneralPath();
	carpetPlot(gp);
    }

    public void carpetPlotWide() {
	for(int i=0;i<8;++i) {
	    for(int j=0;j<2;++j) {
	      for(int k=0;k<2;++k) {
	        HALT=false;
	        PolygonWrapper P=BilliardsShapes.parallelogram(i,j,k,SHAPE);
	        carpetPlot(P.toGeneralPath());
	      }
	    }
	}
    }

    public void carpetPlot(GeneralPath gp) {
	PolygonWrapper Q=BilliardsShapes.octagon(SHAPE);
	GeneralPath gp2=Q.toGeneralPath();
	long t1=Time.time();
	Complex[] bound=GraphicsHelp.getBounds(gp);
	Complex w=new Complex();
	int COUNT=0;
	while(HALT==false) {
	    long t2=Time.time();
	    long t3=t2-t1;
	    if(t3>1000) HALT=true;
	    w=Complex.random(bound[0],bound[1]);
	    if((gp2.contains(w.x,w.y)==false)&&(gp.contains(w.x,w.y)==true)) {
		int t=M.P.getIndex(w);
		if(t==-1) {
		    drawTile(w);
		    t1=Time.time();
		}
	    }
	}
	M.C.repaint();
	M.P.repaint();
    }
}

