import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends Canvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    SelectColor CS;
    ShapeEntrySystem SHAPE;
    ControlPanelColor DISPLAY,OB;
    ControlPanel DYN1,DYN2,CHOICE,EXACT,GEN,PROOF;
    ListenSquare GO,STOP,CANONICAL;
    ComputePET CP;
    ComputeBilliards CB;
    ComputeProof CPR;
    Generate G;
    SelectInteger POLY1,POLY2;
    ListenSquare INFO1,INFO2,INFO3,INFO4; 
    SelectInteger LIMIT,SKIP1,SKIP2,NUMBER;
    String[] MESSAGE=new String[11];
    ListenSquare LINK,LINKDUMMY;
    SelectInteger DOG;


     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setControlPanels();
	 setColorPanels();
	 setComputers();
	 setModifiers();
	 MESSAGE[0]="message center";
	 for(int i=1;i<11;++i) MESSAGE[i]="";
	 LINK=new ListenSquare(245,233,168,28);
	 LINKDUMMY=new ListenSquare(245,233,167,28);
	 LINK.on=1;
     }

    public void setModifiers() {
        CS=new SelectColor(M,3,38,410,50);
	SHAPE=new ShapeEntrySystem(3,2,"3/4",new Color(70,0,70));
        NUMBER=new SelectInteger(350,280,40,20,2,1,12,1);
	SKIP1=new SelectInteger(350,330,40,20,2,1,12,1);
	SKIP2=new SelectInteger(350,380,40,20,2,1,12,1); 
        LIMIT=new SelectInteger(250,280,40,20,15,0,20,1);
	POLY1=new SelectInteger(100,301,40,19,0,0,19,1);
	POLY2=new SelectInteger(100,323,40,19,0,0,3,1);
	DOG=new SelectInteger(100,370,40,20,1,0,3,1);
	INFO1=new ListenSquare(401,265,12,12);
	INFO2=new ListenSquare(401,90,12,12);
	INFO3=new ListenSquare(401,0,12,12);
	INFO4=new ListenSquare(401,233,12,12);
     }


    public void setComputers() { 
         GO=new ListenSquare(250,373,60,30);
	 STOP=new ListenSquare(250,340,60,30);

	 CP=new ComputePET();	 
	 CB=new ComputeBilliards();
	 CPR=new ComputeProof();
	 G=new Generate();	 
    }

    public void setControlPanels() {	 
         Color[] C0={new Color(70,120,255),Color.white,Color.white,Color.black,Color.red};
         Color[] C1={new Color(100,0,180),Color.white,Color.white,Color.white,Color.red};
         Color[] C2={new Color(0,0,70),Color.white,Color.white,Color.white,Color.red};
         Color[] C3={new Color(200,0,0),Color.white,Color.white,Color.white,Color.red};

	 //choice
	 String[] ChoiceString={"PET","OB","generate","proofs","calc choice"};
	 int[] ChoiceState={1,0,0,0};
          CHOICE=new ControlPanel(C1,ChoiceString,ChoiceState,4);
	  CHOICE.mode=0;

	 //gen
	  String[] GenString={"partition2","partition4","feasible","LaTeX","generate"};
	  int[] GenState={1,0,0,0};
          GEN=new ControlPanel(C1,GenString,GenState,4);
	  GEN.mode=0;

	 //proof
	  String[] ProofString={"octagon","dogbone","halfbone","volumes","partition","proof calcs"};
	  int[] ProofState={1,0,0,0,0};
          PROOF=new ControlPanel(C1,ProofString,ProofState,5);
	  PROOF.mode=0;

	 //action_dyn1 for the PET
	  String[] Action_dyn1String={"none","single","orbit","carpet","PET action"};
	  int[] Action_dyn1State={1,0,0,0};
         DYN1=new ControlPanel(C1,Action_dyn1String,Action_dyn1State,4);
	 DYN1.mode=0;

	 //action_dyn2 for outer billiards
	  String[] Action_dyn2String={"none","single","orbit","carpet","carpet2","dogbone","halfbone","OB action"};
	  int[] Action_dyn2State={1,0,0,0,0,0,0};
         DYN2=new ControlPanel(C1,Action_dyn2String,Action_dyn2State,7);
	 DYN2.mode=0;
    }


    public void setColorPanels() {
         Color[] C1={new Color(100,0,180),Color.white,Color.white,Color.white,Color.red};

	 Color[] DISPLAYCOLOR={new Color(255,0,255,120),new Color(255,0,255,120),new Color(0,0,255,100),new Color(0,0,255,100),new Color(255,0,255,100),new Color(0,100,255,220),new Color(100,0,120),Color.yellow};
	 String[] DisplayString0={"para.","dogbone","P1","IP1","P2","P3","P4","P3 piece","PET display"};
	 int[] DisplayState={0,1,0,0,0,0,0,0};
         DISPLAY=new ControlPanelColor(C1,DisplayString0,DisplayState,8,DISPLAYCOLOR);

	 Color CW=Color.white;

	 Color[] OBCOLOR={CW,CW,new Color(255,255,255,20),new Color(0,0,255,100),new Color(50,0,100,150),new Color(100,0,0),new Color(70,0,0),Color.pink,Color.red};
	 String[] ObString0={"tiling1","tiling2","strips","barrier","octagons","dogbone1","dogbone2","halfbones","dogbones","OB display"};
	 int[] ObState={0,0,0,0,0,0,0,0,0};
         OB=new ControlPanelColor(C1,ObString0,ObState,9,OBCOLOR);
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawPanels(g); 
      drawMessage(g);
      drawFrame(g);
   }


    public void drawBG(Graphics2D g) {
	g.setColor(new Color(0,0,100));
        g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawMessage(Graphics2D g) {
	g.setColor(new Color(0,40,80));
	g.fillRect(182,90,231,139);
	g.setColor(Color.white);
	g.drawRect(182,90,231,139);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
        g.setColor(Color.white);
	for(int i=0;i<8;++i) {
	    g.drawString(MESSAGE[i],190,105+16*i);
	}
 	INFO2.infoRender(g);
    }


    public void drawFrame(Graphics2D g) {
	g.setColor(new Color(50,100,255));
	g.fillRect(415,0,10,420);
	g.fillRect(0,410,420,10);
	DOG.render(g,new Color(100,0,255),Color.white,Color.white);
	g.drawString("dogbone",105,402);

	g.setColor(new Color(0,0,255));
	g.fillRect(245,265,168,143);
	g.setColor(Color.white);
	g.drawRect(245,265,168,143);

        g.setFont(new Font("Helvetica",Font.PLAIN,15));  
	LINK.render(g,new Color(200,0,200));  
	LINKDUMMY.render(g,new Color(0,0,0,0));
        g.drawString("link",(int)(LINK.x+70),(int)(LINK.y+20));
	SHAPE.render(g); 
	LIMIT.render2(g,new Color(60,120,255),Color.white,Color.white,"orbit limit");
	NUMBER.render(g,new Color(60,120,255),Color.white,Color.white,"# iterates");
	SKIP1.render(g,new Color(60,120,255),Color.white,Color.white,"PET power");
	SKIP2.render(g,new Color(60,120,255),Color.white,Color.white,"OB power");
        CS.render(g);
	drawPieceSelector(g);
	INFO1.infoRender(g);
	INFO3.infoRender(g);
	INFO4.infoRender(g);
        g.setFont(new Font("Helvetica",Font.PLAIN,20));  
	if(isIdle()==true) {
            GO.render(g,new Color(60,120,255));  
            g.drawString("go",(int)(GO.x+12),(int)(GO.y+20));
	}
	if(isIdle()==false) {     
           g.setFont(new Font("Helvetica",Font.PLAIN,20));
           STOP.render(g,Color.red);
	   g.drawString("stop",(int)(STOP.x+12),(int)(STOP.y+20));
	}
    }

    public void drawPieceSelector(Graphics2D g) {
	g.setColor(new Color(100,0,200));
	g.fillRect(100,300,80,63);
	g.setColor(Color.white);
	g.drawRect(100,300,80,63);
	POLY1.render(g,new Color(150,60,250),Color.white,Color.white);
	POLY2.render(g,new Color(150,60,250),Color.white,new Color(0,0,0,0));
	Integer I=new Integer(20*POLY2.val+POLY1.val);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));  
	g.setColor(Color.white);
	g.drawString(I.toString(),150,338);
	g.drawString("partition",105,358);


    }


    public void drawPanels(Graphics2D g) {
        CHOICE.render(g,100,90,80);
 	if(CHOICE.mode==0) DYN1.render(g,100,173,80); 
 	if(CHOICE.mode==1) DYN2.render(g,100,173,80); 
 	if(CHOICE.mode==2) GEN.render(g,100,173,80);  
 	if(CHOICE.mode==3) PROOF.render(g,100,173,80); 
        DISPLAY.render(g,3,90,94);
	OB.render(g,3,233,94);
    }

    /*These are the computational routines.*/

    public boolean doAction() {
	if(isIdle()==false) return(false);
	if(CHOICE.mode==0) computePET();
	if(CHOICE.mode==1) computeOB();
	return(true);
    }

    public boolean isIdle() {
        if(CP.HALT==false) return(false);
        if(CB.HALT==false) return(false);
	return(true);
    }
  
    public boolean doAction(Point X) {
	if((STOP.inside(X)!=1)&&(GO.inside(X)!=1)) return(false);
	if((STOP.inside(X)==1)&&(isIdle()==false)) {
	   CP.HALT=true;
	   return(true);
	}

	if((isIdle()==true)&&(GO.inside(X)==1)) {
	  if(CHOICE.mode==0) computePET();
	  if(CHOICE.mode==1) computeOB();
	  if(CHOICE.mode==2) generate();
	  if(CHOICE.mode==3) computeProof();
	  return(true);
	}
	return(false);
    }

    public void computePET() {
       CP=new ComputePET(this.M);
       new Thread(CP).start();
    }

    public void computeOB() {
       CB=new ComputeBilliards(this.M);
       new Thread(CB).start();
    }

    public void generate() {
       G=new Generate(this.M);
       new Thread(G).start();
    }

    public void computeProof() {
       CPR=new ComputeProof(this.M);
       new Thread(CPR).start();
    }



    /**end computational routines*/

    public double getParameter() {
	return(SHAPE.getParameter());
    }

    public void modifyPanels(Point X) {
	DISPLAY.process(X,CS.C);
	OB.process(X,CS.C);
	if(CHOICE.mode==0) DYN1.switchMode(X);
	if(CHOICE.mode==1) DYN2.switchMode(X);
	if(CHOICE.mode==2) GEN.switchMode(X);
	if(CHOICE.mode==3) PROOF.switchMode(X);
	CHOICE.switchMode(X);
	NUMBER.modify(X);
	SKIP1.modify(X);
	SKIP2.modify(X);
	DOG.modify(X);
	LIMIT.modify(X);
	if((INFO4.inside(X)==0)&&(LINK.inside(X)==1)) LINK.on=1-LINK.on;
	setDogbone();
	setHalfbone();
    }

    public boolean setDogbone() {
	if(CHOICE.mode!=1) return(false);
	if(DYN2.mode!=5) return(false);
	OB.L[5].on=1;
	OB.L[6].on=1;
	OB.L[7].on=0;
	if(DOG.val==0) ++DOG.val;
	DOG.max=3;
	return(true);
    }

    public boolean setHalfbone() {
	if(CHOICE.mode!=1) return(false);
	if(DYN2.mode!=6) return(false);
	OB.L[5].on=1;
	OB.L[6].on=0;
	OB.L[7].on=1;
	if(DOG.val==2) --DOG.val;
	DOG.max=2;
	return(true);
    }



  public boolean setShape(MouseEvent e) {  
    boolean test=SHAPE.process(e); 
    if(test==true) {
	M.P.COUNT=0;
	M.B.COUNT=0;
    }
    return(true);
  }

    public void assign(int count,int[] p) {
	double d=1.0*p[1]/p[0];
	int k=MathRational.convert(Math.floor(d));
	Integer K=new Integer(k);
        Integer p0=new Integer(p[0]);
	Integer p1=new Integer(p[1]);
	MESSAGE[count]="("+K.toString()+") "+p0.toString()+"/"+p1.toString();
    }

    public void polySelector(Point X) {
       POLY1.modify(X);
       POLY2.modify(X);
    }

    public void documentStuff(Point X) {
	int test;
	Documentation DOC=new Documentation();
	DOC.M=this.M;
	if(CS.INFO.inside(X)==1) DOC.colorSelectorInfo();
	if((CHOICE.mode==0)&&(DYN1.getInfo(X)==true)) DOC.petPlotInfo();
	if((CHOICE.mode==1)&&(DYN2.getInfo(X)==true)) DOC.OBPlotInfo();
	if((CHOICE.mode==2)&&(GEN.getInfo(X)==true)) DOC.generateInfo();
	if((CHOICE.mode==3)&&(PROOF.getInfo(X)==true)) DOC.proofInfo();
	if(CHOICE.getInfo(X)==true) DOC.calcInfo();
	if(DISPLAY.getInfo(X)==true) DOC.PETDisplayInfo();
	if(OB.getInfo(X)==true) DOC.OBDisplayInfo();
	if(INFO1.inside(X)==1) DOC.goInfo();
	if(INFO2.inside(X)==1) DOC.messageInfo();
	if(INFO3.inside(X)==1) DOC.shapeEntryInfo();
	if(INFO4.inside(X)==1) DOC.linkInfo();
    }
    
    public void mouseClicked(MouseEvent e) {  
        MouseData J=MouseData.process(e);
        CS.process(e);  
	polySelector(J.X);

	modifyPanels(J.X);
	setShape(e);
	doAction(J.X);
	documentStuff(J.X);
	M.repaint();
    }


    public void mousePressed(MouseEvent e) {
    }

     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
    public void mouseDragged(MouseEvent e) { }

     public void keyPressed(KeyEvent e) {}
     public void keyReleased(KeyEvent e) {}
     public void keyTyped(KeyEvent e) {	
         SHAPE.processKey(e);
         repaint();
     }


}

