
import java.awt.geom.*;

/*This class gets the polyhedra for the polygon exchange map. 
  We have a 1-parameter family of polygon exchanges, and they
  fit together to make a fiber bundle which is an affine polyhedron
  exchange*/

public class DataPartition1 {

    /**There are 13 polyhedra in the partition from s=1/2 to s=1. We scale
       up the picture by 840 so that we can work with integer polyhedra*/
    
    /*This is the partition of the parallelogram*/

    public static LongPolyhedron poly0(int k) {
	int[][] u=polyInt(k);
	LongPolyhedron P=LongPolyhedron.fromIntegerList(840,u);
	P.MOVE=move(k);
	P.FACE=DataPartition1Raw.faceList(k);
	return(P);
    }

    /**The negative pieces are translated to the right to give the
       partition of the dogbone.*/

    public static LongPolyhedron poly(int k) {
	int[][] u=polyInt(k);
	LongPolyhedron P=LongPolyhedron.fromIntegerList(840,u);
	if(P.V[0].x[0]<0) P=P.translateRight();
	P.MOVE=move(k);
	P.FACE=DataPartition1Raw.faceList(k);
	return(P);
    }

    public static int[][] polyInt(int k) {
	if(k==0) return(DataPartition1Raw.poly0());
	if(k==1) return(DataPartition1Raw.poly1());
	if(k==2) return(DataPartition1Raw.poly2());
	if(k==3) return(DataPartition1Raw.poly3());
	if(k==4) return(DataPartition1Raw.poly4());
	if(k==5) return(DataPartition1Raw.poly5());
	if(k==6) return(DataPartition1Raw.poly6());
	if(k==7) return(reflect(DataPartition1Raw.poly1()));
	if(k==8) return(reflect(DataPartition1Raw.poly2()));
	if(k==9) return(reflect(DataPartition1Raw.poly3()));
	if(k==10) return(reflect(DataPartition1Raw.poly4()));
	if(k==11) return(reflect(DataPartition1Raw.poly5()));
	if(k==12) return(reflect(DataPartition1Raw.poly6()));
	return(null);
    }

    /**This takes the arithmetic graph data for the
       polyhedron and converts it into an affine map.*/

    public static LongAffine fromIntegers(int[] t) {
	LongMatrix m=new LongMatrix();
	m.a[0][0]=1;
	m.a[1][0]=0;
	m.a[2][0]=0;
	m.a[0][1]=0;
	m.a[1][1]=1;
	m.a[2][1]=0;
	m.a[0][2]=-2*t[3]+2*t[1];
	m.a[1][2]=-2*t[3]-2*t[1];
	m.a[2][2]=1;
	LongVector v=new LongVector(-2*t[0],2*t[2],0);
	LongAffine A=new LongAffine(m,v);
	return(A);
    }

    /**The PET we usually use, f=(f')^2*/

    public static int[] move(int k) {
        int[][] t=DataPartition1Raw.move();
	if(k<7) return(t[k]);
	int[] s=t[k-6];
        for(int i=0;i<4;++i) s[i]=-s[i];
	return(s);
    }

    /**reflection in the origin*/

    public static int[] reflect(int[] s) {
	int[] t={-s[0],s[1],-s[2],s[3],s[4],s[5]};
	return(t);
    }

    public static int[][] reflect(int[][] s) {
	int[][] t=new int[s.length][6];
	for(int i=0;i<s.length;++i) t[i]=reflect(s[i]);
	return(t);
    }



}