import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;




public class Documentation {
    Manager M;

    public Documentation() {}

    public void messageInfo() {
        String S="message center.";

	S=S+"\n\nSometimes the program will write messages here to let you know the results of some calculation.";

	S=S+"\n\nIf you want to find out the coordinates of the vertices of a tile, you can move the cursor over the tile and press 'a'.  The coordinates all have the form p/q, where q is the denominator of the rational parameter.";

	S=S+"\n\nWhen you run the integer arithmetic calculations associated to the proof, the message center will show a brief record of the calculation.";

	S=S+"\n\nOccasionally, you may select an object (such as 'mod1') which is only defined for parameters in a certain range. If you try to view this object outside the parameter range, you'll get a message to the effect that you are out of range. I have not been completely systematic in writing in these messages.";

        M.D.setExplain(S);
        M.D.repaint();
    }

    public void colorSelectorInfo() {
        String S="color selector.";

S=S+"\n\nWhen you plot tiles in the PET windows, you can select the color of the plot using this interface.  You can click and drag the mouse in the three bars to the left in order to change the red, green, and blue components of the color. You can also click or drag on the bottom bar in order to change the transparency level of the color.  It is best to experiment around to see how this works.  When you have altered the color selector the new color will appear in the vertical bar.";

        S=S+"\n\nThere is also a preset palette of colors on the right hand side of the color selector.  You can select these colors  by clicking on the squares.";

	S=S+"\n\nSome of the control panels have 2 columns of buttons.  The right column of buttons selects and de-selects the objectes.  The left column of buttons determines the colors of the objects. You can change these colors by first choosing a color on the color selector and then clicking on a button in the left column.";

        M.D.setExplain(S);
        M.D.repaint();
    }

    public void PETDisplayInfo() {
        String S="PET display panel.";

	S=S+"\n\nThis panel lets you display some auxiliary objects associated with the octagonal PET.";

	S=S+"\n\npara.: The PET is defined in terms of a pair F1, F2 of fundamental domains and a pair L1, L2 of lattices. This option lets you show F1.  For OctaPET, F1 was the main domain of interest but here we have a different domain of interest.";

	S=S+"\n\ndogbone: This is the main domain of interest here.  We get the dogbone as follows.  The domain F1-F2 consists of two components and is symmetric with respect to reflection in the origin.  Call these two domains L and R.  The dogbone is R union T(L), where T is translation by 2 units.  If you turn on both para. and dogbone, you can see the relation between the two.";


	S=S+"\n\nP1: This is a union of 12 polyhedra which comprise the domains of continuity for the 3D affine OctaPET.  When we take these polyhedra and intersect them with each fiber, we get the domains of continuity for the octaPET at that parameter.";


	S=S+"\n\nIP1: This is a union of 12 polyhedra which comprise the domains of continuity for the inverse map of the 3D affine PET.  When we take these polyhedra and intersect them with each fiber, we get the domains of continuity for the inverse of the octaPET at that parameter.";


	S=S+"\n\nP2: This is a union of 40 polyhedra which comprise the domains of continuity for the map f^2, where f is the affine OctaPET.  When we intersect these polyhedra with each fiber, we get the domains of continuity for the second power of the octaPET at that parameter. These polyhedra are also domains of continuity for the affine dogbone map in the outer billiards window.";


	S=S+"\n\nP3: This is a union of 80 polyhedra which fill the halfbone domain.  These polyhedra are almost the domains of continuity for the affine halfbone maps in the outer billiards window.  However, there are 4 glitches:  The pieces (0,28,58,67) do not work.  The affine halfbone map is not continuous on these pieces.";


	S=S+"\n\nP4: This is a union of 25 polyhedra obtained by splitting up the pieces (0,28,58,67) from P3 into smaller pieces.  These smaller pieces are part of the partition for the 4th power of the affine octaPET.  These pieces are all domains of continuity for the affine halfbone map.";

	S=S+"\n\npiece: This turns on a feature whereby you can sample the 80 polyhedra in the partition P3.";

        M.D.setExplain(S);
        M.D.repaint();
    }


    public void OBDisplayInfo() {
        String S="outer billiards display panel";

	S=S+"\n\nThis panel lets you display some auxiliary objects associated with the outer billiards window.";

	S=S+"\n\noutline: One way to state our main result is that there is a tiling of the plane (minus the central shape) by parallelograms such that the periodic tiling associated to outer billiards relative to the central shape agrees with the octaPET tiling in each parallelogram.  This feature shows the outlines of these parallelograms.  You can see our result in action by doing the following.";

	S=S+"\n\n1. Turn on the PET plot option and select 'carpet'. Do the carpet plot.";
	S=S+"\n\n2. Turn on the 'para' option on the PET display and turn off the 'dogbone option.";
	S=S+"\n\n3. Turn on the OB plot option and select 'carpetw'. Do the carpet2 plot.";

	S=S+"\n\nIt is best to pick a simple parameter, like 3/4 or 3/5, to avoid a long calculation.";

	S=S+"\n\ntiling: This shows the same parallelograms as in the previous option, except that they are colored in.";

	S=S+"\n\noctagons: This shows the octagonal neckace orbits.  These orbits are not very interesting, but they cut the plane into the dogbone regions which are interesting.";

	S=S+"\n\ndogbone1: This option activates the display of the dogbones which lie to the right of the central shape, along the x-axis.  The purple arrow keys allow you to select one of several of these dogbones.  These dogbones comprise part of the domains for the dogbone and halfbone maps.";

	S=S+"\n\ndogbone2: This option activates the display of another set of dogbones, lying just above the previously mentioned ones.  A fundamental domain for the dogbone map is a union of the two dogbones  highlighted when you select this option and the dogbone1 option.  For each position of the pair of dogbones, we can consider the same map. We only consider the innermost 3 maps.  It turns out that these maps are all conjugate to each other.";

	S=S+"\n\nhalfbones: A halfbone is one half of a dogbone, split along a diagonal line.  The halfbone domain consists of dogbone1 and two halfbones. When you select dogbone1 and the halfbones, you can see the fundamental domain.  Again, there is a halfbone for each position of the fundamental domain, but we only consider the 2 innermost positions.  One of our main results is that these two maps are conjugate.";

        M.D.setExplain(S);
        M.D.repaint();
    }








    public void shapeEntryInfo() {
        String S="parameter selection.";

	S=S+"\n\nThis long and thin region allows you to select a parameter for the system. The top region corresponds to the system shown in top left window and the bottom region corresponds to the system shown in the bottom left window.  The regions are color-coded, so that you can remember which region corresponds to which picture window.";

	S=S+"\n\nThere are 3 ways to enter in a parameter:\n\n1.Use the keyboard to enter in a rational number, such as 3/4 or 21/35.  The number should be strictly between 0 and 1.\n\n2. Press the red button to select a random number of the form k/100, where k=1,...,99.\n\n3. Use the arrow keys to change the fraction from p/q to (p-1)/q or (p+1)/q depending on which side you press. If q is large you can sample many parameters in order.";

        M.D.setExplain(S);
        M.D.repaint();
    }

    public void linkInfo() {
        String S="window link.";

	S=S+"\n\nThe dogbone region in the upper left PET window has many translation copies in the lower left OB window.  When the 'link' button is on, the points in the PET dogbone are linked to the points in 'dogbone1' in the OB window. Turn on the 'dogbone1' display on the 'OB display' panel to best see this feature' A click on either window will move the cursor in both windows.\n\nThe whole point of BonePet is to show that the tilings produced in the two dogbones, by the two systems, are translation equivalent.  You can see this in action by alternately using the dogbone plot in the PET and OB windows.  (In the PET window, the dogbone plot is the same as the single plot.";

        M.D.setExplain(S);
        M.D.repaint();
    }

    public void goInfo() {
        String S="action console.";

	S=S+"\n\n Some of the calculations can be launched by clicking directly on the left picture windows, and all of the calculations can be launched by cliocking the blue go button.  To see the range of possible calculations, click on the info bottons corresponding to the purple control panels. There are some arrow keys which modify the computations.";

S=S+"\n\norbit limit: In principle, a selected point might have a very long periodic orbit. These keys let you specify the cutoff point for the calculation.  If the calculation exceeds the cutoff, it is abandoned.  Thus, you can only plot periodic tiles corresponding to periods less than the maximum selected value.";

S=S+"\n\niterates: Referring to the PET and OB calculations, for the 'single', and 'dogbone' and 'halfbone' options, the 'iterates' key dictates how many iterates will be plotted.  The default is 2. This value lets us see an orbit tile and its image.";

S=S+"\n\nPET power: This describes which power of the map we plot when we do the OctaPET map.";

S=S+"\n\nOB power: This describes which power of the map we plot when we do the OB map.";



        M.D.setExplain(S);
        M.D.repaint();
    }

    public void goInfo2() {
        String S="action console.";

	S=S+"\n\n Some of the calculations can be launched by clicking directly on the left picture windows, and all of the calculations can be launched and selected from the blue console.  Here we describe the calculations.";

S=S+"\n\n1. PET: This makes octaPET calculation in the upper left window. There are 4 options for the PET calculations:\n\na. none: This allows you to select points in the two picture windows without plotting anything.\n\nb. single:\n\nc. orbit: This plots the entire orbit, again subject to the value on the 'power' keys.\n\ncarpet: This plots all the orbit tiles in the dobgone domain.";


	S=S+"\n\nThere are some arrow keys which modify the computations.\n\norbit limit: In principle, a selected point might have a very long periodic orbit. These keys let you specify the cutoff point for the calculation.  If the calculation exceeds the cutoff, it is abandoned.  Thus, you can only plot periodic tiles corresponding to periods less than the maximum selected value.";



        M.D.setExplain(S);
        M.D.repaint();
    }




    public void calcInfo() {
        String S="calculation options.";
	S=S+"\n\nThere are 4 options for calculation.";

        S=S+"\n\n1. PET: This does the octagonal PET in the upper left window.  The set-up here is more flexible than in OctaPET.  Here, you can choose to display the tiles in one of two domains.  The first domain is the parallelogram from OctaPET.  The second domain is the dogbone. This domain is obtained by deleting the trivial tile from the parallelogram and shifting the left half of the remainder over by 2 units.";

        S=S+"\n\n2. OB: This does the outer billiards on semi-regular octagons in the lower left window. The point of BonePET is to compare the octagonal PET to semi-regular outer billiards.";


        S=S+"\n\n3. generate: This generates some of the data files, namely the second and third partition, used in the proofs of the main results.  In principle, there is no reason to use this option.  However, we wanted to show how we generated the data tiles.  If one uses this option, one generates a data file what is written to a file called DataTemp.  One would then move DataTemp to the relevant java data file.";

        S=S+"\n\n4. proofs: This does the main calculations for the proofs.  These proofs are described in my paper, and also described to some extent in the documentation for the secondary control panel associated to this control panel.";

        M.D.setExplain(S);
        M.D.repaint();
    }
    public void proofInfo() {
        String S="proof options.";
	S=S+"\n\n the proofs are broken into 4 pieces.";

        S=S+"\n\n1. dogbone: The calculations here check that the OB dogbone map agrees with the second iterate of the octaPET map.  This is checked on the 3 innermost domains for the OB dogbone map, each domain splits into two halves. Thus, there are 6 calculations here.";

    S=S+"\n\n2. halfbone: This checks that the OB halfbone maps on each of the two innermost halfbone domains are conjugate to each other.";

S=S+"\n\n3. volumes: The computes the volumes of the partitions P1,P2,P4 and checks the following two equalities:\n\na. P1 and P2 have the same volume.\n\nb.The union of the pieces (0,7,8,18) of partition P2 has the same volume as P4.";

S=S+"\n\n4. partition: This checks the following.\n\na. The pieces in each of P1,P2.P4 are pairwise disjoint.\n\nb. Each piece of P2 is contained in a piece of P1.\n\nc.Each piece of P4 is contained in one of the pieces (0,18,58,67) of P3.\n\nThese results, together with the volume calculations, imply all the needed statements about the filling properties of our partitions.";


        M.D.setExplain(S);
        M.D.repaint();
    }


    public void petPlotInfo() {
        String S="PET plot options.";
	S=S+"\n\nWhat the program plots in the PET windows are the periodic tiles for the system. These are the maximal convex sets on which the map is defined and periodic.  There are 3 plot options.";

	S=S+"\n\nsingle: This computes the periodic tile containing the point you have clicked, and then plots the tile.  Note that the computer needs to compute the entire orbit before it knows the periodic tile.  This plots a single tile, or perhaps several, depending on the value of the 'iterates' keys. The 'power' keys select which power of the basic map you plot.  Our results are identities between second powers of the maps.";

	S=S+"\n\norbit: This computes the periodic tile containing the point you have clicked, and then plots the tile and its orbit.  It is generally a good practice to first plot the single tile before plotting its whole orbit. If the single tile is very small, its orbit will probably be long. When long orbits are plotted, they slow down the program.";

	S=S+"\n\ncarpet: This is by far the best plotting routine. The routine randomly selects points in the domain and plots the periodic tiles contianing them.  When you use the carpet plot, you are in a sense plotting all tiles.  The green arrow keys are important here.  These keys specify when the computer should cutoff the calculation of an orbit.  If the number is too small here, the computer will abandon too many calculations and not plot enough tiles to give a good picture. If the number is too large, the computer might get hung up on computing a very long orbit.";
        M.D.setExplain(S);
        M.D.repaint();
    }

    public void OBPlotInfo() {
        String S="outer billiards plot options.";

	S=S+"\n\nThis makes outer billiards calculation in the lower left window. There are 7 options for the OB calculations";

	S=S+"\n\nsingle: This computes the periodic tile containing the point you have clicked, and then plots the tile.  Note that the computer needs to compute the entire orbit before it knows the periodic tile.  This plots a single tile, or perhaps several, depending on the value of the 'iterates' keys. The 'power' keys select which power of the basic map you plot.  Our results are identities between second powers of the maps.";

	S=S+"\n\norbit: This computes the periodic tile containing the point you have clicked, and then plots the tile and its orbit.  It is generally a good practice to first plot the single tile before plotting its whole orbit. If the single tile is very small, its orbit will probably be long. When long orbits are plotted, they slow down the program.";

        S=S+"\n\ncarpet: This plots all the orbit tiles in the dobgone domain.  The whole point of our theorem is that the picture in the PET window is the same as the one in the OOB window.  The two systems generate the same tiling.\n\ncarpet2: This plots the orbits in 32 fundamental domains.  This is rather slow.\n\ndogbone map: This plots the basic dogbone map.  The dogbone map is a compression of the first return map to a union B of two dogbones B1 and B2.  You can see the relevant dogbones by turning on 'dogbone1' and 'dogbone2' on the 'OB display' window and then clicking the purple arrow keys. B1 is magenta and B2 is cyan. Starting with x in B, we compute the first return y of the square of the OB map to B.  We then translate y by a fundamental translation so that x and y lie in the same dogbone, either B1 or B2.  The fundamental translations carry B1 to B2 or vice verse.\n\nHalfbone: The halfbone domain is the union of a (specially placed) dogbone and the two halfbones.  The dogbone should be placed so that it is sandwiched between the two halfbones.  The halfbone map computes the first return map to the two halfbones.";

        M.D.setExplain(S);
        M.D.repaint();
    }


    public void generateInfo() {
        String S="Data generation options";
	S=S+"\n\nThere are 3 data files, which you can reconstruct using this option.";
	S=S+"\n\npartition2: This is the partition for the map f^2.  Here f is the basic octagonal PET map. The partition consists of 40 polyhedra, but 20 are reflections of the other 20.  So, just 20 are generated.  Each polyhedron in the partition has the form\n\nf^{-1}(f(P1) intersect P2)\n\nThis partition is listed as P2 on the PET display panel.  The partition P3 consists of 80 pieces, all the images of pieces of P2 by isometries.";

	S=S+"\n\npartition4.  Referring to the partition P3, the pieces (0), (28), (58), (67) are special.  These pieces are not domains of continuity for the halfbone map.  We subdivide each of these pieces into smaller ones.  The smaller pieces are part of the partition for the map f^4.  To, to get a partition for the halfbone map, we use P3, but replace each of the 4 difficult pieces by their subdivisions.  The resulting partition is what we call P4.";

    S=S+"\n\norbits.  This computes 10 families of vertex sequences";
    S=S+"\n\nRelative to the partition P2 in the lower 0th dogbone, the vertex sequence for the dogbone map.";
    S=S+"\n\nRelative to the partition P2 in the upper 0th dogbone, the vertex sequence for the dogbone map.";
    S=S+"\n\nRelative to the partition P2 in the lower 1st dogbone, the vertex sequence for the dogbone map.";
    S=S+"\n\nRelative to the partition P2 in the upper 1st dogbone, the vertex sequence for the dogbone map.";
    S=S+"\n\nRelative to the partition P2 in the lower 2nd dogbone, the vertex sequence for the dogbone map.";
    S=S+"\n\nRelative to the partition P2 in the upper 2nd dogbone, the vertex sequence for the dogbone map.";
    S=S+"\n\nRelative to the partition P3 in the lower 0th halfbone domain, the vertex sequence for the halfbone map.  Since the pieces (0,28,58,67) are not domains of continuity for the map, the vertex sequence, which we compute using a single point, is meaningless for these pieces.";
    S=S+"\n\nRelative to the partition P3 in the lower 1st halfbome domain, the vertex sequence for the halfbone map.  The same remarks apply to the pieces (0,28,58,67).";
    S=S+"\n\nRelative to the partition P4 in the lower 0th halfbone domain, the vertex sequence for the halfbone map.";
    S=S+"\n\nRelative to the partition P4 in the lower 1st halfbome domain, the vertex sequence for the halfbone map.";

    S=S+"\n\nThese vertex sequences describe the action of the dogbone and halfbone maps on the relevant domains.  The point here is that the vertex sequence for each piece of the relevant partition only depends on the piece.  Thus, the action of the map is the same throughout the piece.";

        M.D.setExplain(S);
        M.D.repaint();
    }

}



