import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class GenerateItinerary {

    /*In order for this routine to work, the file
      DataPartition2.java must already be in place.*/


    public static void main(Manager M) {
	Output OUT=new Output("DataTemp");
	OUT.writeln("public class DataItinerary {");
	OUT.writeln("");

	for(int i=1;i<6;++i) {
	  octagon(OUT,i);
	}

	for(int i=1;i<6;++i) {
   	  Integer I=new Integer(i);
	  dogboneChoice(OUT,I.toString());
	  dogbone(OUT,i,false);
	  dogbone(OUT,i,true);
	}

	updown(OUT,1);

	halfbone(OUT,0,0);
	halfbone(OUT,1,0);
	halfbone(OUT,0,1);
	halfbone(OUT,1,1);

	OUT.writeln("}");
	Generate.sendMessage(M,"DataItinerary.java");
    }



    public static void dogboneChoice(Output OUT,String S) {
	OUT.writeln("public static int[] dogbone"+S+"(int i,boolean up) {");
	OUT.writeln("if(up==false) return(dogbone"+S+"0(i));");
	OUT.writeln("return(dogbone"+S+"1(i));");
	OUT.writeln("}");
	OUT.writeln("");
    }

    public static void dogbone(Output OUT,int SHIFT,boolean up) {

	Integer I1=new Integer(SHIFT);
	String S="0";
	if(up==true) S="1";
	OUT.writeln("public static int[] dogbone"+I1.toString()+S+"(int i) {");
	OUT.write("int[][] t={");

	for(int i=0;i<40;++i) {
          LongPolyhedron X=DataPartition2.poly(i);
	  Polyhedron P=X.toPolyhedron();
	  Vector V=P.center();
	  double s=V.x[2];
	  Complex z=new Complex(V.x[0]+2*SHIFT,V.x[1]);
	  if(up==true) z=Complex.plus(z,new Complex(-2+2*s,2*s));
	  PolygonWrapper Q=BilliardsShapes.octagon(s);
	  int[] t=BilliardsMap.dogboneInt(SHIFT,z,s,Q);
	  print(OUT,t);
	  if(i<39) OUT.write(",");
	}
	OUT.writeln("};");
	OUT.writeln("return(t[i]);");
	OUT.writeln("}");
	OUT.writeln("");
    }

    public static void octagon(Output OUT,int SHIFT) {

	Integer I1=new Integer(SHIFT);
	OUT.writeln("public static int[] octagon"+I1.toString()+"() {");
	OUT.write("int[] t=");
        LongPolyhedron X=DataPartition0.octagon();
	Polyhedron P=X.toPolyhedron();
	Vector V=P.center();
	double s=V.x[2];
	Complex z=new Complex(V.x[0]+2*SHIFT,V.x[1]);
	PolygonWrapper Q=BilliardsShapes.octagon(s);
	int[] t=BilliardsMap.octagonInt(SHIFT,z,s,Q);
	print(OUT,t);
	OUT.writeln(";");
	OUT.writeln("return(t);");
	OUT.writeln("}");
	OUT.writeln("");
    }



    public static void halfbone(Output OUT,int SHIFT,int choice) {

	Integer I1=new Integer(SHIFT);
	String S="0";
	if(choice==1) S="1";
	OUT.writeln("public static int[] halfbone"+I1.toString()+S+"(int i) {");
	OUT.write("int[][] t={");
	int lim=80;
	if(choice==1) lim=25;

	for(int i=0;i<lim;++i) {
	  LongPolyhedron X=new LongPolyhedron();
          if(choice==0) X=DataPartition2.poly(i);
          if(choice==1) X=DataPartition4.poly(i);
	  Polyhedron P=X.toPolyhedron();
	  Vector V=P.center();
	  double s=V.x[2];
	  Complex z=new Complex(V.x[0]+2*SHIFT,V.x[1]);
	  PolygonWrapper Q=BilliardsShapes.octagon(s);
	  int[] t=BilliardsMap.halfboneInt(SHIFT,z,s,Q);
	  print(OUT,t);
	  if(i<lim-1) OUT.write(",");
	}
	OUT.writeln("};");
	OUT.writeln("return(t[i]);");
	OUT.writeln("}");
	OUT.writeln("");
    }




    public static void print(Output OUT,int[] t) {
	OUT.write("{");
	for(int i=0;i<t.length;++i) {
            if(i<t.length-1) OUT.write(t[i]+",");
            if(i==t.length-1) OUT.write(t[i]+"}");
	}
    }

    /*generates the up-down list:  Does the dogbone map
      return the polyhedron to the same(0) or different(1) dogbone*/

    public static void updown(Output OUT,int SHIFT) {
	OUT.writeln("public static int upOrDown(int i) {");
	OUT.write("int[] t={");
	for(int i=0;i<40;++i) {
        LongPolyhedron X=DataPartition2.poly(i);
	Polyhedron P=X.toPolyhedron();
	Vector V=P.center();
	Complex z=new Complex(V.x[0]+2,V.x[1]);
	double s=V.x[2];
	PolygonWrapper Q=BilliardsShapes.octagon(s);
	Complex w=BilliardsMap.preDogbone(SHIFT,z,s,Q);
	int k=0;
	if(w.y>s) k=1;
	Integer K=new Integer(k);
	if(i<39) OUT.write(K.toString()+",");
	if(i==39) OUT.writeln(K.toString()+"};");
	}
	OUT.writeln("return(t[i]);");
	OUT.writeln("}");
	OUT.writeln("");
    }

}    



