import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.math.*;

public class GeneratePartition2 {

    /*This routine generates the 40 polyhedra
      in the partition for the second iterate of
      the polygon exchange map. We don't need this
      routine because we have already generated
      the polyhedra.  Were we to reconstruct the
      file, we would run the program and then paste
      the data from the file DataTemp into the file
      DataPartition2.java*/

    public static void main(Manager M) {
	Output OUT=new Output("DataTemp");
	OUT.writeln("public class DataPartition2Raw {");
        OUT.writeln("");

	int count=0;
	int[][] FACE=new int[20][8];

	  for(int q1=1;q1<13;++q1) {
	    for(int q2=1;q2<13;++q2) {
                LongPolyhedron P1=DataPartition1.poly(q1);
                LongPolyhedron P2=DataPartition1.poly(q2);
                P2=ProofSupport.dogboneMap(1,q2,P2);
	        LongPolyhedron Q=LongPolyIntersect.main(P1,P2);
	        if(Q!=null) {
		   Q=ProofSupport.dogboneMap(-1,q2,Q);
        	   if(Q.V[0].x[0]<0) Q=Q.translateRight();
        	   if(Q.V[0].x[0]>2*Q.SCALE) Q=Q.translateLeft();
		   boolean plot=false;
		   if(bottomHalf(Q)==true) plot=true;
		   if(plot==true) { 
		       Integer I=new Integer(count);
		       String S="poly"+I.toString();
                       Q.dataPrint(OUT,S);
		       FACE[count]=LongPolyFace.faceList(Q);
		       ++count;
		   }
		}
	    }
	  }

	writeFaceList(OUT,FACE);
	OUT.writeln("");
	OUT.writeln("");
	OUT.writeln("}");
	Generate.sendMessage(M,"DataPartition2Raw.java");
    }


    public static boolean bottomHalf(LongPolyhedron P) {
	Polyhedron Q=P.toPolyhedron();
        Vector V=Q.center();
	double s=V.x[2];
	Complex z=new Complex(V.x[0],V.x[1]);
	PolygonWrapper D=halfbone(s);
	GeneralPath gp=D.toGeneralPath();
	if(gp.contains(z.x,z.y)==true) return(true);
	return(false);
    }

    


    /*bottom half of the dogbone*/
    public static PolygonWrapper halfbone(double s) {
	PolygonWrapper P1=BilliardsShapes.octagon(s,0,0,0);
	PolygonWrapper P2=BilliardsShapes.octagon(s,0,1,0);
	PolygonWrapper Q=new PolygonWrapper();
	Q.count=4;
	Q.z[0]=P1.z[6];
	Q.z[1]=P2.z[5];
	Q.z[2]=P2.z[4];
	Q.z[3]=P2.z[3];
	return(Q);
    }


    public static void writeFaceList(Output OUT,int[][] FACE) {
	OUT.writeln("public static int[] faceList(int i) {");
	OUT.write("int[][] t={");
	for(int i=0;i<20;++i) {
	    print(OUT,FACE[i]);
	    if(i<19) OUT.write(",");
	    if(i==19) OUT.writeln("};");
	}
	OUT.writeln("if(i<20) return(t[i]);");
	OUT.writeln("else return(t[i-20]);");
	OUT.writeln("}");
	OUT.writeln("");
    }

    public static void print(Output OUT,int[] t) {
	OUT.write("{");
	for(int i=0;i<t.length;++i) {
            if(i<t.length-1) OUT.write(t[i]+",");
            if(i==t.length-1) OUT.write(t[i]+"}");
	}
    }




}



