import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class GraphicsHelp {




    /*This routine returns a color based on the congruence
      of k0 mod M.*/

    public static Color getColor(int k0,int M) {
	int k=k0%M;
	double d1=k*Math.sqrt(2);
	double d2=k*Math.sqrt(3);
	double d3=k*Math.sqrt(5);
	d1=d1-Math.floor(d1);
	d2=d2-Math.floor(d2);
	d3=d3-Math.floor(d3);
	int c1=(int)(255*d1);
	int c2=(int)(255*d2);
	int c3=(int)(255*d3);
	Color C=new Color(c1,c2,c3);
	return(C);
    }


    /*decides if a color is dark or light*/
    public static boolean isLight(Color C) {
	int r=C.getRed();
	int b=C.getBlue();
	int g=C.getGreen();
	if(r+b+g>600) return(true);
	return(false);
    }



    public static Complex[] getBounds(GeneralPath gp) {
	Rectangle2D R0=gp.getBounds2D();
	Rectangle2D.Float R1=(Rectangle2D.Float)(R0);
	Complex z1=new Complex(R1.x,R1.y);
	Complex z2=new Complex(R1.x+R1.getWidth(),R1.y+R1.getHeight());
	Complex[] Z={z1,z2};
	return(Z);
    }

    public static Complex[] getBounds(PolygonWrapper P) {
	GeneralPath gp=P.toGeneralPath();
	Rectangle2D R0=gp.getBounds2D();
	Rectangle2D.Float R1=(Rectangle2D.Float)(R0);
	Complex z1=new Complex(R1.x,R1.y);
	Complex z2=new Complex(R1.x+R1.getWidth(),R1.y+R1.getHeight());
	Complex[] Z={z1,z2};
	return(Z);
    }


    public static Color setTransparency(Color C1,Color C2) {
	int r=C1.getRed();
	int g=C1.getGreen();
	int b=C1.getBlue();
	int a=255;
	try{a=C2.getAlpha();}
        catch(Exception e) {}
	Color C3=new Color(r,g,b,a);
	return(C3);
    }

}




