import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of complex numbers */

public class LongComplex {
    long x,y;
    
    public LongComplex() {
        this.x=0;
        this.y=0;
    } 
    
    public LongComplex(long x,long y) {
        this.x=x;
        this.y=y;
    }

    public LongComplex(LongComplex z) {
        this.x=z.x;
        this.y=z.y;
    }

    public static LongComplex plus(LongComplex z1,LongComplex z2) {
        return new LongComplex(z1.x+z2.x, z1.y+z2.y);
    }
    
    public static LongComplex negative(LongComplex z) {
	LongComplex w=new LongComplex(-z.x,-z.y);
	return(w);
    }

    public static LongComplex minus(LongComplex z1,LongComplex z2) {
        return new LongComplex(z1.x-z2.x, z1.y-z2.y);
    }
    

    public static LongComplex times(LongComplex z1,LongComplex z2) {
        return new LongComplex(z1.x*z2.x-z1.y*z2.y,
        z1.x*z2.y+z1.y*z2.x);
    }
    
    public static LongComplex conjugate(LongComplex z) {
        return new LongComplex(z.x,-z.y);
    }

    public LongComplex conjugate() {
        return new LongComplex(x,-y);
    }

    public static long dot(LongComplex a, LongComplex b) {
        return a.x*b.x+a.y*b.y;
    }
    
    public static long area(LongComplex z1,LongComplex z2,LongComplex z3) {
        long a;
        LongComplex[] z=new LongComplex[5];
        z[1]=z1.minus(z2,z1);
        z[2]=z1.minus(z3,z1);
        z[3]=z1.conjugate(z[2]);
        z[4]=z1.times(z[1],z[3]);
        a=-z[4].y;
        return(a);
    }

    public void print() {
	System.out.println("LongComplex: "+this.x+" "+this.y);
    }
}

