import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;

/**This class takes the intersection of two long polyhedra*/

public class LongPolyIntersect {

    public static LongPolyhedron main(LongPolyhedron P1,LongPolyhedron P2) {
	LongPolyhedron Q=new LongPolyhedron();
	Q.count=0;

	for(int i=0;i<P1.count;++i) {
	    LongVector d=new LongVector(P1.V[i]);
	    if(Q.onList(d)==false) {
	      if(LongPolyCombinatorics.inside(d,P2)==true) {
                 Q.V[Q.count]=new LongVector(d);
		 ++Q.count;
	      }
	    }
	}

	for(int i=0;i<P2.count;++i) {
	    LongVector d=new LongVector(P2.V[i]);
	    if(Q.onList(d)==false) {
	      if(LongPolyCombinatorics.inside(d,P1)==true) {
                 Q.V[Q.count]=new LongVector(d);
		 ++Q.count;
	      }
	    }
	}


	 int t1=P1.faceNumber();
	 int t2=P2.faceNumber();
	 for(int i1=0;i1<t1;++i1) {
	     for(int j1=i1+1;j1<t1;++j1) {
		 for(int i2=0;i2<t2;++i2) {
		     long[] a1=P1.toFaceFunctional(i1);
		     long[] a2=P1.toFaceFunctional(j1);
		     long[] a3=P2.toFaceFunctional(i2);
		     LongVector d=LongPolyhedron.intersect(a1,a2,a3);
		     if(d!=null) {
			 if(Q.onList(d)==false) {
			     if(LongPolyCombinatorics.inside(d,P1)==true) {
			       if(LongPolyCombinatorics.inside(d,P2)==true) {
			         Q.V[Q.count]=new LongVector(d);
			         ++Q.count;
			       }
			     }
			 }
		     }
		 }
	     }
	 }

	 t1=P2.faceNumber();
	 t2=P1.faceNumber();
	 for(int i1=0;i1<t1;++i1) {
	     for(int j1=i1+1;j1<t1;++j1) {
		 for(int i2=0;i2<t2;++i2) {
		     long[] a1=P2.toFaceFunctional(i1);
		     long[] a2=P2.toFaceFunctional(j1);
		     long[] a3=P1.toFaceFunctional(i2);
		     LongVector d=LongPolyhedron.intersect(a1,a2,a3);
		     boolean test=true;
		     if(d!=null) {
			 if(Q.onList(d)==false) {    
                             if(LongPolyCombinatorics.inside(d,P1)==true) {
			       if(LongPolyCombinatorics.inside(d,P2)==true) {
			         Q.V[Q.count]=new LongVector(d);
			         ++Q.count;
			       }
			     }
			 }
		     }
		 }
	     }
	 }
	 if(Q.count<4) return(null);
	 if(LongPolyFace.isCoplanar(Q)==true) return(null);
	 Q.SCALE=P1.SCALE;
	 return(Q);
    }

    /**This intersects and polyhedron with the halfplane z>=2/3.*/

    public static LongPolyhedron chop(LongPolyhedron P0) {
	LongPolyhedron P=new LongPolyhedron(P0);
	P.SCALE=P0.SCALE;
	P.FACE=LongPolyFace.faceList(P0);
	LongPolyhedron Q=new LongPolyhedron();
	Q.count=0;

	for(int i=0;i<P.count;++i) {
	    LongVector d=new LongVector(P.V[i]);
	    if(Q.onList(d)==false) {
		if(3*d.x[2]>=2*P.SCALE) {
                 Q.V[Q.count]=new LongVector(d); 
		 ++Q.count;
	      }
	    }
	}

	 int t1=P.faceNumber();
	 for(int i1=0;i1<t1;++i1) {
	     for(int j1=i1+1;j1<t1;++j1) {
		 long[] a1=P.toFaceFunctional(i1);
		 long[] a2=P.toFaceFunctional(j1);
		 long[] a3={0,0,3,2*P.SCALE};

		 LongVector d=LongPolyhedron.intersect(a1,a2,a3);
		 if(d!=null) {
		     if(Q.onList(d)==false) {
			 if(LongPolyCombinatorics.inside(d,P)==true) {
			   Q.V[Q.count]=new LongVector(d);
			   ++Q.count;
			 }
		     }
		 }
	     }
	 }
	 if(Q.count<4) return(null);
	 if(LongPolyFace.isCoplanar(Q)==true) return(null);
	 Q.SCALE=P.SCALE;
	 return(Q);
    }


}
