import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.io.*;

/*This is the class of polyhedra we use for our
  exact integer calculations.*/


public class LongPolyhedron {
    LongVector[] V=new LongVector[50];
    int[] MOVE=new int[4];   //arithmetic graph fragment - determines F action
    int[] FACE;              //list of faces
    long SCALE;              //scale factor for the polyhedron
    int count;               //number of vertices
    long VOLUME;

    public LongPolyhedron() {}

    public LongPolyhedron(LongPolyhedron P) {
	this.count=P.count;
	for(int i=0;i<count;++i) V[i]=new LongVector(P.V[i]);
	this.SCALE=P.SCALE;
    }

    public LongPolyhedron dilate(long k) {
	LongPolyhedron P=new LongPolyhedron();
	P.count=this.count;
	P.SCALE=this.SCALE*k;
	P.FACE=this.FACE;
	for(int i=0;i<this.count;++i) {
	    P.V[i]=LongVector.scale(k,this.V[i]);
	}
	return(P);
    }

    /*These routines have to do with getting the faces*/


    public int faceNumber() {
	return(this.FACE.length);
    }

    /*This creates a new polyhedron which is the qth face
      of the original polyhedron.*/

    public LongPolyhedron toFace(int q) {
	LongPolyhedron P=new LongPolyhedron();
	LongVector[] LIST=face(q);
	P.count=LIST.length;
	for(int i=0;i<P.count;++i) P.V[i]=LIST[i];
	P.FACE=null;
	P.MOVE=null;
	P.SCALE=this.SCALE;
	return(P);
    }

    /**This gets the coefficients A,B,C,D so that all
       the points in the qth face of the polyhedron
       satisfy Ax+By+Cz=D.*/

   public long[] toFaceFunctional(int q) {
       LongPolyhedron P=this.toFace(q);
       LongVector v1=LongVector.minus(P.V[1],P.V[0]);
       LongVector v2=LongVector.minus(P.V[2],P.V[0]);
       LongVector v3=LongVector.cross(v1,v2);
       v3=LongVector.process(v3);
       long x=LongVector.dot(v3,P.V[0]);
       long[] X={v3.x[0],v3.x[1],v3.x[2],x};
       return(X);
   }




    /*Gets the list of vectors in the ith face*/

    public LongVector[] face(int i) {
	int a=FACE[i];
	return(LongPolyFace.getList(this,a));
    }


    public boolean inFace(int i,int j) {
	int a=FACE[j];
	int[] b=Combinatorics.binaryList(count,a);
	for(int k=0;k<b.length;++k) {
	    if(i==b[k]) return(true);
	}
	return(false);
    }


    /*This routine intersects 3 faces*/

    public static LongVector intersect(long[] a,long[] b,long[] c) {
	LongMatrix m=new LongMatrix();
	LongVector d=new LongVector();
	for(int i=0;i<3;++i) {
             m.a[0][i]=a[i];
             m.a[1][i]=b[i];
             m.a[2][i]=c[i];
	}
	d.x[0]=a[3];
	d.x[1]=b[3];
	d.x[2]=c[3];
	if(m.det()==0) return(null);
	LongMatrix n=m.inverse();
	d=LongMatrix.act(n,d);
	d=d.guidedDivide(n.SCALE);
	return(d);
    }

    /**done with routines having to do with faces*/






    /**Converts an integer list into a polyhedron. Our polyhedra
       are stored as raw lists of integers.*/

    /**In this routine, the integer list has the form
       
       (p1,q1,p2,q2,p3,q3) 

       and the resulting vector is
       
       (scale p1/q1,scale p2/q2,scale p3/q3) */

    public static LongPolyhedron fromIntegerList(long scale,int[][] t) {
	LongPolyhedron P=new LongPolyhedron();
	P.SCALE=scale;
	P.count=t.length;
	for(int i=0;i<P.count;++i) {
	    P.V[i]=new LongVector();
	    for(int j=0;j<3;++j) {
		long a=scale*t[i][2*j];
        	checkDivision(a,t[i][2*j+1]);
		a=a/t[i][2*j+1];
		P.V[i].x[j]=a;
	    }
	}
	return(P);
    }

    /*In this routine the integers are just (a,b,c) and the
      vector is also (a,b,c)*/

    public static LongPolyhedron fromIntegerList(int[][] t) {
	LongPolyhedron P=new LongPolyhedron();
	P.SCALE=1;
	P.count=t.length;
	for(int i=0;i<P.count;++i) {
	    P.V[i]=new LongVector();
	    for(int j=0;j<3;++j) {
		P.V[i].x[j]=(long)(t[i][j]);
	    }
	}
	return(P);
    }
    
    /*This make sure we are only dividing numbers, as integers,
      when the one numbers goes evenly into the other.*/

    public static void checkDivision(long p,long q) {
	if(p%q!=0) {
	    System.out.println(p+" "+q);
            throw new ProofException("division fails");
	}
    }

    public boolean onList(LongVector d) {
	for(int i=0;i<this.count;++i) {
	    LongVector W=new LongVector(d);
	    W=LongVector.minus(W,this.V[i]);
	    long a=LongVector.dot(W,W);
	    if(a==0) return(true);
	}
	return(false);
    }

    public LongPolyhedron translateLeft() {
	LongPolyhedron Q=new LongPolyhedron(this);
	for(int i=0;i<count;++i) Q.V[i].x[0]=Q.V[i].x[0]-2*SCALE;
	Q.SCALE=this.SCALE;
	Q.FACE=this.FACE;
	return(Q);
    }

    public LongPolyhedron translateRight() {
	LongPolyhedron Q=new LongPolyhedron(this);
	for(int i=0;i<count;++i) Q.V[i].x[0]=Q.V[i].x[0]+2*SCALE;	
        Q.SCALE=this.SCALE;
	Q.FACE=this.FACE;
	return(Q);
    }

    /*Converts a LongPolyhedron to an ordinary Polyhedron*/

    public Polyhedron toPolyhedron() {
	Polyhedron P=new Polyhedron();
	P.count=this.count;
	for(int i=0;i<count;++i) {
	    P.V[i]=new Vector();
	    P.V[i].size=3;
	    for(int j=0;j<3;++j) {
		P.V[i].x[j]=1.0*this.V[i].x[j]/SCALE;
	    }
	}
	return(P);
    }

    /*printing routines*/

    public void dataPrint(Output OUT,String S) {  
	OUT.writeln("public static int[][] "+S+"() {");
	OUT.write("int[][] t={");
	for(int i=0;i<this.count;++i) {
	    OUT.write("{");
	    for(int j=0;j<3;++j) {
		Long K=new Long(this.V[i].x[j]);
		if(j!=2) OUT.write(K.toString()+",");
		if(j==2) OUT.write(K.toString()+"}");
	    }
	    if(i<this.count-1) OUT.write(",");
	    if(i==this.count-1) OUT.write("};");
	}
	OUT.writeln("");
	OUT.writeln("return(t);}");
	OUT.writeln("");
    }


    public void print() {
	System.out.println("----------------");
	System.out.println("long polyhedron");
	System.out.println("scale");
	System.out.println(SCALE);
	System.out.println("vectors");
	for(int i=0;i<count;++i) {
	    V[i].print();
	}
	System.out.println("faces");
	try{
	for(int i=0;i<FACE.length;++i) {
	    int[] t=Combinatorics.binaryList(count,FACE[i]);
	    printout(t);
	}
	}
	catch(Exception e) {
	    System.out.println("none listed");
	}
	System.out.println("action");
	try {printout(MOVE);}
	catch(Exception e) {
	    System.out.println("none listed");
	}

	System.out.println("----------------");
    }


    public void printout(int[] t) {
	for(int i=0;i<t.length;++i) System.out.print(t[i]+" ");
	System.out.println("");
    }

    /*to LaTeX*/

    public void texPrint(String S,Output OUT) {
	OUT.writeln("\\begin{eqnarray}");
	OUT.writeln("\\nonumber");
	OUT.write(S+"=");
	for(int i=0;i<count;++i) {
	    LongVector W=V[i];
	    OUT.write("\\left[\\matrix{");
	    OUT.write(W.x[0]+"\\cr ");
	    OUT.write(W.x[1]+"\\cr ");
	    OUT.write(W.x[2]+"}\\right]");
	}
	OUT.writeln("");
	OUT.writeln("\\end{eqnarray}");
	OUT.writeln("");
    }

    /*For each vertex i, this routine decides which faces
      i belongs to*/


    public void facePrint() {
	for(int i=0;i<count;++i) {
	    System.out.print(i+" : ");
	    for(int j=0;j<FACE.length;++j) {
		if(inFace(i,j)==true) {
		    System.out.print(j+" ");
		}
	    }
	    System.out.println("");
	}
    }

}
