import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PETCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M; 
    int TYPE;
    GeneralPath[] GP=new GeneralPath[100000];
    Complex[] CENTER=new Complex[100000];
    Color[] COLOR=new Color[100000];  
    int[] ORBIT=new int[100000];
    double[] TAG=new double[100000];
    int COUNT;
    int TILE_INDEX;   
    Point JX; 

     public PETCanvas() {
	 addKeyListener(this);
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(207,205,100);	
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      if(M.C.DISPLAY.L[0].on==1) drawDomain(g,1);  
      if(M.C.DISPLAY.L[1].on==1) drawDogbone(g);
      if(M.C.DISPLAY.L[2].on==1) drawPartition1(g,false);
      if(M.C.DISPLAY.L[3].on==1) drawPartition1(g,true);
      if(M.C.DISPLAY.L[4].on==1) drawPartition2(g);
      if(M.C.DISPLAY.L[5].on==1) drawPartition3(g); 
      if(M.C.DISPLAY.L[6].on==1) drawPartition4(g);  
      if(M.C.DISPLAY.L[7].on==1) drawIndividual(g); 
      if(M.C.DISPLAY.L[0].on==1) drawTiles(g,0);
      if(M.C.DISPLAY.L[1].on==1) drawTiles(g,1); 
      drawCrosshairs(g);
      drawFrame(g);

   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(70,0,70));
	if(TYPE==1) g.setColor(new Color(0,0,100));
	g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawFrame(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.white);
	g.drawString("z: zoom in",5,405);
	g.drawString("x: action",120,405);
	g.drawString("c: zoom out",220,405);
	g.drawString("a: coords",5,15);
	g.drawString("s: recolor",120,15);
	g.drawString("d: recolor orbit",220,15);
	g.drawString("r: reset",350,15);
    }

    public void drawTiles(Graphics2D g,int choice) {
	AffineTransform AF=AffineTransform.getTranslateInstance(2,0);
	Color COL2=Color.white;
	Output OUT=new Output("Output/tiling");
	for(int i=0;i<COUNT;++i) {  
	    GeneralPath gp=new GeneralPath(GP[i]); 
	    if(choice==1) {
		if(CENTER[i].x<0) gp.transform(AF);
	    }
            Color COL=COLOR[i];
	    OUT.polyWrite(gp,COL,COL2);
	    gp=transform(gp);
	    if((choice==0)||(ORBIT[i]>1)) {
	      g.setColor(COL);
	      g.fill(gp);
	      g.setColor(COL2);
	      g.draw(gp);
	    }
	}
    }




    public void drawDomain(Graphics2D g,int choice) {
	double s=M.C.getParameter();
	PolygonWrapper P=BasicAlgebra.domain(choice,s);
	GeneralPath gp=P.toGeneralPath();
	gp=transform(gp);
	g.setColor(M.C.DISPLAY.M[0].C);
	g.fill(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }

    public void drawDogbone(Graphics2D g) {
	double s=M.C.getParameter();
	PolygonWrapper P=BilliardsShapes.dogbone(s,0,0,0);
	GeneralPath gp=P.toGeneralPath();
	gp=transform(gp);
	g.setColor(M.C.DISPLAY.M[1].C);
	g.fill(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }

    public boolean drawPartition1(Graphics2D g,boolean image) {
	double s=M.C.getParameter();
	Color C=M.C.DISPLAY.M[2].C;
	if(image==true)  C=M.C.DISPLAY.M[3].C;
	for(int i=1;i<13;++i) {
	  LongPolyhedron X0=DataPartition1.poly(i);
	  if(image==true) X0=ProofSupport.dogboneMap(1,i,X0);
	  Polyhedron X=X0.toPolyhedron();
	  drawSlice(g,X,s,C);
	}
	return(true);
    }

    public boolean drawPartition2(Graphics2D g) {
	double s=M.C.getParameter();
	Color C=M.C.DISPLAY.M[4].C;
	for(int i=0;i<40;++i) {	 
	    LongPolyhedron Q=DataPartition2.poly(i);  
	    Polyhedron X=Q.toPolyhedron();
	    drawSlice(g,X,s,C);
	}
	return(true);
    }


    public boolean drawPartition3(Graphics2D g) {
	double s=M.C.getParameter();
	Color C=M.C.DISPLAY.M[5].C;
	for(int i=0;i<80;++i) {	 
	    LongPolyhedron Q=DataPartition2.poly(i);  
	    Polyhedron X=Q.toPolyhedron();
	    drawSlice(g,X,s,C);
	}
	return(true);
    }

    public boolean drawPartition4(Graphics2D g) {
	double s=M.C.getParameter();
	Color C=M.C.DISPLAY.M[6].C;
	for(int i=0;i<25;++i) {	 
	    LongPolyhedron Q=DataPartition4.poly(i);  
	    Polyhedron X=Q.toPolyhedron();
	    drawSlice(g,X,s,C);
	}
	return(true);
    }


    public boolean drawIndividual(Graphics2D g) {
	Color C=M.C.DISPLAY.M[7].C;
	int i1=M.C.POLY1.val;
	int i2=M.C.POLY2.val;
	int i=20*i2+i1;
	double s=M.C.getParameter();
	LongPolyhedron X0=DataPartition2.poly(i);
	Polyhedron X=X0.toPolyhedron();
        drawSlice(g,X,s,C);
	return(true);
    }


    public void drawSlice(Graphics2D g,Polyhedron X,double s,Color C) {
         PolygonWrapper P=PolyhedronSlicer.basicSlice(X,s);
	 if(P!=null) {
	    GeneralPath gp=P.toGeneralPath();
	    gp=transform(gp);
	    g.setColor(C);
            g.fill(gp);
	    g.setColor(Color.white);
	    g.draw(gp);
	 }
    }

    public boolean polyCoords() {
	getIndex();
	int t=TILE_INDEX;
	if(t==-1) return(false);
        PolygonWrapper P=PolygonWrapper.fromGeneralPath(GP[t%1000]);
	polyCoords(P);
	M.C.repaint();
	return(true);
    }


    public boolean polyCoords(PolygonWrapper P) {
	int cx=0;
	int cy=0;
	double fudge=0;
	if(TILE_INDEX>=1000) fudge=2;
	for(int i=0;i<10;++i) M.C.MESSAGE[i]="";
	int[] d=M.C.SHAPE.getFraction();
	Integer D=new Integer(d[1]);
	for(int i=0;i<P.count;++i) {
	    int x=MathRational.convert(d[1]*P.z[i].x+fudge*d[1]);
	    int y=MathRational.convert(d[1]*P.z[i].y);
	    cx=cx+x;
	    cy=cy+y;
	    Integer X=new Integer(x);
	    Integer Y=new Integer(y);
	    String S=X.toString()+"/"+D.toString();
	    S=S+"    "+Y.toString()+"/"+D.toString();
	    M.C.MESSAGE[i]=S;
	}
	if(P.count==3) return(false);
	if(cx%P.count!=0) throw new ProofException("bad integer division");
	if(cy%P.count!=0) throw new ProofException("bad integer division");
	cx=cx/P.count;
	cy=cy/P.count;

        Integer X=new Integer(cx);
	Integer Y=new Integer(cy);
	String S=X.toString()+"/"+D.toString();
	S=S+"    "+Y.toString()+"/"+D.toString();
	S="center "+S;
	M.C.MESSAGE[9]=S;
	M.C.repaint();
	return(true);
    }


    public void getIndex() {
	TILE_INDEX=getIndex(SOURCE);
    }

    public int getIndex(Complex z) {
	int index=-1;
	for(int i=0;i<COUNT;++i) {
	    if(GP[i].contains(z.x,z.y)==true) index=i;
	    if(GP[i].contains(z.x-2,z.y)==true) index=1000+i;
	}
	return(index);
    }

    public boolean recolor() {
	getIndex();
	int t=TILE_INDEX;
	if(t==-1) return(false);
        COLOR[t%1000]=M.C.CS.C;
	return(true);
    }

    public boolean recolorOrbit() {
	getIndex();
	int t=TILE_INDEX;
	if(t==-1) return(false); 
        double tag=TAG[t%1000];
        for(int i=0;i<COUNT;++i) {
	   if(TAG[i]==tag) COLOR[i]=M.C.CS.C;
	}
	return(true);
    }


    public void acceptTile(PolygonWrapper P,Color COL,int orbit,double tag,boolean block) {
	Complex z=P.center();
	int index=getIndex(z);
	if((block==false)||(index==-1)) {
	    GP[COUNT]=P.toGeneralPath();
	    CENTER[COUNT]=new Complex(z);
	    ORBIT[COUNT]=orbit;
	    TAG[COUNT]=tag;
	    COLOR[COUNT]=COL;
	    ++COUNT;
	}
    }




    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	JX=J.X;
	doMouseClick(J.mode);
    }

    public void doMouseClick(int mode) {

          if(mode==1)  {
             scaleUp(JX,0);
	  }

          if(mode==3)  {
            scaleUp(JX,1);
	  }

	  if(mode==2)  {
	    SOURCE=unTransform(JX);
	    M.C.doAction();
	  }

	  if(mode==4)  {
	    SOURCE=unTransform(JX);
	    polyCoords();
	  }

	  if(mode==5)  {
	    SOURCE=unTransform(JX);
	    recolor();
	  }

	  if(mode==6)  {
	    SOURCE=unTransform(JX);
	    recolorOrbit();
	  }

	  if(mode==7) {
	      M.C.CP.HALT=true;  //halt the computation if necessary
              COUNT=0;
	  }

	  if(M.C.LINK.on==1) {
	      int x0=M.C.DOG.val;
	      M.P.SOURCE=new Complex(SOURCE.x+2*x0,SOURCE.y);
	      M.P.repaint();
	  }

        repaint();
    }


    public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=new Point(J.X);
    }


     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   
    public void mouseDragged(MouseEvent e) {}



    public void keyTyped(KeyEvent e) {

	int test=0;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;
	if(ch=='a') test=4;
	if(ch=='s') test=5;
	if(ch=='d') test=6;
	if(ch=='r') test=7;
	if(test>0) doMouseClick(test);
	repaint();
    }


    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}

