 import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Random;




public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    ComputeBilliards CB;
    GeneralPath[] GP=new GeneralPath[1000000];
    Color[] COL=new Color[1000000];
    int COUNT;
    ListenSquare FRAME;
    SelectInteger JUMP1,JUMP2;
    Point JX;
    Output OUT;


     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(200,50);
	 COUNT=0;
	 FRAME=new ListenSquare(0,0,420,25); 
         CB=new ComputeBilliards();
	 JUMP1=new SelectInteger(2,2,40,20,0,0,0,0);
	 JUMP2=new SelectInteger(62,2,40,20,0,0,0,0);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      OUT=new Output("Output/tiling");
      Color[] COL=new Color[9];
      int[] m=new int[9];
      for(int i=0;i<9;++i) m[i]=M.C.OB.L[i].on;
      for(int i=0;i<9;++i) COL[i]=M.C.OB.M[i].C;
      int d=M.C.DOG.val;
      drawBackground(g);
      drawShape(g);
      if(m[0]==1) drawTiling(g,false);
      if(m[1]==1) drawTiling(g,true); 
      if(m[2]==1) drawStrips(g,COL[2]); 
      if(m[3]==1) drawBarrier(g,COL[3]); 
      if(m[4]==1) drawOctagons(g,COL[4]);
      if(m[5]==1) drawDogbone(g,d,0,COL[5]);
      if((d>0)&&(m[6]==1)) drawDogbone(g,d-1,1,COL[6]);
      if((d<2)&&(m[7]==1)) drawHalfbone(g,d,COL[7]);
      if(m[8]==1) drawDogboneRow(g);
      drawPeriodicTiles(g);
      drawCrosshairs(g);  
      drawForeground(g);
   }

    public void drawMyPoly(Graphics2D g,PolygonWrapper P,Color C,int width) {
	GeneralPath gp=P.toGeneralPath();
	drawMyPoly(g,gp,C,width);
    }

    public void drawMyPoly(Graphics2D g,GeneralPath gp,Color C,int width) {
	OUT.polyWrite(gp,C,Color.black);
	gp=transform(gp);
	g.setColor(C);
	g.fill(gp);
	g.setColor(Color.white);
	g.setStroke(new BasicStroke(width));
	g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }




    public void drawBackground(Graphics2D g) {
      g.setColor(new Color(0,0,0));
      g.fillRect(0,0,getWidth(),getHeight());  
    }

    public void drawForeground(Graphics2D g) {
	Color C=new Color(0,0,0,0);
	FRAME.render(g,Color.blue);
	JUMP1.render(g,Color.red,C,C);
	JUMP2.render(g,Color.red,C,C);
	Double x=new Double(SOURCE.x);
	Double y=new Double(SOURCE.y);  
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.white);
	g.drawString(x.toString()+"    "+y.toString(),130,18);


    }

    public void drawBarrier(Graphics2D g,Color C) {
	double s=M.C.getParameter();
     	PolygonWrapper P=BilliardsShapes.barrier(s);
	drawMyPoly(g,P,C,1);
    }

    public void drawStrips(Graphics2D g,Color C) {
	double s=M.C.getParameter();
	for(int j=0;j<2;++j) {
	    for(int k=0;k<2;++k) {
		PolygonWrapper P=BilliardsShapes.strip0(s,j,k);
	        drawMyPoly(g,P,C,1);
		P=BilliardsShapes.strip1(s,j,k);
	        drawMyPoly(g,P,C,1);
	    }
	}
    }

    public void drawDogboneRow(Graphics2D g) {
	for(int i=1;i<5;++i) {
	    drawDogbone(g,i,0,new Color(255,150,0));
	    drawDogbone(g,i-1,1,new Color(255,0,255));
	}
    }


    public void drawDogbone(Graphics2D g,int m,int n,Color C) {
	double s=M.C.getParameter();
	PolygonWrapper P=BilliardsShapes.dogbone(s,0,m,n);
	drawMyPoly(g,P,C,2);
    }


    public void drawHalfbone(Graphics2D g,int d,Color C) {
	double s=M.C.getParameter();
	for(int j=0;j<2;++j) {
	   PolygonWrapper P=BilliardsShapes.halfbone(s,d,j);
	   GeneralPath gp=P.toGeneralPath();
	   drawMyPoly(g,P,C,2);
	}
    }


    public void drawShape(Graphics2D g) {
	double s=M.C.getParameter();
	PolygonWrapper P=BilliardsShapes.octagon(s);
	Color C=new Color(255,150,0);
	drawMyPoly(g,P,C,1);
        GeneralPath gp=P.toGeneralPath();
	gp.moveTo(0,0);
	gp.lineTo((float)(P.z[0].x),(float)(P.z[0].y));	
        gp=transform(gp);
	g.setColor(Color.white);
	g.draw(gp);

    }


    public void drawOctagons(Graphics2D g,Color COL) {
	double s=M.C.getParameter();
	for(int i=0;i<8;++i) {
	    for(int j=1;j<5;++j) {
		for(int k=0;k<5;++k) {
		    PolygonWrapper P=BilliardsShapes.octagon(s,i,j,k);
		    drawMyPoly(g,P,COL,1);
		}
	    }
	}
    }

    public void drawTiling(Graphics2D g,boolean reverse) {
	Color C0=M.C.OB.M[0].C;
	if(reverse==true) C0=M.C.OB.M[1].C;
	double s=M.C.getParameter();
	for(int j=0;j<5;++j) {
	for(int i=0;i<8;++i) {
	for(int k=0;k<4;++k) {
	    PolygonWrapper P=BilliardsShapes.parallelogram(i,j,k,s);
	    if(reverse==true) P=P.conjugate();
	    Color C=BilliardsShapes.getColor(i,j,k);
	    C=GraphicsHelp.setTransparency(C,C0);
	    drawMyPoly(g,P,C,1);
	}}}
    }


    public int getIndex(Complex z) {
	int index=-1;
	for(int i=0;i<COUNT;++i) {
	    if(GP[i].contains(z.x,z.y)==true) index=i;
	}
	return(index);
    }


    public void drawPeriodicTiles(Graphics2D g) {
	for(int i=0;i<COUNT;++i) {
	    GeneralPath gp=new GeneralPath(GP[i]);
	    drawMyPoly(g,GP[i],COL[i],1);
	}
    }

    public Color getColor(GeneralPath gp) {
	double s=M.C.getParameter();
	PolygonWrapper P=PolygonWrapper.fromGeneralPath(gp);
	Complex z=P.center();
	int[] I=BilliardsShapes.locateParallelogram(s,z);
	return(BilliardsShapes.getColor(I[0],I[1],I[2]));
    }




    public void goOrbit() {
	CB=new ComputeBilliards(M);
	new Thread(CB).start();
    }


    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	Point X=J.X;
	int but=J.mode; 
	doMouseClick(X,but);
    }

    public void jump(Point X) {
	int test1=JUMP1.isModified(X);
	if(test1==1) SOURCE.x=SOURCE.x+2;
	if(test1==-1) SOURCE.x=SOURCE.x-2;
	double s=M.C.SHAPE.getParameter();
	int test2=JUMP2.isModified(X);
	if(test2==1) SOURCE=Complex.plus(SOURCE,new Complex(-2+2*s,2*s));
	if(test2==-1) SOURCE=Complex.minus(SOURCE,new Complex(-2+2*s,2*s));

    }


    public void doMouseClick(Point X,int mode) {
	int test=FRAME.inside(X);
	if(test==0) {
          if(mode==1) scaleUp(X,-1);
          if(mode==3) scaleUp(X,+1);
	  if(mode==2) {	
             SOURCE=unTransform(X);
	     if(M.C.LINK.on==1) {
                 int x0=M.C.DOG.val;
		 M.B.SOURCE=new Complex(SOURCE.x-2*x0,SOURCE.y);
		 M.B.repaint();
		 System.out.println("used");
	     }
	     if(M.C.isIdle()==true) goOrbit();
	  }
	}
	if(test==1) jump(X);
        repaint();
    }


    public void mousePressed(MouseEvent e) {}
   public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }

    public void mouseExited(MouseEvent e) {}
     public void mouseMoved(MouseEvent e) {

	 try {MouseData J=MouseData.process(e);
	     JX=J.X;
	 }
	 catch(Exception ee) {}

     }
    public void mouseDragged(MouseEvent e) {}

    public void keyTyped(KeyEvent e) {
	char ch = e.getKeyChar();
	int test=0;
	if(ch=='z') test=1;
	if(ch=='x') test=2;
	if(ch=='c') test=3;

	if(ch=='r') {
              COUNT=0;
	      CB.HALT=true;
	}
	if(ch=='h') {
	      CB.HALT=true;
	}

	if(test>0) doMouseClick(JX,test);
	repaint();
    }

	public void keyPressed(KeyEvent e) {}
        public void keyReleased(KeyEvent e) {}



}

