import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class ProofPartition {

     /*This file contains the routines that verify that
       the partition is correct.  We check 6 things::
       1. The pieces of the domain partition are contained in F1.
       2. The pieces of the range partition are contained in F1.
       3. The pieces of the domain partition under f' are contained in F2
       4. The pieces of the domain partition have pairwise disjoint interiors. 
       5. The pieces of the range  partition have pairwise disjoint interiors.
       6. The pieces of the domain partition fill the parallelotope.
       These 3 things imply that the range partition also fills.*/

    public static void main(Manager M) {
	for(int i=0;i<8;++i) M.C.MESSAGE[i]="";

	disjointInteriors1();
	M.C.MESSAGE[0]="partition 1 is a partition.";

	disjointInteriors2();
	M.C.MESSAGE[1]="partition 2 is a partition.";

	disjointInteriors4();
	M.C.MESSAGE[2]="partition 4 is a partition.";

	insidePartition1();
	M.C.MESSAGE[3]="partition 2 refines partition 1";

	insidePartition2();
	M.C.MESSAGE[4]="partition 4 refines partition 2";

	M.C.repaint();
    }

    public static void fail() {
	throw new ProofException("partition proof fails");
    }

    /**This checks that the polyhedra in partition 1 have disjoint interiors*/

    public static void disjointInteriors1() {
	for(int i=1;i<13;++i) {
	    for(int j=i+1;j<13;++j) {
	        LongPolyhedron P=DataPartition1.poly(i);
	        LongPolyhedron Q=DataPartition1.poly(j);
		boolean test=LongPolyCombinatorics.separate(10,P,Q);
		if(test==false) fail();
	    }
	}
    }

    public static void disjointInteriors2() {
	for(int i=0;i<40;++i) {
	    for(int j=i+1;j<40;++j) {
	        LongPolyhedron P=DataPartition2.poly(i);
	        LongPolyhedron Q=DataPartition2.poly(j);
		boolean test=LongPolyCombinatorics.separate(10,P,Q);
		if(test==false) fail();
	    }
	}
    }

    public static void disjointInteriors4() {
	for(int i=0;i<25;++i) {
	    for(int j=i+1;j<25;++j) {
	        LongPolyhedron P=DataPartition4.poly(i);
	        LongPolyhedron Q=DataPartition4.poly(j);
		P.FACE=LongPolyFace.faceList(P);
		Q.FACE=LongPolyFace.faceList(Q);
		boolean test=LongPolyCombinatorics.separate(16,P,Q);
		if(test==false) {
                      System.out.println(i+" "+j);
                      fail();
		}
	    }
	}
    }

    public static void insidePartition1() {
	for(int i=0;i<40;++i) {
	   LongPolyhedron P=DataPartition2.poly(i);
	   int j=ProofSupport.insidePartition(P);
	   if(i==-1) fail();
	}
    }


    public static void insidePartition2() {
	for(int i=0;i<25;++i) {
	   LongPolyhedron P=DataPartition4.poly(i);
	   int j=ProofSupport.insidePartition2(P);
	   if(j==-1) fail();
	   System.out.print(j+" ");
	}
	System.out.println("");
    }


}









