import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This contains some routines that are useful
for our rigorous calculations.  Some of these routines
were used to generate data for the calculations
and are not actively in use.*/


public class ProofSupport {

    /**This routine does the basic (dogbone) map on a polyhedron X,
       knowing which polyhedron in the partition contains X.
       sign=1 is the map.  sign=-1 is the inverse map.*/

    public static LongPolyhedron dogboneMap(int sign,int q,LongPolyhedron X) {
	LongPolyhedron Y=new LongPolyhedron();
	Y.count=X.count;
	for(int i=0;i<X.count;++i) Y.V[i]=dogboneMap(sign,q,X.V[i],X.SCALE); 
	Y.SCALE=X.SCALE;
        if(Y.V[0].x[0]<0) Y=Y.translateRight();
        if(Y.V[0].x[0]>2*Y.SCALE) Y=Y.translateLeft();
	Y.FACE=X.FACE;
	return(Y);
    }

    /**This routine does the basic map, knowing which   
       polyhedron in the partition contains the vector.*/

    public static LongVector dogboneMap(int sign,int q,LongVector V,long SCALE) {
       int[] t=DataPartition1.move(q);
       for(int i=0;i<t.length;++i) t[i]=sign*t[i];
       LongAffine A=DataPartition1.fromIntegers(t);
       A.v=A.v.scale(SCALE);
       LongVector W=A.act(V);
       return(W);
    }

    /**This returns an integer 0,...,12 if the polyhedron is
       contained in the partition polyhedron poly(k).  Otherwise
       the return is -1*/

    public static int insidePartition(LongPolyhedron P) {
	for(int i=0;i<13;++i) {
	    if(insidePartition(P,i)==true) return(i);
	}
	return(-1);
    }

    /*This tests if a polyhedron is contained in the partition
      polyhedron poly(k)*/

    public static boolean insidePartition(LongPolyhedron P,int k) {
	LongPolyhedron Q=DataPartition1.poly(k);
	for(int i=0;i<P.count;++i) {
	    if(LongPolyCombinatorics.inside(P.V[i],Q)==false) return(false);
	}
	return(true);
    }

    /**This returns an integer 0,...,,80 if the polyhedron is
       contained in the partition3 polyhedron poly(k).  Otherwise
       the return is -1.  In the application, we need to scale
       up the target partition by 99.*/

    public static int insidePartition2(LongPolyhedron P) {
	for(int i=0;i<80;++i) {
	    if(insidePartition2(P,i)==true) return(i);
	}
	return(-1);
    }

    /*This tests if a polyhedron is contained in the partition
      polyhedron poly(k)*/

    public static boolean insidePartition2(LongPolyhedron P,int k) {
	LongPolyhedron Q=DataPartition2.poly(k);
	Q=Q.dilate(99);
	for(int i=0;i<P.count;++i) {
	    if(LongPolyCombinatorics.inside(P.V[i],Q)==false) return(false);
	}
	return(true);
    }


}









