import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ProofVolumes {

    public static void main(Manager M) {
	BigInteger v1=vol1();
	BigInteger v2=vol2();
	BigInteger v3=vol3();
	BigInteger v4=vol4();
	if(v1.compareTo(v2)!=0) System.out.println("fail");
	if(v3.compareTo(v4)!=0) System.out.println("fail");
	for(int i=0;i<8;++i) M.C.MESSAGE[i]="";
	M.C.MESSAGE[0]="volume calc 1 done";
	M.C.MESSAGE[1]="volume calc 2 done";
	M.C.repaint();
    }


    /**Computes 12 times the volume of partition 1*/

    public static BigInteger vol1() {
	BigInteger total=new BigInteger("0");
	for(int i=1;i<13;++i) {
	    LongPolyhedron P=DataPartition1.poly(i);
	    P.FACE=LongPolyFace.faceList(P);
	    boolean test=checkBad(P);
	    if(test==true) throw new ProofException("bad face");
	    BigInteger v=volume12(0,P);
	    total=total.add(v);
	}
	System.out.println("partition 1: "+total.toString());
	return(total);
    }

    /**Prints out 12 times the volume of partition 2*/

    public static BigInteger vol2() {	
	BigInteger total=new BigInteger("0");
	for(int i=0;i<40;++i) {
	    LongPolyhedron P=DataPartition2.poly(i);
	    P.FACE=LongPolyFace.faceList(P);
	    boolean test=checkBad(P);
	    if(test==true) throw new ProofException("bad face");
	    BigInteger v=volume12(0,P);
            total=total.add(v);
	}	
	System.out.println("partition 2: "+total.toString());
	return(total);
    }

    /**prints out 12 times the volume of the 4 chopped pieces (0,7,8,18)
       of partition 2.  What we mean is that these pieces are intersected 
       with the halfspace s>=2/3, and then the volume is computed.*/
 
    public static BigInteger vol3() {	
	BigInteger total=new BigInteger("0");
	int[] list={0,7,8,18};
	for(int i=0;i<4;++i) {
	    LongPolyhedron P=DataPartition2.poly(list[i]);
	    P=LongPolyIntersect.chop(P);
	    P.FACE=LongPolyFace.faceList(P);
	    boolean test=checkBad(P);
	    if(test==true) throw new ProofException("bad face");
	    BigInteger v=volume12(0,P);
            total=total.add(v);
	}	
	BigInteger n99=new BigInteger("99");
	total=total.multiply(n99);
	total=total.multiply(n99);
	total=total.multiply(n99);
        System.out.println("partition 2, chop: 0,7,8,18: "+total.toString());
	return(total);
    }


    /**Prints out 12 times the volume of partition 4. We only compute the
       pieces which lie in the chopped versions of (0,7,8,18)*/

    public static BigInteger vol4() {	
	BigInteger total=new BigInteger("0");
	for(int i=0;i<25;++i) {
	    LongPolyhedron P=DataPartition4.poly(i);
	    P.FACE=LongPolyFace.faceList(P);
	    boolean test=checkBad(P);
	    if(test==true) throw new ProofException("bad face");
	    BigInteger v=volume12(0,P);
	    total=total.add(v);
	}	
        System.out.println("partition 4, chop: 0,7,8,18: "+total.toString());	
        return(total);
    }




    /*Computes 12 times the volume, in case no face has more than 4 vertices.
      The volume is computed by coning to the qth vertex.*/

    public static BigInteger volume12(int q,LongPolyhedron P) {
	LongVector V0=P.V[q];
	BigVector V=new BigVector(V0);
	BigInteger total=new BigInteger("0");
	for(int i=0;i<P.FACE.length;++i) {
	    LongVector[] W0=P.face(i);
	    BigVector[] W=new BigVector[W0.length];
	    for(int j=0;j<W0.length;++j) W[j]=new BigVector(W0[j]);
	    if(W.length==3) total=total.add(BigVector.volumePrism3(V,W));
	    if(W.length==4) total=total.add(BigVector.volumePrism4(V,W));
	}
	return(total);
    }





    public static long volumePrism3(LongVector V,LongVector[] W) {
	LongVector[] X=new LongVector[3];
	for(int i=0;i<3;++i) X[i]=LongVector.minus(W[i],V);
	Long t=LongVector.dot(X[0],LongVector.cross(X[1],X[2]));
	if(t<0) t=-t;
	return(2*t);
    }



    public static long volumePrism4(LongVector V,LongVector[] W) {
	LongVector[] X=new LongVector[4];
	for(int i=0;i<4;++i) X[i]=LongVector.minus(W[i],V);
	Long t1=LongVector.dot(X[0],LongVector.cross(X[1],X[2]));
	Long t2=LongVector.dot(X[0],LongVector.cross(X[1],X[3]));
	Long t3=LongVector.dot(X[0],LongVector.cross(X[2],X[3]));
	Long t4=LongVector.dot(X[1],LongVector.cross(X[2],X[3]));
	Long[] t={t1,t2,t3,t4};
	for(int i=0;i<4;++i) if(t[i]<0) t[i]=-t[i];
	long u=t[0]+t[1]+t[2]+t[3];
	return(u);
    }

    /**This returns true of some face has at least 5 vertices.*/

    public static boolean checkBad(LongPolyhedron P) {
	for(int i=0;i<P.FACE.length;++i) {
	    int[] t=Combinatorics.binaryList(P.count,P.FACE[i]);
	    if(t.length>4) return(true);
	}
	return(false);
    }




}




