import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ShapeEntrySystem {
    int x,y;
    String S;
    String HISTORY;
    boolean ACTIVE;
    ListenSquare RAN,MAIN,TEXT;
    Color COLOR;
    SelectInteger ADVANCE;

    public ShapeEntrySystem(int xx,int yy,String s,Color C) {
	this.x=xx;
	this.y=yy;
	this.S=s;
	TEXT=new ListenSquare(x,y,400,200);
	ACTIVE=false;
	COLOR=C;
	MAIN=new ListenSquare(x,y,500,200);
	HISTORY="";
	ADVANCE=new SelectInteger(350,5,56,28,3,1,4,1);
	RAN=new ListenSquare(310,2,28,28);
    }


    public void render(Graphics2D g) {
	g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,32));
	g.drawString(S,x+10,y+28);
	ADVANCE.render(g,Color.red,new Color(0,0,0,0),new Color(0,0,0,0));
	RAN.render(g,Color.red);
    }

    public void activate(Point X) {
	ACTIVE=false;
	if(TEXT.inside(X)==1) ACTIVE=true;
    }

    public int classify() {
	int c2=countChar(S,'/');
	int c3=countChar(S,'(');
	int c4=countChar(S,')');
	if(c3!=c4) return(-1);
	if(c3>0) return(1);
	return(0);
    }

    public int[] interpretFraction() {
	try {
	   return(interpretFraction(S));
	}
	catch(Exception e) {
	    int[] a={3,4};
	    return(a);
	}

    }

    public int[] interpretFraction(String U) {
	int k=U.indexOf("/");
	if(k==-1) {
	    U=U.replace(" ","");
	    Integer I=new Integer(U);
	    int[] a={I.intValue(),1};
	    return(a);
	}
	String T1=U.substring(0,k);
	String T2=U.substring(k+1,U.length());
	Integer I1=new Integer(T1);
	Integer I2=new Integer(T2);
	int[] I={I1.intValue(),I2.intValue()};
	return(I);
    }

    public int countChar(String T,char x) {
	int count=0;
	int n=T.length();
	for(int i=0;i<n;++i) {
	    char ch=T.charAt(i);
	    if(ch==x) ++count;
	}
	return(count);
    }

    public boolean acceptFraction(int[] b) {
	long[] c={b[0],b[1]};
	acceptFraction(c);
	return(true);
    }

    public boolean acceptFraction(long[] b) {
	if(b[0]<=0) return(false);
	if(b[1]<=0) return(false);
	Long b0=new Long(b[0]);
	Long b1=new Long(b[1]);
	S=b0.toString()+"/"+b1.toString();
	return(true);
    }

    public double getParameter() {
       int[] b=interpretFraction();
       double y=1.0*b[0]/b[1]; 
       return(y);
    }

    public int[] getFraction() {
       int[] b=interpretFraction();
       return(b);
    }

    /*testing whether the selector is used*/

    public boolean inside(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(MAIN.inside(J.X)==1) return(true);
	return(false);
    }

    public boolean inside(Point X) {
	if(MAIN.inside(X)==1) return(true);
	return(false);
    }

    public void advance(Point X) {
	int k=ADVANCE.isModified(X);
	if(k!=0) {
	    int[] b=interpretFraction();
	    ADVANCE.val=b[0];
	    ADVANCE.max=b[1];
	    ADVANCE.modify(X);
	    b[0]=ADVANCE.val;
	    if(2*b[0]<=b[1]) ++b[0];
	    if(b[0]==b[1]) --b[0];
	    acceptFraction(b);
	}
    }

    public void getRandom() {
	int[] b={(int)(50+50*Math.random()),100};
	if(b[0]==0) ++b[0];
	if(b[0]==100) --b[0];
	acceptFraction(b);
    }



    public boolean process(MouseEvent e) {
	MouseData J=MouseData.process(e);
	activate(J.X);
	advance(J.X);
	if(RAN.inside(J.X)==1) {
            getRandom();
	    return(true);
	}
	int k=ADVANCE.isModified(J.X);
	if(k!=0) return(true);
	return(false);

    }


    public boolean processKey(KeyEvent e) {
	if(ACTIVE==false) return(false);
	int n=S.length();

	char ch=e.getKeyChar();

        if(isDigit(ch)==true) S=S+ch;

	int val=0;
	val=(int)(ch-'/');
	if(val==0) S=S+"/";

	val=(int)(ch-' ');
	if(val==0) S=S+" ";

        if (ch==KeyEvent.VK_BACK_SPACE) {
	    if(n>0) S=S.substring(0,n-1);
        }

        if (ch==KeyEvent.VK_DELETE) {
            S="3/4";
        }

	if(S.length()>50) S=S.substring(0,n-1);
	return(true);

    }

    public boolean isDigit(char ch) {
        int val=(int)(ch-'0');
        if ((val>=0)&&(val<=9)) {
	    return(true);
	}
	return(false);
    }


}





