import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class BirdInvariants {
    double x,y;
    
    public BirdInvariants() {}

    //vectors should be normalized to have 3rd coordinate equal to 1.

    public static double slope(Vector V1,Vector V2) {
        double s;
        s=(V2.x[1]-V1.x[1])/(V2.x[0]-V1.x[0]);
        return(s);
    }


    //inverse of usual cross ratio
    public static double cross0(double a,double b,double c,double d)
      {
      double x;
      x=(a-b)*(c-d)/((a-c)*(b-d));
      return(x);
      }


    public static double fan(Vector x,Vector a,Vector b,Vector c,Vector d) {
        double f=cross0(slope(x,a),slope(x,b),slope(x,c),slope(x,d));
        return(f);
    }



    // the local invariant
    public static double locinv(int k,PolyVector P,int j) {
        int i;
	int[] a={0,-k,-k-1,k+1,k};
	int n=P.count;
	PolyVector Q=P.rotate(Math.sqrt(2.0));   //a random rotation to avoid degeneracies

	
	int j1=(j+a[0]+2*n)%n;
	int j2=(j+a[1]+2*n)%n;
	int j3=(j+a[2]+2*n)%n;
	int j4=(j+a[3]+2*n)%n;
	int j5=(j+a[4]+2*n)%n;

	
	double ll=fan(Q.V[j1],Q.V[j2],Q.V[j3],Q.V[j4],Q.V[j5]);
        return(ll);
    }


    // the global invariants

    public static double[] invariant(int k,PolyVector P) {
	double[] x=new double[P.count];

        for(int i=0;i<P.count;++i) {
	    x[i]=locinv(k,P,i);
	}
	return(x);
    }

    public static double energy(int k,PolyVector P) {
	double[] y=invariant(k,P);
	double t=1;
	for(int i=0;i<y.length;++i) t=t*y[i];
	return(t);
    }

    
}


