import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements KeyListener, MouseListener,MouseMotionListener {
    Manager M;
    ControlPanel MAP,DIAG_CHOICE;
    SelectColor CS;
    ControlPanelColor DISPLAY;
    ListenSquare CONTROL,TEST,RESET,INFO;
    SelectInteger ENERGY,CHOICE,POINT,POINT2,OFFSET;
    Complex[][] plot=new Complex[100][3];
    int COUNT=0;
    Animator AN;
    PolyVector P;
    Matrix MAT;
    Point JX;
    boolean DRAG;
    Documentation DOC;


     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	  addKeyListener(this);
	 TEST=new ListenSquare(0,280,40,20);
	 RESET=new ListenSquare(0,305,40,20);
	 CONTROL=new ListenSquare(0,0,120,600);
	 CS=new SelectColor(this.M,0,649,500,50);
	 INFO=new ListenSquare(50,250,12,12);

	 ENERGY=new SelectInteger(0,360,40,20,4,2,15,1);
	 CHOICE=new SelectInteger(0,410,40,20,0,0,4,1);
	 OFFSET=new SelectInteger(0,460,40,20,0,0,100,1);
	 POINT=new SelectInteger(0,510,40,20,16,4,30,1);
	 POINT2=new SelectInteger(0,560,40,20,16,4,30,1);

	 AN=new Animator();
	 setScales(500,500,200);
  	 P=PolyVector.regular(8*ENERGY.val+4);
	 P=P.align(ENERGY.val);
	 setPanels();
	 MAT=Matrix.random(1);
	 JX=new Point(0,0);
	 DRAG=false;
	 DOC=new Documentation();
     }


    public void setPanels() {
        Color[] C0={new Color(200,0,200),Color.white,Color.white,Color.black,new Color(180,180,180)};
	
	String[] Map={"no","yes","map"};
	 int[] MapState={1,0};
         MAP=new ControlPanel(C0,Map,MapState,2);
	 
	 String[] Action={"k","k+1","diag"};
	 int[] ActionState={1,0};
         DIAG_CHOICE=new ControlPanel(C0,Action,ActionState,2);

	 String[] DString={"background",
			   "halfspace",
			   "polygon",
			  "quad",
			   "all zeros",
			   "all poles",
			   "current zero",
			   "current pole",
			  "display"};
    Color[] DColor={new Color(255,255,255),
		    new Color(200,200,200),
		    new Color(150,150,150),
		    new Color(0,0,0),
		    Color.red,Color.blue,
		    Color.red,Color.blue};
    int[] DState={1,1,1,1,0,0,1,1};
        DISPLAY=new ControlPanelColor(C0,DString,DState,8,DColor);
	DISPLAY.mode=0;

}





    
    

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.blue);
      g.fillRect(0,0,getWidth(),getHeight());
      drawBG(g);
       drawHalfspace(g);
       drawZerosAndPoles(g);
       drawPolyRegular(g);
       drawInvariant(g);
      drawSource(g);
       drawControls(g);
   }


    public void drawSource(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(SOURCE.x,SOURCE.y);
	p.lineTo(SOURCE.x,SOURCE.y-.2);
	p=transform(p);
	g.setColor(Color.black);
	g.setStroke(new BasicStroke(2));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }


      public void drawBG(Graphics2D g) {
  	  g.setColor(DISPLAY.M[0].C);
          g.fillRect(0,0,getWidth(),getHeight());
    }

    
    
    public void drawHalfspace(Graphics2D g) {
	if(DISPLAY.L[1].on==0) return;
	   Path2D.Double p=new Path2D.Double();
	   p.moveTo(-10,0);
	   p.lineTo(+10,0);
	   p.lineTo(-10,-100);
	   p.lineTo(+10,-100);
	    p=transform(p);
	    g.setColor(DISPLAY.M[1].C);
	    g.fill(p);
    }

    
	      

    public void drawControls(Graphics2D g) {
	CONTROL.render(g,Color.blue);
	INFO.infoRender(g);
	MAP.render(g,0,0,60);
	DIAG_CHOICE.render(g,60,0,60);
	TEST.render(g,"test",12,4,new Color(130,0,130));
	RESET.render(g,"reset",12,4,new Color(130,0,130));
	DISPLAY.render(g,0,60,100);
	CS.render(g);

	Color C=new Color(0,160,0);
	ENERGY.render(g,C,Color.white,Color.white);
	CHOICE.render(g,C,Color.white,Color.white);
	POINT.render(g,C,Color.white,Color.white);
	POINT2.render(g,C,Color.white,Color.white);
	OFFSET.render(g,C,Color.white,Color.white);

	int[] y={ENERGY.y,CHOICE.y,POINT.y,POINT2.y,OFFSET.y};
	String[] S={"energy choice","vertex choice","quad pointsize","poly pointsize","offset"};
	g.setColor(Color.white);
           	for(int i=0;i<5;++i) g.drawString(S[i],5,y[i]-5);
   }



    public Color reliefColor() {
	int r=DISPLAY.M[1].C.getRed();
	int g=DISPLAY.M[1].C.getGreen();
	int b=DISPLAY.M[1].C.getBlue();
	if(r+g+b>300) return Color.black;
	return Color.white;
    }

    
    public void drawInvariant(Graphics2D g) {
	if(DISPLAY.L[3].on==0) return;
	if(MAP.mode==0) drawInvariantBasic(g);
	else{
	   if(DIAG_CHOICE.mode==0) drawInvariantDual0(g);
	   if(DIAG_CHOICE.mode==1) drawInvariantDual1(g);
	}
	
    }

    public int selectVertex() {
	int k=ENERGY.val;
	int c0=CHOICE.val;
	int[] x0={0,k+1,-k-1,-k};
	int[] x1={0,k+0,-k-1,-k};
	int c=x0[c0];
	if(DIAG_CHOICE.mode==1) c=x1[c0];
	return c;
    }


    public String selectVertexName() {
	int k=ENERGY.val;
	int c0=CHOICE.val;
	String[] x0={"0","k+1","-k-1","-k"};
	String[] x1={"0","k","-k-1","-k"};
	String c=x0[c0];
	if(DIAG_CHOICE.mode==1) c=x1[c0];
	return c;
    }

    
    public void drawInvariantDual0(Graphics2D g) {
	int k=ENERGY.val;
	int c=selectVertex();

	c=c+OFFSET.val;
	
	int n=8*k+4;

	int e1=(10*n-c)%n;
	int e2=(10*n-c-k)%n;

	int e3=(n+e1-k-1)%n;
	int e4=(n+e2-k-1)%n;

	int e5=(n+e1+k+1)%n;
	int e6=(n+e2+k+1)%n;

	Vector V1=Vector.findCross(P.V[e1],P.V[e2],P.V[e3],P.V[e4]);
	Vector V2=Vector.findCross(P.V[e1],P.V[e2],P.V[e5],P.V[e6]);

	double r=Math.pow(.8,POINT.val);
	Color C=DISPLAY.M[3].C;
	fillPoint(g,new Complex(P.V[e1]),r,C,16);
	fillPoint(g,new Complex(P.V[e2]),r,C,16);
	fillPoint(g,new Complex(V1),r,C,16);
	fillPoint(g,new Complex(V2),r,C,16);

	PolyVector Q=P.dualMap(k);

	double d=BirdInvariants.locinv(k,Q,c);
	Double D=new Double(d);
	g.setColor(reliefColor());
	g.setFont(new Font("Helvetica",Font.PLAIN,20));
	g.drawString(D.toString(),700,680);

    }

    public void drawInvariantDual1(Graphics2D g) {
	int k=ENERGY.val;
	int n=8*k+4;
	int c=selectVertex();
	c=c+OFFSET.val;
	

	int e1=(10*n-c)%n;
	int e2=(10*n-c-k-1)%n;

	int e3=(n+e1-k)%n;
	int e4=(n+e2-k)%n;

	int e5=(n+e1+k)%n;
	int e6=(n+e2+k)%n;

	Vector V1=Vector.findCross(P.V[e1],P.V[e2],P.V[e3],P.V[e4]);
	Vector V2=Vector.findCross(P.V[e1],P.V[e2],P.V[e5],P.V[e6]);

	Color C=DISPLAY.M[3].C;
	double r=Math.pow(.8,POINT.val);
	fillPoint(g,new Complex(P.V[e1]),r,C,16);
	fillPoint(g,new Complex(P.V[e2]),r,C,16);
	fillPoint(g,new Complex(V1),r,C,16);
	fillPoint(g,new Complex(V2),r,C,16);

	PolyVector Q=P.dualMap(k+1);
	double d=BirdInvariants.locinv(k,Q,c);
	Double D=new Double(d);
	g.setFont(new Font("Helvetica",Font.PLAIN,20));
     	g.setColor(reliefColor());
	g.drawString(D.toString(),700,680);
    }

    
    
    public void drawInvariantBasic(Graphics2D g) {
	int k=ENERGY.val;
	int c=selectVertex();

	c=c+OFFSET.val;

	Color C=DISPLAY.M[3].C;
	int n=8*k+4;
        int[] cc={c,c-k,c-k-1,c+k+1,c+k};
	for(int i=0;i<5;++i) cc[i]=(cc[i]+2*n)%n;

	for(int i=0;i<4;++i)
	    drawDiag(g,P,cc[0],cc[i+1],C,2);

	double d=0;
	if(DIAG_CHOICE.mode==0) d=BirdInvariants.locinv(k,P,cc[0]);
	if(DIAG_CHOICE.mode==1) d=BirdInvariants.locinv(k,P,cc[0]);
	Double D=new Double(d);

	g.setFont(new Font("Helvetica",Font.PLAIN,20));
	g.setColor(reliefColor());
	g.drawString(D.toString(),700,680);
    }

    
    

    

    public void drawPolyRegular(Graphics2D g) {
	
	int k=ENERGY.val;
	int n=8*k+4;
	PolyVector Q=new PolyVector(P);
	
	int[] t0={0,k+1,-k-1,-k};
	int[] t1={0,k,-k-1,-k};
	
	double r=Math.pow(.8,POINT2.val);
	Color C=DISPLAY.M[2].C;
	
	for(int i=0;i<Q.count;++i) {
	    fillPoint(g,new Complex(Q.V[i]),r,C,32);
	}
	
	for(int i=0;i<4;++i) {
	    int ii=(t0[i]+n)%n;
	    if(DIAG_CHOICE.mode==1) ii=(t1[i]+n)%n;
	}

    }

    
    public void drawZerosAndPoles(Graphics2D g) {

	int[][] a0={{0,1},{6,7},{4,5},{2,3}};
	int[][] b0={{6,5},{0,3},{2,1},{4,7}};

	int[][] a1={{0,1},{6,7},{2,3},{4,5}};
	int[][] b1={{6,5},{0,3},{4,7},{2,1}};

	int[][][][] aa={{a0,b0},{a1,b1}};
	int[] t=aa[DIAG_CHOICE.mode][MAP.mode][CHOICE.val];

	
	int k=ENERGY.val;
	int n=8*k+4;
	PolyVector Q=new PolyVector(P);

	if(DISPLAY.L[4].on==1) {
	for(int i=0;i<8;i=i+2) {
	    int[] u=Spectrum.diagonal0(k,i);
	    if(DIAG_CHOICE.mode==1)  u=Spectrum.diagonal1(k,i);
	    u[0]=(u[0]+n)%n;
	    u[1]=(u[1]+n)%n;
   	    drawLine(g,Q,u[0],u[1],DISPLAY.M[4].C,1);
	}}

	if(DISPLAY.L[5].on==1) {
	for(int i=1;i<8;i=i+2) {
	    int[] u=Spectrum.diagonal0(k,i);
	    if(DIAG_CHOICE.mode==1)  u=Spectrum.diagonal1(k,i);
	    u[0]=(u[0]+n)%n;
	    u[1]=(u[1]+n)%n;
   	    drawLine(g,Q,u[0],u[1],DISPLAY.M[5].C,1);
	}}

	
	if(DISPLAY.L[6].on==1) {
	    int[] u=Spectrum.diagonal0(k,t[0]);
	    if(DIAG_CHOICE.mode==1)  u=Spectrum.diagonal1(k,t[0]);
	    u[0]=(u[0]+n)%n;
	    u[1]=(u[1]+n)%n;
	    drawLine(g,Q,u[0],u[1],DISPLAY.M[6].C,2);
	}

	if(DISPLAY.L[7].on==1) {
	    int[] u=Spectrum.diagonal0(k,t[1]);
	    if(DIAG_CHOICE.mode==1)  u=Spectrum.diagonal1(k,t[1]);
	    u[0]=(u[0]+n)%n;
	    u[1]=(u[1]+n)%n;
	    drawLine(g,Q,u[0],u[1],DISPLAY.M[7].C,2);
	}

	
	String[] S0=Spectrum.diagonalName0(k,t[0]);
	String[] S1=Spectrum.diagonalName0(k,t[1]);
	if(DIAG_CHOICE.mode==1) {
	     S0=Spectrum.diagonalName0(k,t[0]);
             S1=Spectrum.diagonalName0(k,t[1]);
	}
	Integer T0=new Integer(t[0]);
	Integer T1=new Integer(t[1]);

	
	Integer SITE=new Integer(CHOICE.val);
	String SITE2=selectVertexName();
	g.setFont(new Font("Helvetica",Font.PLAIN,20));
	g.setColor(reliefColor());
	g.drawString("vertex "+SITE.toString()+"   "+SITE2,700,600);
	g.drawString("zero "+T0.toString()+"    "+S0[0]+" "+S0[1],700,625);
	g.drawString("pole "+T1.toString()+"    "+S1[0]+" "+S1[1],700,650);


	
    }

	public void drawDiag(Graphics2D g,PolyVector Q,int i,int j,Color C,int thick) {
            Complex z0=new Complex(Q.V[i]);
	    Complex z1=new Complex(Q.V[j]);
	   Path2D.Double p=new Path2D.Double();
	    p.moveTo(z0.x,z0.y);
	    p.lineTo(z1.x,z1.y);
	    p=transform(p);
	    g.setColor(C);
	    g.setStroke(new BasicStroke(thick));
	    g.draw(p);
	    g.setStroke(new BasicStroke(1));
    }




	public void drawLine(Graphics2D g,PolyVector Q,int i,int j,Color C,int thick) {
            Complex z0=new Complex(Q.V[i]);
	    Complex z1=new Complex(Q.V[j]);
	   Path2D.Double p=new Path2D.Double();
	   double x1=100*z0.x-99*z1.x;
	   double y1=100*z0.y-99*z1.y;
	   double x2=100*z1.x-99*z0.x;
	   double y2=100*z1.y-99*z0.y;
	   p.moveTo(x1,y1);
	   p.lineTo(x2,y2);
	    p=transform(p);
	    g.setColor(C);
	    g.setStroke(new BasicStroke(thick));
	    g.draw(p);
	    g.setStroke(new BasicStroke(1));
    }




    public static int format(int c,int n) {
	if(c<n/2) return c;
	return c-n;
    }
    

    public void doControls(Point X) {
	int test=0;
	DOC.M=this.M;

	test=INFO.inside(X);
	if(test==1) DOC.big_info();
	
	test=DISPLAY.process(X,CS.C);
	if(test==20) DOC.display_info();
	
	ENERGY.modify(X);
	POINT.modify(X);
	POINT2.modify(X);
	OFFSET.modify(X);
	test=MAP.switchMode(X);
	if(test==20) DOC.map_info();
	test=DIAG_CHOICE.switchMode(X);
	if(test==20) DOC.choice_info();
	CHOICE.modifyCyclic(X);
	
	if(ENERGY.isModified(X)==1) {
	    P=PolyVector.regular(8*ENERGY.val+4);
	    if(DIAG_CHOICE.mode==0) P=P.align(ENERGY.val);
	    if(DIAG_CHOICE.mode==1) P=P.align(ENERGY.val+1);
	}

	if(test!=-1) {
	    P=PolyVector.regular(8*ENERGY.val+4);
	    if(DIAG_CHOICE.mode==0) P=P.align(ENERGY.val);
	    if(DIAG_CHOICE.mode==1) P=P.align(ENERGY.val+1);
	}

	
	if(TEST.inside(X)==1) doTest();
	if(RESET.inside(X)==1) P.V[0]=new Vector(0,0,1);
	M.repaint();
    }




    
    public void doMouseClick(int mode) {
	
	doScale(mode,JX);
   	if(mode==2)  {
	       SOURCE=unTransform(JX);
	       SOURCE.y=0;
       	       P.V[0].x[0]=SOURCE.x;
	}
	repaint();
	
    }

    public void mouseClicked(MouseEvent e) {
	DOC.M=this.M;
	MouseData J=MouseData.process(e);

	if(J.X.y>600) {
	    int test=CS.process(e);
	    if(test==20) DOC.color_info();
	    repaint();
	    return;
	}
	
	if(CONTROL.inside(J.X)==1) {
	    doControls(J.X);
	    repaint();
	    return;
	}
	
	if(J.mode==1) {
	   scaleUp(J.X,-1);
	}

	if(J.mode==3) {
	   scaleUp(J.X,+1);
	}

	if(J.mode==2) {
	   SOURCE=unTransform(J.X);
	   SOURCE.y=0;
	   P.V[0].x[0]=SOURCE.x;
	}
	M.repaint();
       
    }
    
	
    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
       	 requestFocus();
     }
    
     public void mouseExited(MouseEvent e) {}   


     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) return;
	JX=new Point(J.X);
	if(DRAG==true) {
	    doMouseClick(2);
	    repaint();
	}
	
     }
    

    
     public void mouseDragged(MouseEvent e) {

	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) return;
	else {
	    if(J.mode==2) {
	      SOURCE=unTransform(J.X);
	      SOURCE.y=0;
	      P.V[0].x[0]=SOURCE.x;
	    }
	}
	repaint();
     }

    

     public void keyReleased(KeyEvent e) {
	 DRAG=false;
     }

     public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=-100;
	if(ch=='z') test=1;   
	if(ch=='x') test=2;   
	if(ch=='c') test=3;  
	doMouseClick(test);
     }

    
    public void keyPressed(KeyEvent e) {
	char ch=e.getKeyChar();
	if(ch=='x') {
           DRAG=true;
	}
    }

    
    /**The tests*/

    public void doTest() {
	double d1=0;
	double d2=0;

            P=PolyVector.regular(8*ENERGY.val+4);
	    if(DIAG_CHOICE.mode==0) P=P.align(ENERGY.val);
	    if(DIAG_CHOICE.mode==1) P=P.align(ENERGY.val+1);
	    int k=ENERGY.val;
	    int n=8*k+4;


	
	
	System.out.println("spectrum");
	System.out.println("---------------------");
	for(int i=0;i<n;++i) {
	    for(int j=0;j<8;++j) {
		if(DIAG_CHOICE.mode==0) {
		    d1=Spectrum.testValue1(MAP.mode,P,k,i,j,-.000001);
		    d2=Spectrum.testValue1(MAP.mode,P,k,i,j,.000001);
		}
		if(DIAG_CHOICE.mode==1) {
		    d1=Spectrum.testValue2(MAP.mode,P,k,i,j,-.000001);
		    d2=Spectrum.testValue2(MAP.mode,P,k,i,j,.000001);
		}
	    if(d1*d2<0) {
		int ii=format(i,n);
		System.out.println("match "+ii+" "+j+"    "+d1+" "+d2);
	    }
	}}
	System.out.println("---------------------");
    }




}

