import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class DocumentCanvas extends ScaleCanvas 
    implements MouseListener,MouseMotionListener {
    
    Manager M;
    String[] S=new String[500];
    String[] P=new String[500];
    int paragraphs;
    int linecount;
    String MAIN;
    ListenSquare F;
    SelectInteger FONT;
    Integer[] J=new Integer[200];
    ListenSquare L;
    Color COLOR1;
    Color COLOR2;
    int Y0,Y1;
    
    

    public DocumentCanvas addManager(Manager M) {
	DocumentCanvas XX=this;
	XX.M=M;
	return(XX);
    }
    
    public DocumentCanvas() {
        addMouseListener(this);
        addMouseMotionListener(this);
        setBackground(Color.black);
        FONT=new SelectInteger(25,5,40,20,12,8,22,1);

        for(int i=0;i<=199;++i) J[i]=new Integer(i);
        L=new ListenSquare(2,2,12,12,Color.black);
        L.on=1;
        paragraphs=0;
        setup();
	COLOR1=new Color(0,100,155);
	COLOR2=Color.white;
	Y0=0;
	Y1=0;
    }
    
    
    
    public int wordBreak(String A,int n) {
        String AA=new String();
        for(int i=n;i>0;--i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo(" ")==0) return(i);
        }
        return(n);
    }
    
    
    public void findBreaks(String A) {
        int count=0;
        int pos1=0;
        String AA=new String();
        for(int i=0;i<A.length();++i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo("\n")==0) {
                P[count]=A.substring(pos1,i);
                ++count;
                pos1=i;
            }
        }
        P[count]=A.substring(pos1,A.length());
        ++count;
        paragraphs=count;
    }
    
    
    
    public void paragraphDisplay(String A,int n) {
        
        int L=A.length();
        String AA=new String();
        int pos1=0;
        int pos2=0;
        int count=0;
        int LL=L;
        while(LL>0) {
            pos2=pos1+n;
            if(pos2>=L) {
                S[count+linecount]=A.substring(pos1,L);
                LL=0;
            }
            
            if(pos2<L) {
                pos2=wordBreak(A,pos2);
                S[count+linecount]=A.substring(pos1,pos2);
                ++count;
                LL=LL-(pos2-pos1);
                pos1=pos2;
            }
        }
        linecount=linecount+count+1;
    }
    
    
    
    
    
    public void display(int n) {
        for(int i=0;i<=499;++i) S[i]="";
        findBreaks(MAIN);
        linecount=0;
        for(int i=0;i<paragraphs;++i) {
            paragraphDisplay(P[i],n);
        }
    }
    
    
    
    public void paint(Graphics gfx) {
        
        
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);

	g.setColor(COLOR1);
	g.fillRect(0,50,getWidth(),getHeight()-22);
	g.setColor(Color.white);
	g.drawRect(0,50,getWidth(),getHeight()-22);

	drawFrame(g);
	drawWords(g);
    }


    public void drawFrame(Graphics2D g) {
	
        L.infoRender(g);
        FONT.render(g,Color.blue,Color.white,new Color(100,180,255));
	g.setColor(new Color(100,180,255));
	g.drawString("font size",30,40);
        Dimension D=this.getSize();
        g.setColor(Color.white);
        g.drawRect(0,0,D.width-1,D.height-1);

    }



    
    public void drawWords(Graphics2D g) {
	g.clipRect(15,55,2000,2000);
	g.setColor(Color.white);
	g.translate(0,-Y1);
        g.setFont(new Font("Helvetica",Font.PLAIN,FONT.val));
        int space=FONT.val+3;
        int n=2*getWidth()/(FONT.val)-5;
	display(n);    //line width
        for(int i=0;i<=499;++i) { 
                g.drawString(S[i],15,75+space*i);
        }
	g.translate(0,Y1);
    }
    

    
    
    
    public void mousePressed(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(J.X.y>40) 	Y0=J.X.y+Y1;
    }



    public void mouseMoved(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(J.X.y>40)   Y1=Y0-J.X.y;
	if(Y1<0) Y1=0;
	repaint();
    }

    
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
        FONT.modify(J.X);
        if(L.inside(J.X)==1) setup();
        repaint();
    }
    
    public void setup() {
	Y0=0;
	Y1=0;
	String S="THE FLAPPING BIRDS: Energy Study\n\n";
        S=S+"Rich Schwartz\n\n";
	S=S+"Current version: Feb 2024\n\n";

	    S=S+"OPERATING THIS WINDOW\n\n";

	    S=S+"This window gives explanations for the rest of the program.\n   1. move this window by dragging the top.\n   2. rezise this window by dragging the bottom right corner.\n   3. scroll text by dragging it upwards.\n   4. change the text size using the arrow keys at the top.\n";
	    S=S+"You should probably read the rest of this introduction before starting to play with the program.\n\n";

	    S=S+"PURPOSE OF PROGRAM\n\n";

	    S=S+"The purpose of this program is to understand the invariance of the energy function chi which is the subject of Statement 1 of the Main Theorem in the paper.   The proof in chapter 2 takes its pictures from this program.  The program probably won't make too much sense unless you have at least skimmed this chapter.  The basic idea is that you can move one vertex of a polygon around on a horizontal line and look at the values of two auxiliary functions. The main point is to see that the zeros and poles of these auxiliary functions appear as claimed in the paper.\n\n";
	    
	    S=S+"GENERAL OPERATING INSTRUCTIONS\n\n";

	    S=S+"This program has 2 windows:\n1. documentation (this window)\n2. the main window.\n\n";

	S=S+"Both windows can be moved by dragging the top.  Both windows can be resized by dragging the bottom left corner. (There is no reason to resize the control panel.)  If you want to exit the program, you kill the main, and then everything else dies as well.\n\n";

	S=S+"Many of the components of the program have little boxes with question marks in them.  When you click on these info buttons, this window will tell you about the corresponding component of the program.  Here is an exercise to get you started.\n   0. read the whole exercise before doing any of it.\n   1. click on any question box on the control panel\n   2. click on the question box at the top left corner of this window to return to this text.\n\n";

	S=S+"MOUSE COMPATABILITY\n\n";

	S=S+"This is designed to work best with a 3 button mouse. Generally speaking\n   1. clicking button 1 scales up the picture\n   2. clicking button 2 selects a new point in the window.\n   3. clicking button 3 scales down the picture.\n   4. On the control panel, all mouse clicks have the same effect.\n\n";

	S=S+"You can also use the keys z,x,c to  simulate mouse clicks.";

	S=S+"\n\nThe program seems to have a funny bug that I can't fix.  When you start it up, the progra is sluggish with respect to dragging the mouse.  If you drag the mouse around for a while the program warms up and eventually the sluggishnes goes away. I don't know why this happens.";


	MAIN = new String(S);
    }
    
    public void setExplain(String doc) {
        Y1=0;
	Y0=0;
        MAIN=doc;
        repaint();
    }
    
}

