import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;


public class PolyVector {
    Vector[] V=new Vector[100];
    int count;
    int wrap;

    public PolyVector() {
	for(int i=0;i<99;++i) 
	    V[i]=new Vector();
	wrap=0;
    }

    public PolyVector(PolyVector Q) {
	this.count=Q.count;
	for(int i=0;i<Q.count;++i) this.V[i]=new Vector(Q.V[i]);
	this.wrap=Q.wrap;
    }


    /**drawing routines*/
    public Path2D.Double toPath() {
	PolyVector P=this.normalize();
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(P.V[0].x[0],P.V[0].x[1]);
	for(int i=0;i<count;++i) {
	   gp.lineTo(P.V[i].x[0],P.V[i].x[1]);
	}
	gp.closePath();
	return(gp);
    }

    /*end drawing routines*/
    


    
    /**geometric routines*/
    /**from affine patch to plane*/
    public PolyVector normalize() {
	PolyVector P=new PolyVector();
	P.count=count;
	for(int i=0;i<count;++i) {
	    P.V[i]=V[i].normalize();
	}
	P.wrap=wrap;
	return(P);
    }


    public PolyVector rotate(double d) {
	PolyVector X=new PolyVector();
	X.count=this.count;
	for(int i=0;i<count;++i) {
	    X.V[i]=this.V[i].rotate(d);
	}
	return(X);
    }


    public int nearestVertex(Complex z) {
	int index=-1;
	Vector W=new Vector(z);
	double min=1000000.0;
	for(int i=0;i<count;++i) {
	    double test=W.dist(W,this.V[i]);
	    if(test<min) {
		min=test;;
		index =i;
	    }
	}
	return(index);
    }

    public PolyVector cycleVertices(int h) {
	PolyVector X=new PolyVector();
	X.count=this.count;
	for(int i=0;i<count;++i) {
	    int j=(i+h+100*count)%count;
	    X.V[i]=V[j];
	}
	return(X);
    }


    public PolyVector dual() {
	int n=this.count;
	PolyVector X=new PolyVector();
	X.count=n;
	for(int i=0;i<n;++i) {
	    int j=(i+1)%n;
	    X.V[i]=Vector.cross(V[i],V[j]);
	    X.V[i]=X.V[i].normalize();
	}
	return X;
    }


    /**end geometric routines*/

    


    /**pentagram map:
      k1 is the diagonal choice and
      k2 is the skip between consecutive diagonals.  
      The pentagram map is given by k1=2 and k2=1;*/
    

    public PolyVector pentagram(int k1,int k2) {

	PolyVector X=new PolyVector();
	X.count=count;
	int i1,i2,i3,i4;
	int k3=k1+k2;
	for(int i=0;i<count;++i) {
	    i1=(i+0+ count)%count;
	    i2=(i+k2+count)%count;
	    i3=(i+k1+count)%count;
	    i4=(i+k3+count)%count;
	    //ordering is deliberate
	    X.V[i]=V[i].findCross(V[i1],V[i3],V[i2],V[i4]);
	}
	int h=(k1+k2)/2;
	X=X.cycleVertices(-h);
	X=X.normalize();
	return(X);
    }


    public PolyVector dualMap(int k) {

	PolyVector P=this.jiggle(.01);
	PolyVector X=new PolyVector();
	X.count=this.count;
	int i1,i2;
	for(int i=0;i<count;++i) {
	    i1=(i+0+count)%count;
	    i2=(i+k+count)%count;
	    X.V[i]=Vector.cross(P.V[i1],P.V[i2]);
	}
	X=X.normalize();
	PolyVector Y=new PolyVector(X);
	for(int i=0;i<X.count;++i) {
	    int j=(-k-i+100*X.count)%X.count;
	    Y.V[j]=new Vector(X.V[i]);
	}
	return(Y);
    }




    

    /**Special kinds of polygons*/

    public PolyVector displace(int k,double t) {
	PolyVector Q=new PolyVector(this);
	Q.V[0].x[0]=(1-t)*Q.V[0].x[0]+t*Q.V[k].x[0];
	Q.V[0].x[1]=(1-t)*Q.V[0].x[1]+t*Q.V[k].x[1];
	return Q;
    }
    
    public static PolyVector regular(int n) {
	PolyVector X=new PolyVector();
	X.count=n;
	
	for(int i=0;i<n;++i) {
	    double t=2*Math.PI*i/n;
	    double c=Math.cos(t);
	    double s=Math.sin(t);
	    X.V[i]=new Vector(c,s);
	}
	return(X);
    }

    public static PolyVector initial(int k,int n) {
	PolyVector X=new PolyVector();
	X.count=n;
	int h=n/2;

	
	for(int i=-h;i<h;++i) {
	    Complex w=new Complex(i,8.0*i*i/n);
	    X.V[i+h]=new Vector(w.x,w.y);
	}
	X=X.cycleVertices(h);
  	X=X.align(k);
	return(X);
    }


    public PolyVector perturb(double t) {
	PolyVector X=new PolyVector(this);
	for(int i=0;i<X.count;++i) {
	    X.V[i].x[0]=X.V[i].x[0]+t*Math.random();
	    X.V[i].x[1]=X.V[i].x[1]+t*Math.random();
	}
	return X;
    }

    public PolyVector align(int k) {
	PolyVector X=new PolyVector(this);
	for(int i=0;i<X.count;++i) {
	    X.V[i]=Vector.minus(V[i],V[0]);
	    X.V[i].x[2]=1;
	}
	
     	Complex z=new Complex(X.V[k].x[0]-X.V[0].x[0],X.V[k].x[1]-X.V[0].x[1]);
	z=z.inverse();
	for(int i=0;i<X.count;++i) {
	    X.V[i]=X.V[i].rotate(z);
	}
	return X;
    }
	
    
    

    public PolyVector jiggle(double t) {
	Matrix m=Matrix.random(t);
	PolyVector X=new PolyVector();
	X.count=this.count;
	for(int i=0;i<count;++i) {
	    X.V[i]=Matrix.act(m,this.V[i]);
	    X.V[i]=X.V[i].normalize();

	}
	return(X);
    }

    

    /**printout*/
    
    public void print() {
	for(int i=0;i<count;++i) V[i].print();
    }

    public void print2() {
	System.out.print("POLY={");
	for(int i=0;i<count-1;++i) V[i].print2(true);
        V[count-1].print2(false);
    }





}

