import java.awt.*;
import java.awt.event.*;

//This class combines a panel with a frame.  made by Pat Hooper, Oct, 2005

public class PopupPanel extends Panel implements ComponentListener, WindowListener {
    public Frame F;

    public PopupPanel(String windowName, int Width, int Height) {
        F=new Frame(windowName);
        F.add(this);
        F.pack();
        F.addComponentListener(this);
        F.addWindowListener(this);
        F.setSize(Width,Height);
    }

    public void resized(int width, int height){}
    
    public void setVisible(boolean b) {
        super.setVisible(b);
        F.setVisible(b);
    }
    
/*Component listener*/

    public void componentResized(ComponentEvent e) {
        resized(F.getWidth() - (F.getInsets().left + F.getInsets().right),
        F.getHeight() - (F.getInsets().top + F.getInsets().bottom));
        getLayout().layoutContainer(this);
    }
    
    /* Resize the Window */
    public void componentShown(ComponentEvent e) {
        F.setSize(F.getWidth() + (F.getInsets().left + F.getInsets().right),
        F.getHeight() + (F.getInsets().top + F.getInsets().bottom));
    }

    public void componentHidden(ComponentEvent e) {}
    public void componentMoved(ComponentEvent e) {}
   public void windowClosing(java.awt.event.WindowEvent windowEvent) {
        F.dispose();
    }

    public void windowActivated(java.awt.event.WindowEvent windowEvent) {}
    public void windowClosed(java.awt.event.WindowEvent windowEvent) {}
    public void windowDeactivated(java.awt.event.WindowEvent windowEvent) {}
    public void windowDeiconified(java.awt.event.WindowEvent windowEvent) {}
    public void windowIconified(java.awt.event.WindowEvent windowEvent) {}
    public void windowOpened(java.awt.event.WindowEvent windowEvent) {}
}
