import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;



public class Spectrum {
    

    public static int[] diagonal(int k,int q) {
	int[][] u={{-k,-k-1},  //0
		   {-k,k+1},   //1
		   {-k,k},
		   {-k-1,k+1},
		   {-k-1,k},
		   {k+1,k},
		   {-k,0},
		   {-k,1},      //7
		   {-k,-2*k-1}, //8
		   {-k,-2*k},
		   {-k-1,0},
		   {-k-1,-1},    //11
		   {-k-1,-2*k-1},//12
		   {-k-1,-2*k-2},
                   {+k,0},
		   {+k,-1},
		   {+k,+2*k+1},
		   {+k,+2*k},
		   {+k+1,0},
		   {+k+1,+1},     //19
		   {+k+1,+2*k+1}, //20
  		   {+k+1,+2*k+2}};
	return u[q];
    }

    public static String[] diagonalName(int k,int q) {
	String[][] u={{"-k","-k-1"},  //0
		   {"-k","k+1"},   //1
		   {"-k","k"},
		   {"-k-1","k+1"},
		   {"-k-1","k"},
		   {"k+1","k"},
		   {"-k","0"},
		   {"-k","1"},      //7
		   {"-k","-2*k-1"}, //8
		   {"-k","-2*k"},
		   {"-k-1","0"},
		   {"-k-1","-1"},    //11
		   {"-k-1","-2*k-1"},//12
		   {"-k-1","-2*k-2"},
                   {"+k","0"},
		   {"+k","-1"},
		   {"+k","+2*k+1"},
		   {"+k","+2*k"},
		   {"+k+1","0"},
		   {"+k+1","+1"},     //19
		   {"+k+1","+2*k+1"}, //20
  		   {"+k+1,+2*k+2"}};
	return u[q];
    }


    

    public static int[] diagonal0(int k,int q) {
	int[] A={0,1,7,8,11,12,19,20};
	return diagonal(k,A[q]);
    }
	
    public static int[] diagonal1(int k,int q) {
	int[] A={0,4,11,12,7,8,15,16};
	return diagonal(k,A[q]);
    }
	

    public static String[] diagonalName0(int k,int q) {
	int[] A={0,1,7,8,11,12,19,20};
	return diagonalName(k,A[q]);
    }
	
    public static String[] diagonalName1(int k,int q) {
	int[] A={0,4,11,12,7,8,15,16};
	return diagonalName(k,A[q]);
    }
	

       
    public static Vector getCrossing(PolyVector P,int k,int k2,int q) {
	int n=P.count;
	int[] u=diagonal(k,q);
	int i=(u[0]+n)%n;
	int j=(u[1]+n)%n;
	Vector V=Vector.findCross(P.V[i],P.V[j],P.V[0],P.V[k2]);
	V=V.normalize();
	return V;
    }


       
    public static Vector getCrossing0(PolyVector P,int k,int q) {
	int n=P.count;
	int[] u=diagonal0(k,q);
	int i=(u[0]+n)%n;
	int j=(u[1]+n)%n;
	Vector V=Vector.findCross(P.V[i],P.V[j],P.V[0],P.V[k]);
	V=V.normalize();
	return V;
    }

       
    public static Vector getCrossing1(PolyVector P,int k,int q) {
	int n=P.count;
	int[] u=diagonal1(k,q);
	int i=(u[0]+n)%n;
	int j=(u[1]+n)%n;
	Vector V=Vector.findCross(P.V[i],P.V[j],P.V[0],P.V[k+1]);
	V=V.normalize();
	return V;
    }




    

    public static int match(PolyVector P,int k,int k2,Vector V) {
	double min=1000;
	int index=0;
	for(int q=0;q<20;++q) {
    	    Vector W=getCrossing(P,k,k2,q);
	    double test=Vector.dist(V,W);
	    if(min>test) {
		min=test;
		index=q;
	    }
	}
	System.out.println("min "+min);
	return index;
    }


    public static double testValue1(int map,PolyVector P,int k,int function,int loc,double tol) {
	Vector V=getCrossing0(P,k,loc);
	PolyVector Q=new PolyVector(P);
	Q.V[0]=new Vector(V);
	Q=Q.displace(k,tol);
	PolyVector Q2=new PolyVector(Q);
	if(map==1) Q2=Q.dualMap(k);
	double d=BirdInvariants.locinv(k,Q2,function);
        return d;
    }

    public static double testValue2(int map,PolyVector P,int k,int function,int loc,double tol) {
	Vector V=getCrossing1(P,k,loc);
	PolyVector Q=new PolyVector(P);
	Q.V[0]=new Vector(V);
	Q=Q.displace(k+1,tol);
	PolyVector Q2=new PolyVector(Q);
	if(map==1) Q2=Q.dualMap(k+1);
	double d=BirdInvariants.locinv(k,Q2,function);
        return d;
    }


}
