import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Animator implements Runnable {
    Manager M;
    boolean halt;

    public Animator() {
	halt=true;
    }
    
    public Animator(Manager MM) {
	this.M=MM;
	halt=true;
    }


    public void run() {
	halt=false;
	int sides=M.C.SIDES.val;
	PolyVector P0=new PolyVector();
	PolyVector P1=new PolyVector();
	PolyVector P2=new PolyVector();

	  double step=Math.pow(.5,M.C.STEP.val);
	  int range=M.C.RANGE.val;
	  int k=M.C.SKIP.val;
	  int choice=0;
	  double[] mem=new double[4];
	  int count=0;
	  double t=-range;
	  int map=M.C.MAP.mode;

	  System.out.println("------------------------------");
	  System.out.println("sides "+sides);
	  System.out.println("energy "+k);
	  System.out.println("map choice "+map);
	  System.out.println("");

	while(halt==false) {
	    range=M.C.RANGE.val;
	    step=Math.pow(.5,M.C.STEP.val);
	    k=M.C.SKIP.val;
	    
	    t=t+step;
	   	    
	    if(t>range) {
		t=-range;
		choice=(choice+1)%sides;
		++count;
                M.C.CHOICE.val=choice;
		M.repaint();
		mem=clearMemory();
	    }

	    int sw=isSwitch(mem);
	    boolean test=isConstant(mem);
	    if(test==true) t=range+step;

	    boolean test2=isTame(mem);
	    if(test2==false) {
		System.out.println("not tame "+choice);
		printMoebius(mem);
	    }
	    
	    

	    if(sw!=0) {
	      	send(sw,choice,sides,k,map,P1);
		mem=clearMemory();
	    }

	    P0=new PolyVector(M.C.P);
	    P1=P0.displace(t);

	    if(map==0) P2=new PolyVector(P1);
	    if(map==1) P2=P1.dualMap(k);
	    if(map==2) P2=P1.dualMap(k+1);
	    
	    double d=BirdInvariants.locinv(k,P2,choice);
            mem=updateMemory(mem,d);
	    
	    if(count>=sides) halt=true;
	    
	    M.repaint();
	}
	halt=true;
	M.repaint();
    }

    public void send(int sw,int choice,int n,int k,int map,PolyVector P) {
         M.C.plot[M.C.COUNT][0]=new Complex(P.V[0]);
	 M.C.plot[M.C.COUNT][1]=new Complex();
       	 M.C.plot[M.C.COUNT][1].x=weave(choice,n);
	 if(sw==-1) M.C.plot[M.C.COUNT][1].y=0;
	 else M.C.plot[M.C.COUNT][1].y=1;
	 M.C.plot[M.C.COUNT][2]=new Complex(map,0);
	 ++M.C.COUNT;
    }

    

    public void printMemory(double[] m) {
	System.out.println("***********");
	for(int i=0;i<4;++i) System.out.println(m[i]);
	System.out.println("***********");
    }


    public static boolean isTame(double[] m) {
	if(hasZero(m)==true) return true;
	boolean test=isConstant(m);
	if(test==true) return true;
	return isMoebius(m);
    }
    
    public static boolean isConstant(double[] m) {
	if(Math.abs(m[0])<.0000001) return false;
	for(int i=1;i<4;++i) {
	    if(Math.abs(m[i]-m[0])>.00000001) return false;
	}
	return true;
    }

    public static boolean isMoebius(double[] m) {
	double x1=(m[0]-m[1])*(m[2]-m[3]);
	double x2=(m[0]-m[2])*(m[1]-m[3]);
	double y=x1/x2;
	if(Math.abs(y-.25)>.001) return false;
	return true;
    }

    public static void printMoebius(double[] m) {
	double x1=(m[0]-m[1])*(m[2]-m[3]);
	double x2=(m[0]-m[2])*(m[1]-m[3]);
	double y=x1/x2;
	System.out.println("moeb "+y);
    }




    
    public static boolean hasZero(double[] m) {
	double x=m[0]*m[1]*m[2]*m[3];
	if(Math.abs(x)<.000000001) return true;
	return false;
    }
    
    

    public static int isSwitch(double[] m) {
	double min=1;
	double max=-1;
	for(int i=0;i<4;++i) {
	    if(min>m[i]) min=m[i];
	    if(max<m[i]) max=m[i];
	}
	if((min<0)&&(max>0)) {
	    if(max>1) return -1;
	    if(max<1) return +1;
	}
	return 0;
    }


    

    public static double[] updateMemory(double[] m,double d) {
	double[] m2=new double[4];
	m2[0]=d;
	for(int i=1;i<4;++i) m2[i]=m[i-1];
	return m2;
    }
    

    public static double[] clearMemory() {
	double[] m2=new double[4];
	for(int i=1;i<4;++i) m2[i]=0;
	return m2;
    }

    public static int format(int c,int n) {
	if(c<n/2) return c;
	return c-n;
    }
    
    public static int weave(int c,int n) {
	int cc=c;
	if(c>n/2) cc=c-n;
     	if(c==0) return 1;
	if(cc>0) return 2*cc+1;
	if(cc<0) return -2*cc;
	return 0;
    }
    
}

 
