import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Manager M;
    ControlPanel MAP,ACTION;
    ListenSquare GO,STOP,CONTROL,TEST,RESET,PERTURB;
    SelectInteger SIDES,SKIP,CHOICE,RANGE,STEP,PERTURB_SIZE,SPACING;
    Complex[][] plot=new Complex[100][3];
    int COUNT=0;
    Animator AN;
    PolyVector P;


     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 GO=new ListenSquare(0,150,40,20);
	 STOP=new ListenSquare(45,150,40,20);
	 TEST=new ListenSquare(0,980,40,20);
	 PERTURB=new ListenSquare(45,125,55,20);
	 RESET=new ListenSquare(0,125,40,20);
	 CONTROL=new ListenSquare(0,0,120,1008);


	 
	 SIDES=new SelectInteger(0,310,40,20,60,8,150,4);
	 SKIP=new SelectInteger(0,360,40,20,2,2,15,1);
	 CHOICE=new SelectInteger(0,410,40,20,0,0,11,1);
	 RANGE=new SelectInteger(0,460,40,20,8,4,100,4);
	 STEP=new SelectInteger(0,510,40,20,10,5,25,1);
	 PERTURB_SIZE=new SelectInteger(0,560,40,20,0,0,15,1);
	 SPACING=new SelectInteger(0,610,40,20,5,1,15,1);

	 AN=new Animator();
	 setScales(500,500,100);
	 P=PolyVector.regular(SIDES.val);
	 setPanels();
     }


    public void setPanels() {
        Color[] C0={new Color(200,0,200),Color.white,Color.white,Color.black,new Color(180,180,180)};
	
	String[] Map={"none","k","k+1","map"};
	 int[] MapState={1,0,0};
         MAP=new ControlPanel(C0,Map,MapState,3);
	 
	 String[] Action={"all","single","action"};
	 int[] ActionState={1,0};
         ACTION=new ControlPanel(C0,Action,ActionState,2);
    }

    

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.blue);
      g.fillRect(0,0,getWidth(),getHeight());
      drawBG(g);
      drawGuess(g);
      drawPlot(g);
      drawPoly(g);
      drawControls(g);
   }

    
    public void drawPlot(Graphics2D g) {
	Path2D.Double p1=new Path2D.Double();
	Path2D.Double p2=new Path2D.Double();
	Color[] C={new Color(0,0,0),new Color(140,140,140)};
	double r=Math.pow(.5,PERTURB_SIZE.val);

	
	for(int i=0;i<COUNT;++i) {
	    p1.reset();
	    p2.reset();
	    int m=(int)(plot[i][1].x);
	    int q=(int)(plot[i][1].y);
	    p2.moveTo(plot[i][0].x,plot[i][0].y);
	    p2.lineTo(plot[i][0].x,plot[i][0].y-100);
	    p2=transform(p2);
	    g.setColor(new Color(200,200,200));
	    g.draw(p2);
	}

	double sp=Math.pow(.9,SPACING.val);
	
	for(int i=0;i<COUNT;++i) {
	    p1.reset();
	    p2.reset();
	    int m=(int)(plot[i][1].x);
	    int q=(int)(plot[i][1].y);
	    p1.moveTo(plot[i][0].x,plot[i][0].y-sp*m);
	    p1.lineTo(plot[i][0].x,plot[i][0].y-sp*m-sp);
	    p1=transform(p1);
	    g.setStroke(new BasicStroke(3));
	    g.setColor(C[q]);
	    g.draw(p1);
	    g.setStroke(new BasicStroke(1));
	}



	
    }
    
    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
        g.fillRect(0,0,getWidth(),getHeight());
    }


    public void drawControls(Graphics2D g) {
	CONTROL.render(g,Color.blue);
	MAP.render(g,0,0,80);
	ACTION.render(g,0,70,80);
	
	if(AN.halt==true) GO.render(g,"go",12,4,new Color(0,130,0));
	if(AN.halt==false) STOP.render(g,"stop",12,4,new Color(130,0,0));
	TEST.render(g,"test",12,4,new Color(130,0,130));
	RESET.render(g,"reset",12,4,new Color(130,0,130));
	PERTURB.render(g,"perturb",12,4,new Color(130,0,130));

	Color C=new Color(0,160,0);
	SIDES.render(g,C,Color.white,Color.white);
	SKIP.render(g,C,Color.white,Color.white);
	CHOICE.render(g,C,Color.white,Color.white);
	RANGE.render(g,C,Color.white,Color.white);
	STEP.render(g,C,Color.white,Color.white);
	PERTURB_SIZE.render(g,C,Color.white,Color.white);
	SPACING.render(g,C,Color.white,Color.white);

	int[] y={SIDES.y,SKIP.y,CHOICE.y,RANGE.y,STEP.y,PERTURB_SIZE.y,SPACING.y};
	String[] S={"sides","energy choice","vertex choice","range","step","perturb size","spacing"};
	g.setColor(Color.white);
	for(int i=0;i<7;++i) g.drawString(S[i],5,y[i]-5);
   }

    /**Here are extra lines which might also appear

	// drawLine(g,-k,-k-1,2);
       	//	drawLine(g,-k,+k,2);
        //   drawLine(g,-k-1,+k+1,2);
	   //  drawLine(g,-k,+1,2);
          
	   //    drawLine(g,-k-1,-2*k-2,2);
	     //  	drawLine(g,-2*k,-k-0,1);
	//      	drawLine(g,-k-1,-2*k-2,1);
	//    drawLine(g,k+1,2*k+2,2);
	     //	drawLine(g,2*k,k,2);

      end: extra lines    **/

    
    public void drawGuess(Graphics2D g) {
	int k=SKIP.val;
	int[][] u={{-k-1,k,0},{-2*k-1,-k,0},{-2*k-1,-k-1,0},{2*k+1,k,0},{2*k+1,k+1,0},{-k,k+1,0},{k+1,k,1},{-k-1,-1,1},{k+1,1,1},{-k,-k-1,1},{-1,k,1}};
	for(int i=0;i<u.length;++i) drawLine(g,u[i][0],u[i][1],u[i][2]);

	
    }

    public double[] evaluatePerturbation(PolyVector P) {

	for(int i=2;i<P.count;++i) {
	    if(P.V[i].x[1]<.5) {
		double[] m={100000,0};
		return m;
	    }
	}
	
       int k=SKIP.val;
       int[][] u={{-k-1,k,0},{-2*k-1,-k,0},{-2*k-1,-k-1,0},{2*k+1,k,0},{2*k+1,k+1,0},{-k,k+1,0},{k+1,k,1},{-k-1,-1,1},{k+1,1,1},{-k,-k-1,1},{-1,k,1}};
	double[] d=new double[u.length];
	
	for(int i=0;i<d.length;++i) {
	    Vector V=getCrossing(u[i][0],u[i][1]);
	    d[i]=V.x[0];
	}

	double max=0;
	double min=1000;
	for(int i=0;i<d.length;++i) {
	    if(max<Math.abs(d[i])) max=Math.abs(d[i]);
	}

	for(int i=0;i<d.length;++i) {
	    for(int j=i+1;j<d.length;++j) {
		double dist=Math.abs(d[i]-d[j]);
		if(min>dist) {
		    min=dist;
		}
	    }
	}
	double[] m={max,min};
	return m;
	
    }
    
    public void perturb() {
	P=PolyVector.regular(SIDES.val);
	boolean test=false;
	int count=0;
	double[]t={0,0};

	double per=Math.pow(.5,PERTURB_SIZE.val);
	while(test==false) {
	    ++count;
	    P=PolyVector.regular(SIDES.val);
            P=P.perturb(per*Math.random());
	    P=P.align();
	    t=evaluatePerturbation(P);
	    if((t[0]<RANGE.val-1)&&(t[1]>.1)) test=true;
	    if(count>100000) test=true;
	}
	System.out.println("quality "+t[0]+" "+t[1]);
    }
    


    public void drawLine(Graphics2D g,int i0,int j0,int k) {
	Color[] C={new Color(0,0,0,100),new Color(140,140,140,140),new Color(200,200,200,200)};
	int n=SIDES.val;
	int i=(i0+n)%n;
	int j=(j0+n)%n;
	Vector V=getCrossing(i0,j0);
	Path2D.Double p=new Path2D.Double();
	p.moveTo(P.V[i].x[0],P.V[i].x[1]);
	p.lineTo(V.x[0],V.x[1]);

	p.moveTo(P.V[j].x[0],P.V[j].x[1]);
	p.lineTo(V.x[0],V.x[1]);

	
	p=transform(p);
	g.setColor(C[k]);
	g.draw(p);
    }

    
    public Vector getCrossing(int i0,int j0) {
	int n=SIDES.val;
	int i=(i0+n)%n;
	int j=(j0+n)%n;
	Vector V=Vector.findCross(P.V[i],P.V[j],P.V[0],P.V[1]);
	V=V.normalize();
	return V;
    }
    

    public void drawPoly(Graphics2D g) {

	Path2D.Double p=new Path2D.Double();
	double sp=Math.pow(.9,SPACING.val);
	for(int i=0;i<P.count;++i) {
	double x0=P.V[0].x[0];
	double y0=P.V[0].x[1];
	double x1=P.V[1].x[0];
	double y1=P.V[1].x[1];
	double x2=100*x0-99*x1;
	double y2=100*y0-99*y1;
	double x3=100*x1-99*x0;
	double y3=100*y1-99*y0;
	p.reset();
	p.moveTo(x2,y2-sp*i);
	p.lineTo(x3,y3-sp*i);
	p=transform(p);
	g.setColor(new Color(150,150,150));
	g.draw(p);
	}

	
	p=P.toPath();
	p=transform(p);
	g.setColor(new Color(220,220,220,50));
	g.setStroke(new BasicStroke(4));
	g.draw(p);
	g.setStroke(new BasicStroke(1));

	
	for(int i=0;i<P.count;++i) {
	    Complex z=new Complex(P.V[i]);
	    fillPoint(g,z,.1,new Color(0,0,0),32);
	}
    }

    public void drawRange(Graphics2D g) {
        
	Path2D.Double p=new Path2D.Double();
        double x=RANGE.val;
	p.moveTo(-x,-2);
	p.lineTo(-x,+2);
	p.lineTo(+x,+2);
	p.lineTo(+x,-2);
	p.closePath();
	p=transform(p);
	g.setColor(Color.black);
	g.fill(p);
	g.setColor(Color.blue);
	g.draw(p);
    }



    public void doControls(Point X) {
	doGo(X);
	doStop(X);
	SIDES.modify(X);
	PERTURB_SIZE.modify(X);
	SKIP.modify(X);
	RANGE.modify(X);
	SPACING.modify(X);
	STEP.modify(X);
	MAP.switchMode(X);
	ACTION.switchMode(X);
	CHOICE.modifyCyclic(X);
	if(RESET.inside(X)==1) P=PolyVector.regular(SIDES.val);
	if(PERTURB.inside(X)==1) perturb();

	
	if(SIDES.isModified(X)==1) {
	    P=PolyVector.regular(SIDES.val);
	    CHOICE.max=SIDES.val-1;
	    CHOICE.val=0;
	}
	if(TEST.inside(X)==1) doTest();
	M.repaint();
    }
    

    public void doGo(Point X) {
	if(AN.halt==false) return;
	if(GO.inside(X)==1) {
	    clearAll();
	    AN=new Animator(this.M);
	    new Thread(AN).start();
	}
    }

    public void doStop(Point X) {
	if(STOP.inside(X)==1) AN.halt=true;
    }
    

    public void clearAll() {
	for(int i=0;i<100;++i) {
	    for(int j=0;j<3;++j) {
		plot[i][j]=new Complex(0,0);
	    }
	}
	COUNT=0;
    }

    
    

    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) {
	    doControls(J.X);
	    repaint();
	    return;
	}
	
	if(J.mode==1) {
	   scaleUp(J.X,-1);
	}

	if(J.mode==3) {
	   scaleUp(J.X,+1);
	}

	if(J.mode==2) {
	   SOURCE=unTransform(J.X);
	}


	
	M.repaint();
    }
    
	
    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) return;
	else {
	    if(J.mode==2) {
	      SOURCE=unTransform(J.X);
	    }
	}
	M.repaint();
     }











    


    public void doTest() {
	for(int i=0;i<16;++i) System.out.println(Animator.weave(i,16));
    }


    public void doTestX() {
	System.out.println("-----------------------");
	int n=SIDES.val;
	int k=SKIP.val;
	double t=Math.exp(2);
	PolyVector Q1=PolyVector.regular(n);
   	Q1=Q1.displace(t);
	PolyVector Q2=Q1.dualMap(k+1);

	double d1=BirdInvariants.energy(k,Q1);
	double d2=BirdInvariants.energy(k,Q2);
	double[] dd1=BirdInvariants.invariant(k,Q1);
	double[] dd2=BirdInvariants.invariant(k,Q2);

	System.out.println(d1+" "+d2);
	System.out.println("---");
	for(int i=0;i<n;++i) System.out.println(dd1[i]+"     "+dd2[i]);


    }



    

    public static int getOrder(double x) {
	double y=Math.log(Math.abs(x));
	int n=(int)(y);
	return n;
    }

}

