import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class InvariantCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    String[][] S=new String[5][100];
    ListenSquare RESET;
    Complex[][] PLOT=new Complex[20][1000000];
    int[] COUNT=new int[20];

    
     public InvariantCanvas() { 
	 addMouseListener(this);
	 M=new Manager();
	 setScales(750,250,20);
	 RESET=new ListenSquare(5,5,40,20);
	 for(int i=0;i<20;++i) COUNT[i]=0;
     }
    
    public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawInvariants(g);
      drawControls(g);
   }


    public void drawBG(Graphics2D g) {
	g.setColor(new Color(10,20,30));
      g.fillRect(0,0,getWidth(),getHeight());
    }

    
    public void drawControls(Graphics2D g) {
	RESET.render(g,"reset",12,2,new Color(50,0,50));
    }

    

    public double intPart(double x) {
	return(Math.floor(x+.5));
    }


    public String cleanDouble(double t) {
	Double T=new Double(t);
        String v1=T.toString();
	if(Math.abs(t)<.0000000001) v1="0";
	try {
	    if(t>.001) v1=v1.substring(0,12);
	}
	catch(Exception e) {} 
	return(v1);
    }


    public void drawInvariants(Graphics2D g) {
	int n=M.C.SIDES.val;
	for(int i=0;i<n;++i) {
	for(int j=0;j<COUNT[i];++j) {
	    fillPoint(g,PLOT[i][j],.005,Color.white,16);
	}
	}
    }


    public void drawInvariantsX(Graphics2D g) {
	int k=M.C.SKIP.val;
	double[] d=BirdInvariants.invariant(k,M.C.P);
	for(int i=0;i<d.length;++i) {
	    if(Math.abs(d[i])<.01) System.out.println(i+" "+d[i]);
	    if(Math.abs(d[i])>100) System.out.println(i+" "+d[i]);
	}
    }

    

    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
    }



    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   

     public void mouseDragged(MouseEvent e) {
     } 

}

