import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class tests various kinds of convexity*/

public class BirdConvex {

    /**choice should be 0 or 1*/
    
    public static int[] sides(int choice,int k,PolyVector P) {
	Vector V0=P.V[0];
	int[] list1=new int[P.count];
	int count=0;
	for(int i=0;i<P.count;++i) {
	    int j=(i+k+2)%P.count;
	    Vector V1=P.V[i];
	    Vector V2=P.V[j];
	    int test=Complex.isPositivelyOriented(V0,V1,V2);
	    if(test==choice) {
		list1[count]=i;
	        ++count;
	    }
	}
	int[] list2=new int[count];
	for(int i=0;i<count;++i) list2[i]=list1[i];
	return list2;
    }
    

    public static boolean weakTest(int a,int b,int c,PolyVector P) {
   	boolean t=weakTest0(a,b,c,P);
        if(t==false) return false;
	int bb=a+c-b;
	t=weakTest0(a,bb,c,P);
	return t;
    }

    public static boolean weakTest0(int a,int b,int c,PolyVector P) {
	int n=P.count;
	for(int i=0;i<n;++i) {
	    int j=(i+a)%n;
	    int k=(i+b)%n;
	    int l=(i+c)%n;
	    Vector[] x={P.V[j],P.V[k],P.V[l]};
	    Matrix m=new Matrix(x);
	    double d=m.det();
	    if(d<0) return false;
	}
	return(true);
    }
    

    /**This looks for a k-star point. This is a point on the correct side
       of the k+2 diagonals*/

    public static boolean starTest(PolyVector P,int k,Complex z) {
	Vector V=new Vector(z.x,z.y,1);
	int n=P.count;
	for(int i=0;i<n;++i) {
	    int j=(i+k+2)%n;
	    int test=Complex.isPositivelyOriented(V,P.V[i],P.V[j]);
	    if(test==0) return false;
	}
	return true;
    }


}


