import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class BirdGraphics {



    public static Path2D.Double diamondPath(int k,PolyVector X) {
	Path2D.Double gp=new Path2D.Double();
	PolyVector P=X.normalize();
	PolyVector Q=P.pentagram(k,k-1);
	PolyVector R=P.pentagram(k-1,k);
	int i1,i2;
	for(int i=0;i<P.count;++i) {
	    i1=i;
	    i2=(i+1)%X.count;
            double x1=P.V[i1].x[0];
	    double y1=P.V[i1].x[1];
	    double x2=P.V[i2].x[0];
	    double y2=P.V[i2].x[1];
            double x3=Q.V[i1].x[0];
	    double y3=Q.V[i1].x[1];
	    double x4=R.V[i1].x[0];
	    double y4=R.V[i1].x[1];
            gp.moveTo(x1,y1);
	    gp.lineTo(x3,y3);
	    gp.lineTo(x2,y2);
	    gp.lineTo(x4,y4);
	    gp.closePath();
	}
	return gp;
    }


    public static Path2D.Double triPath1(int k,int i,PolyVector X) {
	Path2D.Double gp=new Path2D.Double();
	PolyVector P=X.normalize();
	PolyVector Q=P.pentagram(k,k-1);
	int i1,i2;
	i1=i;
	i2=(i+1)%X.count;
        double x1=P.V[i1].x[0];
	double y1=P.V[i1].x[1];
	double x2=P.V[i2].x[0];
	double y2=P.V[i2].x[1];
        double x3=Q.V[i1].x[0];
	double y3=Q.V[i1].x[1];
        gp.moveTo(x1,y1);
	gp.lineTo(x3,y3);
	gp.lineTo(x2,y2);
	gp.closePath();
	return gp;
    }

    public static Path2D.Double triPath2(int k,int i,PolyVector X) {
	Path2D.Double gp=new Path2D.Double();
	PolyVector P=X.normalize();
	PolyVector R=P.pentagram(k-1,k);
	int i1,i2;
	i1=i;
	i2=(i+1)%X.count;
        double x1=P.V[i1].x[0];
	double y1=P.V[i1].x[1];
	double x2=P.V[i2].x[0];
	double y2=P.V[i2].x[1];
	double x4=R.V[i1].x[0];
	double y4=R.V[i1].x[1];

	double x5=100*x1-99*x4;
	double y5=100*y1-99*y4;
	double x6=100*x2-99*x4;
	double y6=100*y2-99*y4;

        int t=Complex.isPositivelyOriented(P.V[i1],P.V[i2],R.V[i1]);
	
	if(t==0) {
          gp.moveTo(x1,y1);
	  gp.lineTo(x2,y2);
	  gp.lineTo(x4,y4);
	  gp.closePath();
	}
	
	if(t==1) {
          gp.moveTo(x1,y1);
	  gp.lineTo(x2,y2);
	  gp.lineTo(x6,y6);
	  gp.lineTo(x5,y5);
	  gp.closePath();
	}

	
	  return gp;
    }


    public static Path2D.Double quadPath(int k,int i,PolyVector X) {
	Path2D.Double gp=new Path2D.Double();
	PolyVector P=X.normalize();
	PolyVector Q=P.pentagram(k,k-1);
	PolyVector R=P.pentagram(k-1,k);
	int i1,i2;
	i1=i;
	i2=(i+1)%X.count;
        double x1=P.V[i1].x[0];
	double y1=P.V[i1].x[1];
	double x2=P.V[i2].x[0];
	double y2=P.V[i2].x[1];
        double x3=Q.V[i1].x[0];
	double y3=Q.V[i1].x[1];
	double x4=R.V[i1].x[0];
	double y4=R.V[i1].x[1];
        gp.moveTo(x1,y1);
        gp.lineTo(x3,y3);
	gp.lineTo(x2,y2);
	gp.lineTo(x4,y4);
	gp.closePath();
	return gp;
    }

}




            
