import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class BirdInvariants {
    double x,y;
    
    public BirdInvariants() {}

    //vectors should be normalized to have 3rd coordinate equal to 1.

    public static double slope(Vector V1,Vector V2) {
        double s;
        s=(V2.x[1]-V1.x[1])/(V2.x[0]-V1.x[0]);
        return(s);
    }


    //inverse of usual cross ratio
    public static double cross0(double a,double b,double c,double d)
      {
      double x;
      x=(a-b)*(c-d)/((a-c)*(b-d));
      return(x);
      }


    public static double fan(Vector x,Vector a,Vector b,Vector c,Vector d) {
        double f=cross0(slope(x,a),slope(x,b),slope(x,c),slope(x,d));
        return(f);
    }



    // the local invariant
    public static double locinv(int k,PolyVector P,int j,int ii) {
        int i;
	int[] a={0,-k-1,-k,k,k+1};
	int n=P.count;
	PolyVector Q=P.rotate(Math.sqrt(2.0));   //a random rotation to avoid degeneracies

	
	int j1=(j+a[0]*ii+2*n)%n;
	int j2=(j+a[1]*ii+2*n)%n;
	int j3=(j+a[2]*ii+2*n)%n;
	int j4=(j+a[3]*ii+2*n)%n;
	int j5=(j+a[4]*ii+2*n)%n;

	
	double ll=fan(Q.V[j1],Q.V[j2],Q.V[j3],Q.V[j4],Q.V[j5]);
        return(ll);
    }


    // the global invariants

    public static double[] invariant(int k,PolyVector P) {
	double[] x=new double[P.count];

        for(int i=0;i<P.count;++i) {
	    x[i]=locinv(k,P,i,-1);
	}
	return(x);
    }

    public static double energy(int k,PolyVector P) {
	double[] y=invariant(k,P);
	double t=1;
	for(int i=0;i<y.length;++i) t=t*y[i];
	return(t);
    }

    public static boolean localEnergyTest(int k,PolyVector P) {
	double[] y=invariant(k,P);
	for(int i=0;i<y.length;++i) {
	    if(y[i]<0) return false;
	}
	return true;
    }





    
    public static Matrix transformGlick(PolyVector P,int[][] step) {
	Matrix M=Matrix.zero();
	for(int i=0;i<step.length;++i) {
	    Matrix T=transformGlick(P,step[i][0],step[i][1],step[i][2]);
	    M=Matrix.plus(M,T);
	}
	return M;
    }

    public static Matrix transformGlick(PolyVector P,int coeff,int step1,int step2) {
	Vector F1=transformGlick(step1,step2,P,0);
	Vector F2=transformGlick(step1,step2,P,1);
	Vector F3=transformGlick(step1,step2,P,2);
	F1=F1.scale(coeff);
	F2=F2.scale(coeff);
	F3=F3.scale(coeff);
	Matrix m=new Matrix(F1,F2,F3);
	return m.transpose();
    }


    public static Vector transformGlick(int step1,int step2,PolyVector P,int q) {
	Vector e1=new Vector(1,0,0);
	Vector e2=new Vector(0,1,0);
	Vector e3=new Vector(0,0,1);
	Vector[] ee={e1,e2,e3};
	Vector e=ee[q];
	Vector W=new Vector(0,0,0);
	int n=P.count;
	
	for(int j=0;j<n;++j) {
	    int i=(n+j-step1)%n;
	    int k=(n+j+step2)%n;
	    
	    Matrix M1=new Matrix(P.V[i],e,P.V[k]);
	    Matrix M2=new Matrix(P.V[i],P.V[j],P.V[k]);
	    double d1=M1.det();
	    double d2=M2.det();
	    double d=d1/d2;
	    W=Vector.plus(W,P.V[j].scale(d));
	}
	return W;
    }


    



    



    
}


