import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Manager M;
    ListenSquare GO,STOP,OPERATE;
    ListenSquare[] INFO=new ListenSquare[10];
    ControlPanel GLOBAL,CHOICE,MOUSE;
    SelectColor SC;
    PopupManager PM;
    Documentation DOC;
    IterationControl ItC;


     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setPanels();
	 DOC=new Documentation();	 
	 ItC=new IterationControl(120,5,M);
	 SC=new SelectColor(M,0,280,450,49);
	 doTest();
     }



    public void doTest() {

	Vector V0=new Vector(1,2,3);
	Vector V1=new Vector(4,4,4);
	Vector V2=new Vector(6,5,3);
	Vector V3=new Vector(7,1,1);
	Vector V4=new Vector(3,4,5);

	Vector V=Matrix.nextVector(V0,V1,V2,V3,V4);

	V.print();
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      g.setColor(Color.blue);
      g.fillRect(0,0,getWidth(),getHeight());
      drawControls(g);
      PM.render(g);

   }

    public void drawControls(Graphics2D g) {

	g.setColor(new Color(0,0,100));
	g.fillRect(0,0,110,230);
	g.setColor(Color.white);
	g.drawRect(0,0,110,230);

	GLOBAL.render(g,5,5,100);
	MOUSE.render(g,5,60,100);
	SC.render(g);

	if(GLOBAL.mode==0) ItC.render(g);
   }


    public void setPanels() {  


         Color[] C0={new Color(0,150,185),Color.white,Color.white,Color.black,new Color(180,180,180)};
	 String[] MouseString={"not needed","button 1","button 2", "button 3", "3b mouse"};
	 int[] MouseState={1,0,0,0};
         MOUSE=new ControlPanel(C0,MouseString,MouseState,4);

	 String[] Global={"dynamics","debugging","options"};
	 int[] GlobalState={1,0};
         GLOBAL=new ControlPanel(C0,Global,GlobalState,2);
    }


    public void selectIteration(MouseEvent e) {
	int test=ItC.process(e,DOC);
    }


    public void mainAction(Point X) {
	int test=MOUSE.switchMode(X);
	if(test==20) DOC.mouse_info();
	test=GLOBAL.switchMode(X);
	if(test==20) DOC.main_info();
	PM.process(X);

    }



    public void mouseClicked(MouseEvent e) {
	ItC.M=this.M;
	DOC.M=this.M;	
        MouseData J=MouseData.process(e);
	mainAction(J.X);
	int test=SC.process(e);
	if(test==1) DOC.color_info();
	if(GLOBAL.mode==0) selectIteration(e);
	M.repaint();
    }


    public void debug() {
	System.out.println("------------");
	int Q=3;
	int h=0;
	
	int N=3*Q+4+h;
	
	PolyVector P=PolyVector.regular(N);
	for(int i=0;i<N;++i) {
	    P.V[i].x[0]=P.V[i].x[0]+.5*Math.random();
	    P.V[i].x[1]=P.V[i].x[1]+.5*Math.random();
	}
		
        PolyVector PP=P.pentagram(Q+2,Q+1);
	System.out.println("parameters "+Q+" "+N);
	

	for(int i=0;i<10;++i) System.out.println("");
	
	    int[][] step={{1,Q+1,Q+2},{1,Q+2,Q+1}};
	   Matrix m=BirdInvariants.transformGlick(P,step);
	   Matrix mm=BirdInvariants.transformGlick(PP,step);
	   Matrix w=Matrix.times(m,mm.inverse());
	   if(w.nearIdentity(.0000000001)==true) {
	       if(Math.abs(m.a[0][1])>.00000001) {
	        m.print();
	        mm.print();
	        w.print();
	        System.out.println("");
	       }
	   }
            w.print();
	
	System.out.println("---------");
	for(int i=0;i<500;++i) {
	    P=P.pentagram(Q+2,Q+1);
	}


		System.out.println("test eigenvector");
		Vector E=P.V[0];
		E.print();
		Vector EE=Matrix.act(m,E);
		EE=EE.normalize();
		EE.print();

	

    }

    

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
	SC.process(e);
	M.repaint();
     }




}

