import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class InvariantCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    String[][] S=new String[5][100];
    int count;
    int polycount;
    ListenSquare RESET;
    
    double[] VAL=new double[20];
    int[][] DIAG1=new int[40][2];
    int[][] DIAG2=new int[40][2];

    
     public InvariantCanvas() { 
	 count=0;
	 addMouseListener(this);
	 M=new Manager();
	 setScales(250,250,150);
	 RESET=new ListenSquare(205,5,40,20);
	 clearDiags();
     }
    

     public void clearDiags() {
	 System.out.println("used");
	 for(int i=0;i<40;++i) {
	     DIAG1[i][0]=0;
	     DIAG1[i][1]=0;
	     DIAG2[i][0]=0;
	     DIAG2[i][1]=0;
	 }
     }


    public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      getDiagData();
      drawBG(g);
      drawPolygon(g);
      drawInvariants(g);
      drawControls(g);
   }


    public void drawBG(Graphics2D g) {
      g.setColor(new Color(100,0,100));
      g.fillRect(0,0,getWidth(),getHeight());
    }

    
    public void drawControls(Graphics2D g) {
	RESET.render(g,"reset",12,2,new Color(50,0,50));
    }

    

    public double intPart(double x) {
	return(Math.floor(x+.5));
    }


    public String cleanDouble(double t) {
	Double T=new Double(t);
        String v1=T.toString();
	if(Math.abs(t)<.0000000001) v1="0";
	try {
	    if(t>.001) v1=v1.substring(0,12);
	}
	catch(Exception e) {} 
	return(v1);
    }


    public void drawInvariants(Graphics2D g) {
	g.setColor(Color.white);
	int k=M.C.ItC.SKIP1.val-1;
	Integer K=new Integer(k);
	boolean t=BirdConvex.weakTest(1,2,k+3,M.I.V[0]);
	
	if(t==true) g.drawString(K.toString()+"-bird",5,15);
	double e=BirdInvariants.energy(k,M.I.V[0]);
	Double E=new Double(e);
	g.drawString(K.toString()+"-energy "+E.toString(),5,35);

	double[] d=BirdInvariants.invariant(k,M.I.V[0]);
	for(int i=0;i<M.I.V[0].count;++i) {
	     E=new Double(d[i]);
	     if(d[i]<0) System.out.println("negative");
	     g.drawString(E.toString(),5,53+18*i);
	}
    }


    public void getDiagData() {
	
	int k=M.C.ItC.SKIP1.val-2;
	int n=M.P.V[0].count;
	DIAG1[0][0]=1;
	DIAG1[0][1]=1;
	DIAG1[n-k-2][0]=1;
	DIAG1[n-k-2][1]=1;

	
  	int[] list1=BirdConvex.sides(1,k,M.I.V[0]);
       	for(int i=0;i<list1.length;++i) {
	    DIAG1[list1[i]][0]=1;
	}

	int[] list2=BirdConvex.sides(0,k,M.I.V[0]);
       	for(int i=0;i<list2.length;++i) {
	    DIAG1[list2[i]][1]=1;
	}
	
	DIAG2[0][0]=1;
	DIAG2[0][1]=1;
	DIAG2[n-k-1][0]=1;
	DIAG2[n-k-1][1]=1;

	
  	list1=BirdConvex.sides(1,k-1,M.I.V[0]);
       	for(int i=0;i<list1.length;++i) {
	    DIAG2[list1[i]][0]=1;
	}

	list2=BirdConvex.sides(0,k-1,M.I.V[0]);
       	for(int i=0;i<list2.length;++i) {
	    DIAG2[list2[i]][1]=1;
	}

	
	
	
    }


    public void drawPolygon(Graphics2D g) {
	int k=M.C.ItC.SKIP1.val-2;
	int n=M.P.V[0].count;


	
	PolyVector P=PolyVector.regular(n);


	for(int i=0;i<n;++i) {
	    if((DIAG2[i][0]==1)&&(DIAG2[i][1]==0)) drawDiagonalLong(g,P,k+1,i,new Color(255,200,0));
	    if((DIAG2[i][0]==0)&&(DIAG2[i][1]==1)) drawDiagonalLong(g,P,k+1,i,new Color(255,0,255));
	    if((DIAG2[i][0]==1)&&(DIAG2[i][1]==1)) drawDiagonalLong(g,P,k+1,i,new Color(50,50,50));
	}


	
	Path2D.Double gp=P.toPath();
	gp=transform(gp);
	g.setColor(Color.black);
	g.fill(gp);
	g.setColor(Color.blue);
	g.draw(gp);

	for(int i=0;i<n;++i) {
	    if((DIAG1[i][0]==1)&&(DIAG1[i][1]==0)) drawDiagonal(g,P,k+2,i,new Color(255,200,0));
	    if((DIAG1[i][0]==0)&&(DIAG1[i][1]==1)) drawDiagonal(g,P,k+2,i,new Color(255,0,255));
	    if((DIAG1[i][0]==1)&&(DIAG1[i][1]==1)) drawDiagonal(g,P,k+2,i,new Color(50,50,50));
	}

	fillPoint(g,new Complex(1,0),.05,new Color(50,100,255),32);
    }

    public void drawDiagonal(Graphics2D g,PolyVector P,int k,int i,Color C) {
	int n=P.count;
	Path2D.Double gp=new Path2D.Double();
        int i0=i%n;
	int i1=(i+k)%n;
	Vector V0=P.V[i0].normalize();
	Vector V1=P.V[i1].normalize();
	gp.moveTo(V0.x[0],V0.x[1]);
	gp.lineTo(V1.x[0],V1.x[1]);
	gp=transform(gp);
	g.setColor(C);
	g.draw(gp);
    }

    public void drawDiagonalLong(Graphics2D g,PolyVector P,int k,int i,Color C) {
	int n=P.count;
	Path2D.Double gp=new Path2D.Double();
        int i0=i%n;
	int i1=(i+k)%n;
	Vector V0=P.V[i0].normalize();
	Vector V1=P.V[i1].normalize();
	double x0=V0.x[0];
    	double y0=V0.x[1];
	double x1=V1.x[0];
	double y1=V1.x[1];
	double x2=100*x0-99*x1;
	double x3=100*x1-99*x0;
	double y2=100*y0-99*y1;
	double y3=100*y1-99*y0;

	
	gp.moveTo(x2,y2);
	gp.lineTo(x3,y3);
	gp=transform(gp);
	g.setColor(C);
	g.draw(gp);
    }

    

    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(RESET.inside(J.X)==1) clearDiags();
    }



    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   

     public void mouseDragged(MouseEvent e) {
     } 

}

