import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class IterationCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    PolyVector[] V=new PolyVector[10];
    Color[] COLOR=new Color[10];
    int COUNT;
    Vector[] POINT=new Vector[100000];
    boolean DRAG;
    int count;
    Point JX;

     public IterationCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(200,150);
	 count=1;
	 V[0]=PolyVector.regular(7);
	 COUNT=0;
	 DRAG=false;
	 JX=new Point(0,0);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBg(g);
      int mode = M.C.ItC.ACTION.mode;
      if(mode!=2) drawEverything(g);
      if(mode==2) drawPoints(g);
   }

    public void drawBg(Graphics2D g) {
       Color C=Color.white;
       try {C=M.P.PC.getColor(0);}
	  catch(Exception e) {}
	  g.setColor(C);
          g.fillRect(0,0,getWidth(),getHeight());
      }

    public void drawEverything(Graphics2D g) {
	int k=M.C.ItC.SKIP1.val;
        PolyVector P=new PolyVector(V[0]);
	for(int i=0;i<M.C.ItC.ENTAIL.val;++i) {
  	    drawEverything(g, i,P);
	    int ii=2*(i%3);
	    int jj=ii+1;
	    P=P.pentagram(k,k-1);
	}
    }
    
    public void drawEverything(Graphics2D g,int i,PolyVector P) {
  	drawPolygon(g,P);
        if(i==0) drawDiagonal1(g,P);
	if(i==0) drawDiagonal2(g,P);
	drawTriangles(g,i,P);
    }
    

    
    public void drawPolygon(Graphics2D g,PolyVector P) {
      	Path2D.Double gp1=P.toPath();
	gp1=transform(gp1);
        g.setColor(M.P.PC.getColor(1));
        if(M.P.PC.getDisplay(1)==1) g.fill(gp1);
        g.setColor(M.P.PC.getColor(2));
	  if(M.P.PC.getDisplay(2)==1) g.draw(gp1);
    }


    
    public void drawDiagonal1(Graphics2D g,PolyVector P) {
       	int d=M.C.ItC.SKIP1.val;
	Color C=M.P.PC.getColor(3);
      	Path2D.Double gp1=P.toDiagPath(d);
	gp1=transform(gp1);
	g.setColor(C);
        if(M.P.PC.getDisplay(3)==1) g.draw(gp1);
    }

    
    public void drawDiagonal2(Graphics2D g,PolyVector P) {

	int d=M.C.ItC.SKIP1.val-1;
	Color C=M.P.PC.getColor(4);
      	Path2D.Double gp1=P.toDiagPath2(d);
   	gp1=transform(gp1);
	g.setColor(C);
        if(M.P.PC.getDisplay(4)==1) g.draw(gp1);
    }

    public void drawTriangles(Graphics2D g,int i,PolyVector P) {

	int i1=5+2*(i%3);
	int i2=i1+1;
	
	 Color C1=M.P.PC.getColor(i1);
	 Color C2=M.P.PC.getColor(i2);
	 if(M.P.PC.getDisplay(i1)==1) drawTriangles2(g,P,C1);
	 if(M.P.PC.getDisplay(i2)==1) drawTriangles1(g,P,C2);
    }

     
    public void drawTriangles1(Graphics2D g,PolyVector P,Color C1) {
  	int d=M.C.ItC.SKIP1.val;
      	for(int i=0;i<P.count;++i) {
	    Path2D.Double gp1=BirdGraphics.triPath1(d,i,P);
	    gp1=transform(gp1);
	    g.setColor(C1);
	    g.fill(gp1);
	}
    }
    
    public void drawTriangles2(Graphics2D g,PolyVector P,Color C2) {
      	int d=M.C.ItC.SKIP1.val;
      	for(int i=0;i<P.count;++i) {
	    Path2D.Double gp2=BirdGraphics.triPath2(d,i,P);
	    gp2=transform(gp2);
	    g.setColor(C2);
	    g.fill(gp2);
	}
    }

    public void drawPoints(Graphics2D g) {
	double d=M.C.ItC.POINTSIZE.val;
	d=Math.pow(2,-d);
	Path2D.Double gp1=new Path2D.Double();
	for(int i=0;i<COUNT;++i) {
	    gp1.reset();
	    Vector Q=POINT[i];
	    Complex z=new Complex(Q.x[0],Q.x[1]);
	    fillPoint(g,z,d,Color.black,16);
	}
    }


    /**a drawing routine for points**/

    public void fillPoint(Graphics2D g,Complex z,double r,Color C,int q) {
	Path2D.Double gp=new Path2D.Double();
	double x=z.x;
	double y=z.y;
	for(int i=0;i<=q;++i) {
	    double c=Math.cos(2*Math.PI*i/q);
	    double s=Math.sin(2*Math.PI*i/q);
	    c=r*c+z.x;
	    s=r*s+z.y;
	    if(i==0) gp.moveTo(c,s);
  	    if(i!=0) gp.lineTo(c,s);
	}
	gp=transform(gp);
	g.setColor(C);
	g.fill(gp);
	g.draw(gp);
    }


    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	int mode=J.mode;
	if(M.C.MOUSE.mode!=0) mode=M.C.MOUSE.mode;
	if(mode!=2) {
	   doScale(e,M);

	}
	if(mode==2) {
           doScale2(e,M);
	   SOURCE=unTransform(J.X);
	}
	repaint();
    }


    public void doMouseClick(int mode) {
	doScale(mode,JX);
	repaint();
    }

    
    
    public void mousePressed(MouseEvent e) { }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
    
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	 MouseData J=MouseData.process(e);
	 JX=new Point(J.X);
     }

     public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(J.mode==2) {
	   SOURCE=unTransform(J.X);
	   boolean test=BirdConvex.starTest(V[0],M.getDelta(),SOURCE);
	   System.out.println(test);
	}
	repaint();
     }

     public void keyReleased(KeyEvent e) {
	 DRAG=false;
     }

     public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=-100;
	if(ch=='z') test=1;   
	if(ch=='x') test=2;   
	if(ch=='c') test=3;  
	doMouseClick(test);
     }

    
    public void keyPressed(KeyEvent e) {
	char ch=e.getKeyChar();
	if(ch=='x') {
           DRAG=true;
	}
    }


}

