import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


 public class IterationControl {
    ControlPanel NORMALIZE,ACTION,POWER;
    SelectInteger VERTEX,LIM,POINTSIZE,RELABEL,NUMBER,SPEED,SKIP1;
    SelectInteger ENTAIL;
    ListenSquare RESET,GO,HALT,INFO;
    int X,Y;
    Manager M;
    Animator A;

    public IterationControl(int x,int y,Manager m) {
	this.X=x;
	this.Y=y;
	setPanels();
	setArrows();
	A=new Animator();
	INFO=new ListenSquare(X+470,Y+130,12,12);
	this.M=m;
    }

    public int getMode() {
	return(0);
    }

    public int getIterationNumber() {
	int n=NUMBER.val;
        int s=M.P.V[0].count;
        if(POWER.mode==1) n=n*s;
	return(n);
    }



    public void setArrows() {
	
	NUMBER=new SelectInteger(X+160,Y+20,40,20,1,1,50,1);
	RELABEL=new SelectInteger(X+240,Y+20,40,20,0,0,20,1);
	SPEED=new SelectInteger(X+330,Y+20,40,20,5,1,60,1);
	ENTAIL=new SelectInteger(X+415,Y+170,60,30,1,0,30,1);
	VERTEX=new SelectInteger(X,Y+180,40,20,5,5,10,1);
	POINTSIZE=new SelectInteger(X+70,Y+180,40,20,10,5,20,1);
        RESET=new ListenSquare(X+10,Y+225,20,20,null);
	LIM=new SelectInteger(X+70,Y+225,40,20,10,5,20,1);
	RESET.on=1;
	SKIP1=new SelectInteger(X+340,Y+170,60,30,3,3,10,1);
	GO=new ListenSquare(X+250,Y+80,40,20,null);
	GO.on=1;
	HALT=new ListenSquare(X+290,Y+80,40,20,null);
	HALT.on=1;	
    }
    


    public void setPanels() {  
         Color[] C0={new Color(0,150,185),Color.white,Color.white,Color.black,new Color(180,180,180)};
	 String[] ShapeString={"none","similarity","affine","affine+","projective","normalize"};
	 int[] ShapeState={0,0,1,0,0};
         NORMALIZE=new ControlPanel(C0,ShapeString,ShapeState,5);
	 NORMALIZE.mode=2;


	 String[] MovieString={"single","movie","orbit","action"};
	 int[] MovieState={1,0,0};
         ACTION=new ControlPanel(C0,MovieString,MovieState,3);
	 ACTION.mode=0;

	 String[] PowerString={"no","yes","multiplier"};
	 int[] PowerState={1,0};           POWER=new ControlPanel(C0,PowerString,PowerState,2);
	 POWER.mode=0;
    }



    public int getVertexRelabel() {
	return(RELABEL.val);
    }

    public int getIterationType() {
	return(0);
    }




    public void render(Graphics2D g) {
	NORMALIZE.render(g,X,Y+70,70);
	SKIP1.render(g,Color.red,Color.white,new Color(0,0,0,0));
	ENTAIL.render(g,Color.yellow,Color.white,Color.white);
	ACTION.render(g,X,Y,70);
	GO.render(g,"go",12,4,new Color(0,160,0));
	if(A.halt==1)  HALT.render(g,"halt",12,4,new Color(255,0,0));
	g.drawString("specify the map",X+370,Y+140);
	Integer N=new Integer(SKIP1.val-1);
	g.drawString("\u0394"+N.toString(),(int)(SKIP1.x),(int)(SKIP1.y-5));
	diagonalDraw(g);
	if(ACTION.mode==1) renderMovie(g);
	if(ACTION.mode==2) renderOrbit(g);
	INFO.infoRender(g);

	g.setColor(Color.white);
 	g.drawString("entail ",(int)(ENTAIL.x),(int)(ENTAIL.y-5));
   }


    public void renderMovie(Graphics2D g) {
	Color C=new Color(200,0,200);
	SPEED.render(g,Color.red,Color.white,Color.white);
	NUMBER.render(g,C,Color.white,Color.white);
	RELABEL.render(g,C,Color.white,Color.white);
	g.setColor(Color.white);
	g.drawString("speed?",(int)(SPEED.x),(int)(SPEED.y-5));

	g.drawString("cyclic relabel",(int)(RELABEL.x),(int)(RELABEL.y-5));
	POWER.render(g,X+77,Y+0,70);
    }

    public void renderOrbit(Graphics2D g) {
	POINTSIZE.render(g,Color.green,Color.white,Color.white);
	VERTEX.render(g,Color.green,Color.white,Color.white);
	LIM.render2(g,Color.green,Color.white,Color.white);
	g.drawString("point size",(int)(POINTSIZE.x),(int)(POINTSIZE.y-5));
	g.drawString("vertex",(int)(VERTEX.x),(int)(VERTEX.y-5));
	g.drawString("reset",(int)(RESET.x),(int)(RESET.y-5));
	g.drawString("iterates",(int)(LIM.x),(int)(LIM.y-5));
	RESET.render(g,Color.green);
   }


    public void diagonalDraw(Graphics2D g) {
	int n=7;
	try{
   	 n=M.P.V[0].count;
	}
	catch(Exception e) {}
	PolyVector P=PolyVector.regular(n);
	P=P.normalize();
  	Path2D.Double gp=P.toPath();
	AffineTransform A1=AffineTransform.getScaleInstance(60,60);
	AffineTransform A2=AffineTransform.getTranslateInstance(X+410,Y+265);
	gp.transform(A1);
	gp.transform(A2);
	g.setColor(Color.black);
	g.fill(gp);
	g.setColor(Color.red);
	g.draw(gp);


	gp.reset();
	int k1=SKIP1.val;	
          int k2=k1-1;
	int k3=(k1+k2)%n;

	gp.moveTo((P.V[0].x[0]),(P.V[0].x[1]));
	gp.lineTo((P.V[k1].x[0]),(P.V[k1].x[1]));	
	gp.moveTo((P.V[k2].x[0]),(P.V[k2].x[1]));
	gp.lineTo((P.V[k3].x[0]),(P.V[k3].x[1]));	
        gp.transform(A1);
	gp.transform(A2);
	g.setStroke(new BasicStroke(3));	
        g.setColor(Color.red);
	g.draw(gp);
	g.setStroke(new BasicStroke(1));	

    }





    public int getNormalize() {
	return(NORMALIZE.mode);
    }



    public int getMovieSpeed() {
	return(SPEED.val);
    }




    public void action() {
	if(ACTION.mode==0) doIteration();
	if((ACTION.mode!=0)&&(A.halt==0)) {
	    A=new Animator(this.M);
            new Thread(A).start();
	}
    }

    public void doIteration() {
	int num=getIterationNumber();
	int k1=SKIP1.val;
       	int k2=k1-1;
	M.I.COUNT=0;
	for(int i=0;i<num;++i) {
	    M.I.V[0]=M.I.V[0].pentagram(k1,k2); 
            M.I.V[0]=Reshape.reshape(M.I.V[0],getNormalize(),k1,k2);
	}

    }

    public void setSkip(Point X) {
	SKIP1.modify(X);
	int k=SKIP1.val;

	if(SKIP1.isModified(X)==1) {
	     M.P.PC.SIDE.val=3*k-2;
	     M.P.V[0]=PolyVector.regular(M.P.PC.SIDE.val);
	     M.I.V[0]=PolyVector.regular(M.P.PC.SIDE.val);
	}
	M.repaint();
    }


    public int process(MouseEvent e,Documentation DOC) {
        MouseData J=MouseData.process(e);
	int test=NORMALIZE.switchMode(J.X);
        if(test==20) DOC.reshape_info();
	if(INFO.inside(J.X)==1) DOC.penta_info();
	
	test=ACTION.switchMode(J.X);
	if(test==20) DOC.action_info();
	
	test=POWER.switchMode(J.X);
	if(test==20) DOC.power_info();
	
	LIM.modify(J.X);
	POINTSIZE.modify(J.X);
	VERTEX.modify(J.X);
	NUMBER.modify(J.X);
	RELABEL.modify(J.X);
	ENTAIL.modify(J.X);
	SPEED.modify(J.X);
	setSkip(J.X);
	ACTION.switchMode(J.X);
	if(HALT.inside(J.X)==1) A.halt=0;
	if(GO.inside(J.X)==1) action();
	if(RESET.inside(J.X)==1) M.I.COUNT=0;
	return(0);
    }


    
}

