import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of 3x3 matrices */


public class Matrix {
    double[][] a=new double[3][3];
    public Matrix(){}

    public Matrix(double[][] aa) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=aa[i][j];
	    }
	}
    }

    public Matrix(Vector[] V) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=V[i].x[j];
	    }
	}
    }

    public Matrix(Vector V1,Vector V2,Vector V3) {
	Vector[] V={V1,V2,V3};
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=V[i].x[j];
	    }
	}
    }

    public static Matrix zero() {
	double[][] aa={{0,0,0},{0,0,0},{0,0,0}};
	return new Matrix(aa);
    }

    public static Matrix plus(Matrix A,Matrix B) {
	Matrix C=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		C.a[i][j]=A.a[i][j]+B.a[i][j];
	    }
	}
	return C;
    }
    
    public static Matrix times(Matrix M1,Matrix M2) {
	Matrix M=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		M.a[i][j]=0;
		for(int k=0;k<3;++k) {
		    M.a[i][j]=M.a[i][j]+M1.a[i][k]*M2.a[k][j];
		}
	    }
	}
	return(M);
    }


    public void print() {
	Matrix b=new Matrix(this.a);
	double t=0.0000000000001;
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		if(Math.abs(a[i][j])<t) b.a[i][j]=0;
		if(Math.abs(1-a[i][j])<t) b.a[i][j]=1;
	    }
	}
				      
	System.out.println("matrix");
	System.out.println(b.a[0][0]+ " "+b.a[0][1]+" "+b.a[0][2]);
	System.out.println(b.a[1][0]+ " "+b.a[1][1]+" "+b.a[1][2]);
	System.out.println(b.a[2][0]+ " "+b.a[2][1]+" "+b.a[2][2]);
    }


    public  boolean nearIdentity(double t) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		if((i!=j)&&(Math.abs(a[i][j])>t)) return false;
		if((i==j)&&(Math.abs(1-a[i][j])>t)) return false;
	    }
	}
	return true;
    }

    



    public double det() {

	double a1=a[0][0]*a[1][1]*a[2][2];
	double a2=a[0][1]*a[1][2]*a[2][0];
	double a3=a[0][2]*a[1][0]*a[2][1];

	double b1=a[2][0]*a[1][1]*a[0][2];
	double b2=a[2][1]*a[1][2]*a[0][0];
	double b3=a[2][2]*a[1][0]*a[0][1];

	return(a1+a2+a3-b1-b2-b3);
    }


    public Matrix inverse() {

	Matrix M=new Matrix();

	M.a[0][0]= a[1][1]*a[2][2]-a[1][2]*a[2][1];
	M.a[0][1]= a[1][2]*a[2][0]-a[1][0]*a[2][2];
	M.a[0][2]= a[1][0]*a[2][1]-a[1][1]*a[2][0];

	M.a[1][0]= a[2][1]*a[0][2]-a[2][2]*a[0][1];
	M.a[1][1]= a[2][2]*a[0][0]-a[2][0]*a[0][2];
	M.a[1][2]= a[2][0]*a[0][1]-a[2][1]*a[0][0];

	M.a[2][0]= a[0][1]*a[1][2]-a[0][2]*a[1][1];
	M.a[2][1]= a[0][2]*a[1][0]-a[0][0]*a[1][2];
	M.a[2][2]= a[0][0]*a[1][1]-a[0][1]*a[1][0];

	double d=this.det();

	Matrix TM=new Matrix();

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=M.a[i][j]/d;
	    }
	}
	return(TM);
    }


    public Matrix transpose() {

	Matrix TM=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=a[i][j];
	    }
	}
	return(TM);
    }

    public double trace() {
	double t=a[0][0]+a[1][1]+a[2][2];
	return(t);
    }


    public double[] characteristics() {
	double d1=this.trace();
	double d2=this.det();
	double d3=d1*d1*d1/d2;
	Matrix M=this.inverse();
	double d4=M.trace();
	double d5=M.det();
	double d6=d4*d4*d4/d5;
	double[] e={d3,d6};
	return(e);
    }




    public Vector nearEigenvector1() {

	Vector V=new Vector(0,0,1);
	for(int i=0;i<500;++i) {
	    V=act(this,V);
	    V=V.normalize();
	}
	return(V);
    }


    public Vector nearEigenvector2() {
	Matrix m=this.inverse();
	Vector V=new Vector(0,0,1);
	for(int i=0;i<500;++i) {
	    V=act(m,V);
	    V=V.normalize();
	}
	return(V);
    }


    public Matrix conjugator0() {

	Vector V1=nearEigenvector1();
	Vector V2=nearEigenvector2();
	Vector V3=new Vector(0,0,1);
	Vector[] VV={V1,V2,V3};
	Matrix W=new Matrix(VV);
	return(W.transpose());
    }


    public Vector nearEigenvector3() {
	Matrix M=this;
	Matrix W=M.conjugator0();
	Matrix WW=Matrix.times(W.inverse(),Matrix.times(M,W));
	double b1=WW.a[0][2];
	double b2=WW.a[1][2];
	double a1=WW.a[0][0];
	double a2=WW.a[1][1];
	double a3=WW.a[2][2];
	double x=b1/(a3-a1);
	double y=b2/(a3-a2);
	Vector V=new Vector(x,y,1);
	V=act(W,V);
	V=V.normalize();
	return(V);
    }


    public Matrix conjugator() {

	Vector V1=nearEigenvector1();
	Vector V2=nearEigenvector2();
	Vector V3=nearEigenvector3();
	Vector[] VV={V2,V3,V1};
	Matrix W=new Matrix(VV);
	return(W.transpose());
    }






    public static Vector act(Matrix M,Vector V) {
	Vector W=new Vector(0,0,0);
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		W.x[i]=W.x[i]+M.a[i][j]*V.x[j];
	    }
	}
	return(W);
    }


    public static PolyVector act(Matrix M,PolyVector X) {
	PolyVector Y=new PolyVector();
	Y.count=X.count;
	Y.wrap=X.wrap;
	for(int i=0;i<X.count;++i) {
	    Y.V[i]=act(M,X.V[i]);
	}
	return(Y);
    }


    /**Produces the matrix which has the following projective action:

      [V0] -->  [1:0:0]
      [V1] -->  [0:1:0]
      [V2] -->  [0:0:1]
      [V3] -->  [1:1:1]

	 */

    public static Matrix normalize0(Vector V0,Vector V1,Vector V2,Vector V3) {
	Vector[] VV={V0,V1,V2};
	Matrix M=new Matrix(VV);
	M=M.transpose();
	Matrix M2=M.inverse();
	Vector L=Matrix.act(M2,V3);

	for(int i=0;i<3;++i) {
	for(int j=0;j<3;++j) {
	    M.a[i][j]=M.a[i][j]*L.x[j];
	}}

	M=M.inverse();
	return(M);
    }




    public static Matrix normalize0(PolyVector X,int vtx) {
	return(normalize0(X.V[0+vtx],X.V[1+vtx],X.V[2+vtx],X.V[3+vtx]));
    }

    public static Matrix normalize2() {

	Vector V0=new Vector(0,0,1);
	Vector V1=new Vector(1,0,1);
	Vector V2=new Vector(1,1,1);
	Vector V3=new Vector(0,1,1);
	Matrix M=normalize0(V0,V1,V2,V3);
	return(M);
    }



    public static Matrix normalize3(PolyVector X,int vtx) {
	Matrix M1=normalize0(X,vtx);
	Matrix M2=normalize2();
	Matrix M=times(M2.inverse(),M1);
	return(M);
    }

    public static PolyVector normalize(PolyVector X,int vtx) {
	Matrix M=normalize3(X,vtx);
	PolyVector Y=act(M,X);
	Y=Y.normalize();
	return(Y);
    }


    public static PolyVector normalize(PolyVector X1,PolyVector X2,int vtx) {
	Matrix M1=normalize3(X1,vtx);
	Matrix M2=normalize3(X2,vtx);
	Matrix M3=times(M1.inverse(),M2);
	PolyVector Y=act(M3,X2);
	Y=Y.normalize();
	return(Y);
    }







    public static Vector nextVector(Vector V0,Vector V1,Vector V2,Vector V3,Vector W) {
	PolyVector X=new PolyVector();
	X.V[0]=V0;
	X.V[1]=V1;
	X.V[2]=V2;
	X.V[3]=V3;
	Matrix M=normalize3(X,0);
	M=M.inverse();
	Vector Z=act(M,W);
	return(Z);
    }


    public static Matrix monodromy(PolyVector X) {
	PolyVector X0=new PolyVector();
	PolyVector X1=new PolyVector();
	int wrap=X.wrap;
	for(int i=0;i<4;++i) {
   	  X0.V[i]=X.V[i];
	  X1.V[i]=X.V[wrap+i];
	}
	Matrix m1=normalize3(X0,0);
	Matrix m2=normalize3(X1,0);
	Matrix m3=times(m2.inverse(),m1);
	return(m3);
    }






    public static double[] character(PolyVector X) {
	Matrix m=monodromy(X);
	return(m.characteristics());
    }



}




