import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;


public class PolyVector {
    Vector[] V=new Vector[100];
    int count;
    int wrap;

    public PolyVector() {
	for(int i=0;i<99;++i) 
	    V[i]=new Vector();
	wrap=0;
    }

    public PolyVector(PolyVector Q) {
	this.count=Q.count;
	for(int i=0;i<Q.count;++i) this.V[i]=Q.V[i];
	this.wrap=Q.wrap;
    }


    /**drawing routines*/
    public Path2D.Double toPath() {
	PolyVector P=this.normalize();
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(P.V[0].x[0],P.V[0].x[1]);
	for(int i=0;i<count;++i) {
	   gp.lineTo(P.V[i].x[0],P.V[i].x[1]);
	}
	gp.closePath();
	return(gp);
    }

    public Path2D.Double toPath2() {
	PolyVector P=this.normalize();
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(P.V[0].x[0],P.V[0].x[1]);
	for(int i=0;i<count;++i) {
	   gp.lineTo(P.V[i].x[0],P.V[i].x[1]);
	}
	return(gp);
    }


    public Path2D.Double toDiagPath(int k) {
	PolyVector P=this.normalize();
	Path2D.Double gp=new Path2D.Double();
	int i1,i2;
	for(int i=0;i<count;++i) {
	    i1=i;
	    i2=(i+k)%count;
	   gp.moveTo(P.V[i1].x[0],P.V[i1].x[1]);
	   gp.lineTo(P.V[i2].x[0],P.V[i2].x[1]);
	}
	return(gp);
    }

    public Path2D.Double toDiagPath2(int k) {
	PolyVector P=this.normalize();
	Path2D.Double gp=new Path2D.Double();
	int i1,i2;
	for(int i=0;i<count;++i) {
	    i1=i;
	    i2=(i+k)%count;
	    double x1=P.V[i1].x[0];
	    double y1=P.V[i1].x[1];
	    double x2=P.V[i2].x[0];
	    double y2=P.V[i2].x[1];
	    double x3=100*x1-99*x2;
	    double y3=100*y1-99*y2;
	    double x4=100*x2-99*x1;
	    double y4=100*y2-99*y1;
	    gp.moveTo(x1,y1);
	    gp.lineTo(x3,y3);
	    gp.moveTo(x2,y2);
	    gp.lineTo(x4,y4);

	}
	return(gp);
    }

    /*end drawing routines*/
    


    
    /**geometric routines*/
    /**from affine patch to plane*/
    public PolyVector normalize() {
	PolyVector P=new PolyVector();
	P.count=count;
	for(int i=0;i<count;++i) {
	    P.V[i]=V[i].normalize();
	}
	P.wrap=wrap;
	return(P);
    }


    public PolyVector rotate(double d) {
	PolyVector X=new PolyVector();
	X.count=this.count;
	for(int i=0;i<count;++i) {
	    X.V[i]=this.V[i].rotate(d);
	}
	return(X);
    }


    public int nearestVertex(Complex z) {
	int index=-1;
	Vector W=new Vector(z);
	double min=1000000.0;
	for(int i=0;i<count;++i) {
	    double test=W.dist(W,this.V[i]);
	    if(test<min) {
		min=test;;
		index =i;
	    }
	}
	return(index);
    }

    public PolyVector cycleVertices(int h) {
	PolyVector X=new PolyVector();
	X.count=this.count;
	for(int i=0;i<count;++i) {
	    int j=(i+h+100*count)%count;
	    X.V[i]=V[j];
	}
	return(X);
    }


    public PolyVector dual() {
	int n=this.count;
	PolyVector X=new PolyVector();
	X.count=n;
	for(int i=0;i<n;++i) {
	    int j=(i+1)%n;
	    X.V[i]=Vector.cross(V[i],V[j]);
	    X.V[i]=X.V[i].normalize();
	}
	return X;
    }


    /**end geometric routines*/

    


    /**pentagram map:
      k1 is the diagonal choice and
      k2 is the skip between consecutive diagonals.  
      The pentagram map is given by k1=2 and k2=1;*/
    

    public PolyVector pentagram(int k1,int k2) {

	PolyVector X=new PolyVector();
	X.count=count;
	int i1,i2,i3,i4;
	int k3=k1+k2;
	for(int i=0;i<count;++i) {
	    i1=(i+0+ count)%count;
	    i2=(i+k2+count)%count;
	    i3=(i+k1+count)%count;
	    i4=(i+k3+count)%count;
	    //ordering is deliberate
	    X.V[i]=V[i].findCross(V[i1],V[i3],V[i2],V[i4]);
	}
	int h=(k1+k2)/2;
	X=X.cycleVertices(-h);
	X=X.normalize();
	return(X);
    }



    public Vector collapsePoint(int k1,int k2) {
	PolyVector P=new PolyVector(this);
	for(int i=0;i<50;++i) P=P.pentagram(k1,k2);
	Vector V=P.V[0].normalize();
	V.x[2]=0;
	return V;
    }
    
    /* end pentagram map*/


    


    /**basic physical quantities*/


    /**center of mass*/
    public Vector center() {

	PolyVector Y=this.normalize();
	double x0,x1;
	x0=0;
	x1=0;

	for(int i=0;i<count;++i) {

	    x0=x0+Y.V[i].x[0];
	    x1=x1+Y.V[i].x[1];
	}

	x0=x0/count;
	x1=x1/count;
	Vector V=new Vector(x0,x1,1);
	return(V);
    }

    /**This computes the inertia matrix for the polygon.
       The routines assume that the center of mass is the origin.*/

    public double inertia(double a0,double a1) {

	double total=0;
	double s=0;
	for(int i=0;i<count;++i) {
	    s=a0*V[i].x[0]+a1*V[i].x[1];
	    total=total+s*s;
	}
	return(total);
    }


    public double[][] inertiaMatrix() {

	double a00=inertia(1,0);
	double a11=inertia(0,1);
	double xxx=inertia(1,1);

	double a01=.5*(xxx-a00-a11);
	double a10=a01;

	a00=2.0*a00/count;
	a01=2.0*a01/count;
	a10=2.0*a10/count;
	a11=2.0*a11/count;

	double[][] m={{a00,a01},{a10,a11}};
	return(m);
    }
    /*end physical quantities*/



    
    
    

    /**Special kinds of polygons*/

    public static PolyVector regular(int n) {

	PolyVector X=new PolyVector();
	X.count=n;
	for(int i=0;i<n;++i) {
	    double t=2.0*Math.PI*i/n;
	    X.V[i]=new Vector(Math.cos(t),Math.sin(t));
	}
	return(X);
    }
    
    public static PolyVector custom() {
	PolyVector X=new PolyVector();
	X.count=7;
	X.V[0]=new Vector(0,0,1);
	for(int i=1;i<7;++i) {
	    double t=1.0*i/5.0;
	    double c=Math.cos(t);
	    double s=Math.sin(t);
	    X.V[i]=new Vector(c,s,1);
	}
	return(X);
    }
    
    public static PolyVector custom2() {
	int q=3;
	PolyVector X=new PolyVector();
	X.count=3*q;
	for(int i=0;i<3*q;++i) {
	    double t=2.0*Math.PI*i/(3*q);
	    double a=1;
	    if(i%q==0) a=.021;
	    X.V[i]=new Vector(a*Math.cos(t),a*Math.sin(t));
	}
	return(X);
    }
    
    public static PolyVector randomCyclicExtreme(int n) {
	PolyVector P=new PolyVector();
	P.count=n;
	double[] d=randomListExtreme(n);
	for(int i=0;i<n;++i) {
	    P.V[i].x[0]=Math.cos(d[i]);
	    P.V[i].x[1]=Math.sin(d[i]);
	    P.V[i].x[2]=1;
	}
	return P;
    }

    public static PolyVector randomCyclic(int n) {
	PolyVector P=new PolyVector();
	P.count=n;
	double[] d=randomList(n);
	for(int i=0;i<n;++i) {
	    P.V[i].x[0]=Math.cos(d[i]);
	    P.V[i].x[1]=Math.sin(d[i]);
	    P.V[i].x[2]=1;
	}
	return P;
    }


    /**generates an ordered list of random numbers in (0,2 Pi)*/
    
    public static double[] randomList(int n) {
	double[] d=new double[n];
	for(int i=0;i<n;++i) d[i]=2*Math.PI*Math.random();
	Arrays.sort(d);
	return d;
    }

    public static double[] randomListExtreme(int n) {
	int a=(int)(n/3);
	int b=(int)(2*n/3);


	double[] d=new double[n];
	for(int i=0;i<n;++i) {
	    d[i]=Math.random();
	    if(i<a) d[i]=d[i]+.01;
	    if((i>=a)&&(i<b)) d[i]=d[i]*.01+1.0/3;
	    if(i>=b) d[i]=d[i]*.01+2.0/3;
	    d[i]=2.0*Math.PI*d[i];
	}
	    
	Arrays.sort(d);
	return d;
    }




    
    
    /**symmetrizing operations*/


    /**coerces polygon to be inscribed in unit circle*/

    public PolyVector unitize() {
	PolyVector X=new PolyVector();
	X.count=this.count;
	for(int i=0;i<count;++i) {
	    X.V[i]=this.V[i].unitize();
	}
	return(X);
    }
    
    /*end symmetrization*/


    

    /**printout*/
    
    public void print() {
	for(int i=0;i<count;++i) V[i].print();
    }

    public void print2() {
	System.out.print("POLY={");
	for(int i=0;i<count-1;++i) V[i].print2(true);
        V[count-1].print2(false);
    }





}

