import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PolygonControl {
    ControlPanel SHAPE,COLORSCHEME,UPDATE;  
    ControlPanelColor COLOR;
    SelectInteger SIDE;
    ListenSquare CONTROL,TRIANG1,TRIANG2;
    int X,Y;

    public PolygonControl(int x,int y) {
	this.X=x;
	this.Y=y;
	setPanels();

	SIDE=new SelectInteger(X+20,Y+110,60,30,7,5,50,1);
	CONTROL=new ListenSquare(X,Y,120,435);
	TRIANG1=new ListenSquare(X+80,Y+340,20,20);
	TRIANG2=new ListenSquare(X+100,Y+340,20,20);

	
    }

    public int getMode() {
	return(SHAPE.mode);
    }


    public void setPanels() {  

         Color[] C0={new Color(80,130,255),Color.white,Color.white,Color.black,new Color(180,180,180)};
	 String[] TypeString={"general","cyclic","type"};
	 int[] TypeState={1,0};
         SHAPE=new ControlPanel(C0,TypeString,TypeState,2);
	 SHAPE.mode=0;


	 String[] SchemeString={"original","greyscale","random","reset colors"};
	 int[] SchemeState={0,0,0};
         COLORSCHEME=new ControlPanel(C0,SchemeString,SchemeState,3);


	 String[] UpdateString={"rand","xtreme","iter","custom","get"};
	 int[] UpdateState={1,0,0,0};
         UPDATE=new ControlPanel(C0,UpdateString,UpdateState,4);

	 String[] ColorString={"background","polygon","poly outline","diag(k+2)","diag(k+1)",
			       "tiling1","tiling2","tiling3","tiling4","tiling5","tiling6","dual1","dual2","picture colors"};
	 Color[] CColor={new Color(255,0,150),
			 new Color(255,200,0),
			 Color.black,
			 new Color(0,0,200),
			 new Color(100,0,100),
			 new Color(180,0,0),new Color(220,0,0),
			 new Color(255,100,0),new Color(255,200,0),
			 new Color(255,255,0),new Color(140,0,0)};
	 int[] ColorState={1,1,1,0,0,0,0,0,0,0,0,0,0};
         COLOR=new ControlPanelColor(C0,ColorString,ColorState,11,CColor);

    }


    /** dealing with the color scheme */

    public void resetColors(Point X,Documentation DOC) {	   
	if(COLORSCHEME.L[0].inside(X)==1) setOriginal();
	if(COLORSCHEME.L[1].inside(X)==1) setGreyscale();
	if(COLORSCHEME.L[2].inside(X)==1) setRandom();
	if(COLORSCHEME.L[20].inside(X)==1) DOC.colorscheme_info();
	
	if(TRIANG1.inside(X)==1) {
	    for(int i=5;i<11;++i) COLOR.L[i].on=1;
	}
	if(TRIANG2.inside(X)==1) {
	    for(int i=5;i<11;++i) COLOR.L[i].on=0;
	}
    }

    public void setOriginal() {
	Color[] CColor={new Color(255,0,150),
			 new Color(255,200,0),
			 Color.black,
			 new Color(0,0,200),
			new Color(100,0,100),
			 new Color(180,0,0),new Color(220,0,0),
			 new Color(255,100,0),new Color(255,200,0),
			 new Color(255,255,0),new Color(140,0,0)};
	Color[] C={Color.white,new Color(0,0,0,30),Color.black};
	 for(int i=0;i<11;++i) {
              COLOR.M[i].C=CColor[i]; 
	 }
    }

    public void setGreyscale() {
	Color[] CColor={new Color(0,0,255),
			 new Color(255,200,0),
			 Color.black,
			 new Color(0,0,200),
			new Color(100,0,100),
			new Color(255,255,255),new Color(0,0,0),
			new Color(80,80,80),new Color(120,120,120),
			new Color(160,160,160),new Color(200,200,200)};
	Color[] C={Color.white,new Color(0,0,0,30),Color.black};
	 for(int i=0;i<11;++i) {
              COLOR.M[i].C=CColor[i]; 
	 }
    }


    

    public void setRandom() {

	for(int i=0;i<11;++i) {
	    double[] d={Math.random(),Math.random(),Math.random()};
	    int[] c=new int[3];
	    for(int j=0;j<3;++j) c[j]=(int)(255*d[j]);
	    COLOR.M[i].C=new Color(c[0],c[1],c[2]);   
	}
    }

    public Color getColor(int j) {
    	return(COLOR.M[j].C);
    }

    public int getDisplay(int j) {
	return(COLOR.L[j].on);
    }

    public int getSides() {
	return(SIDE.val);
    }

    public int getUpdate() {
	return(UPDATE.mode);
    }



    public void render(Graphics2D g) {
	CONTROL.render(g,Color.black);
	SHAPE.render(g,X,Y,60);
	UPDATE.render(g,X+60,Y,60);
	COLORSCHEME.render(g,X,Y+150,120);
	COLOR.render(g,X,Y+220,120);
	TRIANG1.render(g,new Color(200,200,200));
	TRIANG2.render(g,new Color(0,0,0));
		       
	SIDE.render(g,Color.red,Color.white,Color.white);
        g.drawString("sides",(int)(SIDE.x),(int)(SIDE.y-5));

   }


    public int process(MouseEvent e,Documentation DOC,Color C) {
        MouseData J=MouseData.process(e);
	int test=SHAPE.switchMode(J.X);
	if(test==20) DOC.type_info();
        test=COLOR.process(J.X,C);
	if(test==20) DOC.colorselect_info();
	test=UPDATE.switchMode(J.X);
	if(test==20) DOC.update_info();
	resetColors(J.X,DOC);
	SIDE.modify(J.X);
	test=UPDATE.switchMode(J.X);
	if(test>=0) return 10+test;
	if(SIDE.isModified(J.X)==1) return(99);
	return(0);
    }








}

