import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class Reshape {

    public Reshape() {}

    /**This file contains routines which normalize the polygon
       in various ways, by applying suitable projective or
       affine transformations.*/


    public static PolyVector center(PolyVector X) {
	PolyVector Y=new PolyVector();
	Y.count=X.count;
	Vector V=X.center();
	for(int i=0;i<X.count;++i) {
	    Y.V[i].x[0]=X.V[i].x[0]-V.x[0];
	    Y.V[i].x[1]=X.V[i].x[1]-V.x[1];
	    Y.V[i].x[2]=1;
	}
	return(Y);
    }


    public static int nearlyRound(PolyVector Y) {
	double[][] z = Y.inertiaMatrix();
	int test=1;
	if(Math.abs(z[0][1])>.00000001) test=0;
	if(Math.abs(z[1][0])>.00000001) test=0;
	return(test);
    }



    public static PolyVector affine(PolyVector X,int k1,int k2) {
	PolyVector Y=affine(X);
	Vector V=Y.collapsePoint(k1,k2);
	for(int i=0;i<Y.count;++i) Y.V[i]=Vector.minus(Y.V[i],V);
	return Y;
    }

    
    public static PolyVector affine(PolyVector X) {
	PolyVector Y=similarity(X);

	int test=nearlyRound(Y);
	if(test==1) return(Y);

	double[][] y0 = Y.inertiaMatrix();
        double[][] y1=inverseEigenbasis(y0);

	for(int i=0;i<Y.count;++i) {
	    Y.V[i]=Y.V[i].matrixAct(y1);
	}

	double[][] y3=Y.inertiaMatrix();
	y3[0][0]=1.0/Math.sqrt(y3[0][0]);
	y3[1][1]=1.0/Math.sqrt(y3[1][1]);

	for(int i=0;i<Y.count;++i) {
	    Y.V[i]=Y.V[i].matrixAct(y3);
	}
	return(Y);
    }


    


    public static PolyVector similarity(PolyVector X) {
	PolyVector Y=new PolyVector();
	Y.count=X.count;

	double[][] z = X.inertiaMatrix();
	double d=z[0][0]*z[1][1]-z[0][1]*z[1][0];

	double dd=Math.pow(d,-.25);

	double[][] y={{dd,0},{0,dd}};

	for(int i=0;i<Y.count;++i) {
	    Y.V[i]=X.V[i].matrixAct(y);
	}
	return(Y);
    }





    public static PolyVector rotate(PolyVector X) {
	double[] x={X.V[0].x[0],X.V[0].x[1]};
	double d=x[0]*x[0]+x[1]*x[1];
	d=Math.sqrt(d);
	double[] y={x[0]/d,x[1]/d};
	double[][] m={{y[0],-y[1]},{y[1],y[0]}};
	double[][] n=new double[2][2];
	n[0][0]=m[1][1];
	n[1][1]=m[0][0];
	n[0][1]=-m[0][1];
	n[1][0]=-m[1][0];
	PolyVector Y=new PolyVector();
	Y.count=X.count;
	for(int i=0;i<Y.count;++i) {
	    Y.V[i]=X.V[i].matrixAct(n);
	}
	return(Y);
    }







    public static PolyVector reshape(PolyVector X,int mode,int k1,int k2) {
	if(mode==1) return(reshapeSimilarity(X));
	if(mode==2) return(reshapeAffine(X));
	if(mode==3) return(reshapeAffine(X,k1,k2));
	if(mode==4) return(reshapeProjective(X,0));
	return(X);
    }
			   

    public static PolyVector reshapeSimilarity(PolyVector X) {
	   PolyVector Y=center(X);
	   Y=similarity(Y);
	   Y.wrap=X.wrap;
	return(Y);
    }



    public static PolyVector reshapeAffine(PolyVector X) {
	   PolyVector Y=center(X);
	   Y=affine(Y);
	   Y=rotate(Y); 
           Y.wrap=X.wrap;
	return(Y);
    }


    public static PolyVector reshapeAffine(PolyVector X,int k1,int k2) {
	   PolyVector Y=center(X);
	   Y=affine(Y,k1,k2);
	   Y=rotate(Y); 
           Y.wrap=X.wrap;
	return(Y);
    }




    public static PolyVector reshapeProjective(PolyVector X,int vtx) {
	PolyVector Y=Matrix.normalize(X,vtx); 
	   Y.count=X.count;
           Y.wrap=X.wrap;
	return(Y);
    }













    //only works for symmetric matrices

    public static double[] eigenvalues(double[][] m) {

	if(Math.abs(m[0][1])<.000000001) {
	    double[] tt={m[0][0],m[1][1]};
	    return(tt);
	}

	double c=m[0][0]*m[1][1]-m[0][1]*m[1][0];
	double b=-(m[0][0]+m[1][1]);
	double a=1;
	return(solveQuadratic(a,b,c));
    }

    public static double[] eigenvector(double[][] m,int q) {
	double[] e=eigenvalues(m);
	double[][] w={{m[0][0]-e[q],m[0][1]},{m[1][0],m[1][1]-e[q]}};
	double[] t={-w[1][0],w[0][0]};
	double d=t[0]*t[0]+t[1]*t[1];
	d=Math.sqrt(d);
	t[0]=t[0]/d;
	t[1]=t[1]/d;
	return(t);
    }


    public static double[][] inverseEigenbasis(double[][] m) {
	double[] x=eigenvector(m,0);
	double[][] y=new double[2][2];

	y[0][0]=x[0];
	y[0][1]=x[1];
	y[1][0]=-x[1];
	y[1][1]=x[0];

	return(y);

    }


    //only works for positive discriminant

    public static double[] solveQuadratic(double a,double b,double c) {
	double t1,t2;

	if(a==0) {
	    t1=-c/b;
	    t2=t1;
  	    double[] tt={t1,t2};
	    return(tt);
	}

	t1=(-b - Math.sqrt(b*b-4*a*c))/(2*a);
	t2=(-b + Math.sqrt(b*b-4*a*c))/(2*a);
	double[] tt={t1,t2};
	return(tt);
    }






}

