import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class SelectCanvas extends ScaleCanvas implements MouseListener, KeyListener, MouseMotionListener {
    Manager M;
    PolyVector[] V=new PolyVector[5];
    Color[] COLOR=new Color[5];
    double[] PONCELET=new double[2];
    int count;
    int VTX;
    double eccentricity;
    ListenSquare ECC;
    int history;
    ListenSquare SEND;
    Point CURSOR;
    boolean DRAG;
    PolygonControl PC;


     public SelectCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(320,200,160);	
	 V[0]=PolyVector.regular(7);
	 PONCELET[0]=1;
	 PONCELET[1]=1;
	 ECC=new ListenSquare(0,0,60,20,Color.blue);
	 ECC.on=1;
	 eccentricity=.75;
	 history=-1;
         SEND=new ListenSquare(0,0,40,20,null);
	 SEND.on=1;
	 count=1;
	 CURSOR=new Point();
	 PC=new PolygonControl(0,25);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);

        drawBg(g);
	drawPolygons(g);  
        drawSource(g);
	if(PC.SHAPE.mode==1) drawCircle(g);
	PC.render(g);
        drawKey(g);
   }


   public void drawBg(Graphics2D g) {
       g.setColor(new Color(140,0,140));
       int k=M.C.ItC.SKIP1.val-2;
       boolean test=BirdConvex.weakTest(1,2,k+3,V[0]);
       if(test==false) g.setColor(new Color(40,40,40));
       g.fillRect(0,0,getWidth(),getHeight());
       Integer I=new Integer(VTX);
       g.setColor(Color.white);
       g.drawString(I.toString(),5,15);
      }


    
   public void drawKey(Graphics2D g) {
       g.setFont(new Font("Helvetica",Font.PLAIN,12));
       g.setColor(Color.white);
       int mode=0;
       try {
	   mode=PC.getMode();
       }
       catch(Exception e) {}
       int h=16;
       if(mode==2) h=32;
       g.drawString("key commands: z zoom in,  x select, c zoom out",170,h);
      }


    public void selectPolygon(MouseEvent e) {
  	int test=PC.process(e,M.C.DOC,M.C.SC.C);
  	if(test==99) V[0]=PolyVector.regular(PC.getSides());
	if(test==10) V[0]=PolyVector.randomCyclic(PC.getSides());
	if(test==11) V[0]=PolyVector.randomCyclicExtreme(PC.getSides());
	if(test==12) V[0]=new PolyVector(M.I.V[0]);
	if(test==13) V[0]=PolyVector.custom();
	 M.I.V[0]=new PolyVector(V[0]);
    }


    public void drawCircle(Graphics2D g) {
	fillPoint(g,new Complex(0,0),1,new Color(0,0,0,0),new Color(100,150,255),1000);
    }


    public void drawPolygons(Graphics2D g) {
	Path2D.Double gp=V[0].toPath();
	gp=transform(gp);
	g.setColor(Color.black);
	g.fill(gp);
	g.setColor(Color.white);
	g.draw(gp);
	Complex z=V[0].V[VTX].toComplex();
	fillPoint(g,z,.02,Color.red,32);
    }




    public void setVertex(Point X) {
	setVertex0(X);
	if(PC.getUpdate()==0) M.I.V[0]=new PolyVector(V[0]);
    }

    public void setVertex0(Point X) {
	int mode=PC.getMode();
	V[0].V[VTX]=new Vector(SOURCE);
	if(mode==1) V[0]=V[0].unitize();
	M.I.V[0]=new PolyVector(V[0]);
    }


    public void findNearest() {
	if(PC.getMode()!=3) findNearest0();
	if(PC.getMode()==3) findNearest1();

    }


    public void findNearest0() {
	int n=V[0].nearestVertex(SOURCE);
	VTX=n;
    }


    public void findNearest1() {
	double x=SOURCE.x;
	double y=SOURCE.y;
	if(y>0) {
	    if((x>.05)&&(x<.95)) {
	    int n=V[0].nearestVertex(SOURCE);
	    VTX=n;
	    }
	}
    }




    public void mouseClicked(MouseEvent e) {
      MouseData J=MouseData.process(e);
      int mode=J.mode;
      selectPolygon(e);
      doMouseClick(J.mode);
      M.repaint();
    }

    public void doMouseClick(int mode) {
	if(PC.CONTROL.inside(CURSOR)==1) return;

	if(M.C.MOUSE.mode!=0) mode=M.C.MOUSE.mode;

	if(mode!=2) doScale(mode,CURSOR);

	if(mode==2) {
	    doScale2(mode,CURSOR);
	   findNearest();	
	   setVertex(CURSOR);
	}
	M.repaint();
    }

    





    
    public void mousePressed(MouseEvent e) {
	DRAG=true;
    }

     public void mouseReleased(MouseEvent e) {
	 DRAG=false;
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }

    
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	CURSOR=J.X;
	if(DRAG==true) doMouseClick(2);
     }
    

     public void mouseDragged(MouseEvent e) {

	MouseData J=MouseData.process(e);
	int mode=J.mode;
   	if(M.C.MOUSE.mode!=0) mode=M.C.MOUSE.mode;

	if(mode==2) {
	    doScale2(mode,J.X);
	   findNearest();	
            setVertex(J.X);
	}
	M.repaint();
     }



     public void keyReleased(KeyEvent e) {
	 DRAG=false;
     }

     public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int test=-100;
	if(ch=='z') test=1;   
	if(ch=='x') test=2;   
	if(ch=='c') test=3;  
	doMouseClick(test);
     }

    
    public void keyPressed(KeyEvent e) {
	char ch=e.getKeyChar();
	if(ch=='x') {
           DRAG=true;
	}
    }

}

