import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class CalculationMonitor {
    int X,Y;
    double TIME,TIME2,VOLUME,TOTAL;
    int STEPS,STEPS2;
    int[] AGE=new int[5];
    int[][] MIN_MEMORY=new int[2][14];
    int[][] SEC_MEMORY=new int[2][14];
    int[][] STEPS_MEMORY=new int[2][14];
    int[] MARKER=new int[2];
    

    public CalculationMonitor(int x,int y) {
	X=x;
	Y=y;
    }


    public void render(Graphics2D g,boolean halt) {
	drawFrame(g,halt);
	g.setColor(Color.yellow);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.drawString("calculation monitor",X,Y+17);
	drawMemory(g,halt);
	  drawDimensions(g);
	  drawTime(g);
	  drawTime2(g);
	  drawSteps(g);
	  drawSteps2(g);
	  drawProgress(g);
	  drawMemory(g,halt);
    }


    public void drawFrame(Graphics2D g,boolean halt) {
	g.setColor(new Color(0,0,255));
	if(halt==true) g.setColor(new Color(0,0,60));
	g.fillRect(X-5,Y,140,320);
	g.setColor(Color.white);
	g.drawRect(X-5,Y,140,320);
	g.setColor(Color.black);
	g.fillRect(X+170,Y,200,320);
	g.setColor(Color.white);
	g.drawRect(X+170,Y,200,320);
	g.setColor(new Color(0,0,190));
	g.drawLine(X+270,Y+40,X+270,Y+319);
	for(int i=0;i<14;++i) {
	    g.drawLine(X+171,Y+40+20*i,X+369,Y+40+20*i);
	}
    }

    public void clear() {
	for(int i=0;i<2;++i) {
	    for(int j=0;j<14;++j) {
		STEPS_MEMORY[i][j]=0;
	    }
	}
    }


    public void drawMemory(Graphics2D g,boolean halt) {
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.setColor(Color.yellow);
	g.drawString("calculation record",X+210,Y+17);
	g.setColor(Color.white);
	for(int i=0;i<2;++i) {
	    for(int j=0;j<14;++j) {
		if(STEPS_MEMORY[i][j]>0) {
	          g.drawString(convert(STEPS_MEMORY[i][j]),X+180+100*i,Y+57+20*j);
		  String S1=convert(MIN_MEMORY[i][j]);
		  String S2=convert(SEC_MEMORY[i][j]);
	          g.drawString(S1+"."+S2,X+228+100*i,Y+57+20*j);
		}
	    }
	}
	if(MARKER[0]!=-1) {
	    int i=MARKER[0];
	    int j=MARKER[1];
	    if(halt==false) {
	      double v=98*(VOLUME-Math.floor(VOLUME));
	      g.setColor(new Color(50,100,255));
	      g.fillRect(X+171+100*i,Y+41+20*j,(int)(v),19);  
              g.setColor(new Color(0,0,200));
              g.drawString("working",X+193+100*i,Y+55+20*j);
	    }
	}
    }

    public void drawDimensions(Graphics2D g) {
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
        g.setColor(Color.white);
        g.drawString("current dimensions:",X,Y+40);
        for(int i=0;i<5;++i) {
	   g.drawString(convert(AGE[i]),X+20*i,Y+60);
       }
    }

    public void drawTime(Graphics2D g) {
	int[] A=convertTime(TIME);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
        g.setColor(Color.white);
	g.drawString("total elapsed time",X,Y+90);
        g.drawString(convert(A[0])+" min",X,Y+110);
        g.drawString(convert(A[1])+" sec",X+57,Y+110);
    }

    public void drawTime2(Graphics2D g) {
	int[] A=convertTime(TIME2);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
        g.setColor(Color.white);
	g.drawString("local elapsed time",X,Y+140);
        g.drawString(convert(A[0])+" min",X,Y+160);
        g.drawString(convert(A[1])+" sec",X+57,Y+160);
    }


    public void drawSteps(Graphics2D g) {
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
        g.setColor(Color.white);
        g.drawString("total steps: "+convert(STEPS),X,Y+195);
    }

    public void drawSteps2(Graphics2D g) {
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
        g.setColor(Color.white);
        g.drawString("local steps: "+convert(STEPS2),X,Y+230);
    }

    public void drawProgress(Graphics2D g) {
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
        g.setColor(Color.white);
	g.drawString("progress",X,Y+268);
        g.drawString(convert(VOLUME),X,Y+290);
        g.drawString("out of",X,Y+310);
        g.drawString(convert(TOTAL),X+40,Y+310);
    }



    public static int[] convertTime(double t) {
	double u1=t/1000;  //seconds
	double u2=Math.floor(u1/60); //minutes
	double u3=u1-60*u2;  
	int a=(int)(u2);
	int b=(int)(u3);
	int[] A={a,b};
	return(A);
    }

    public String convert(int a) {
	Integer A=new Integer(a);
	return(A.toString());
    }


    public String convert(double a) {
	Double A=new Double(a);
	return(A.toString());
    }

}

