import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of nxn matrices.  Here n<10 */


public class CayleyMenger {

    /**These are the  main functions.  The arguments
       are normalized so that the first coordinate is 1.
       These correspond to the functions cm and dcm above*/


    /**The Cayley-Menger determinant*/

    public static double f1(double[] d) {
	double d12=1;
	double d13=d[0];
	double d14=d[1];
	double d23=d[2];
	double d24=d[3];
	double d34=d[4];


double y=-(p(d13,2)*p(d23,2)) + p(d14,2)*p(d23,2) + 
   p(d13,2)*p(d14,2)*p(d23,2) - p(d14,4)*p(d23,2) - 
   p(d14,2)*p(d23,4) + p(d13,2)*p(d24,2) - 
   p(d13,4)*p(d24,2) - p(d14,2)*p(d24,2) + 
   p(d13,2)*p(d14,2)*p(d24,2) + 
   p(d13,2)*p(d23,2)*p(d24,2) + 
   p(d14,2)*p(d23,2)*p(d24,2) - p(d13,2)*p(d24,4) - 
   p(d34,2) + p(d13,2)*p(d34,2) + p(d14,2)*p(d34,2) - 
   p(d13,2)*p(d14,2)*p(d34,2) + p(d23,2)*p(d34,2) + 
   p(d14,2)*p(d23,2)*p(d34,2) + p(d24,2)*p(d34,2) + 
   p(d13,2)*p(d24,2)*p(d34,2) - 
    p(d23,2)*p(d24,2)*p(d34,2) - p(d34,4);
   return(2*y);
    }



    /**The diagonal directional derivative of the C-M determinant*/

    public static double f2(double[] d) {
	double d12=1;
	double d13=d[0];
	double d14=d[1];
	double d23=d[2];
	double d24=d[3];
	double d34=d[4];

double y=-(p(d13,2)*d23) + p(d14,2)*d23 + p(d13,2)*p(d14,2)*d23 - 
   p(d14,4)*d23 - d13*p(d23,2) - p(d13,2)*p(d23,2) + 
   d14*p(d23,2) + p(d13,2)*d14*p(d23,2) + 
   p(d14,2)*p(d23,2) + d13*p(d14,2)*p(d23,2) - 
   2*p(d14,3)*p(d23,2) - 2*p(d14,2)*p(d23,3) - 
   d14*p(d23,4) + p(d13,2)*d24 - p(d13,4)*d24 - p(d14,2)*d24 + 
   p(d13,2)*p(d14,2)*d24 + p(d13,2)*p(d23,2)*d24 + 
   p(d14,2)*p(d23,2)*d24 + d13*p(d24,2) + 
   p(d13,2)*p(d24,2) - 2*p(d13,3)*p(d24,2) - d14*p(d24,2) + 
   p(d13,2)*d14*p(d24,2) - p(d14,2)*p(d24,2) + 
   d13*p(d14,2)*p(d24,2) + p(d13,2)*d23*p(d24,2) + 
   p(d14,2)*d23*p(d24,2) + d13*p(d23,2)*p(d24,2) + 
   d14*p(d23,2)*p(d24,2) - 2*p(d13,2)*p(d24,3) - 
   d13*p(d24,4) - d34 + p(d13,2)*d34 + p(d14,2)*d34 - 
   p(d13,2)*p(d14,2)*d34 + p(d23,2)*d34 + 
   p(d14,2)*p(d23,2)*d34 + p(d24,2)*d34 + 
   p(d13,2)*p(d24,2)*d34 - p(d23,2)*p(d24,2)*d34 - 
   2*p(d34,2) + d13*p(d34,2) + p(d13,2)*p(d34,2) + 
   d14*p(d34,2) - p(d13,2)*d14*p(d34,2) + 
   p(d14,2)*p(d34,2) - d13*p(d14,2)*p(d34,2) + 
   d23*p(d34,2) + p(d14,2)*d23*p(d34,2) + 
   p(d23,2)*p(d34,2) + d14*p(d23,2)*p(d34,2) + 
   d24*p(d34,2) + p(d13,2)*d24*p(d34,2) - 
   p(d23,2)*d24*p(d34,2) + p(d24,2)*p(d34,2) + 
   d13*p(d24,2)*p(d34,2) - d23*p(d24,2)*p(d34,2) - 
    2*p(d34,3) - p(d34,4);

return(4*y);
    }


    /**The magic function f2-6 f1*/

    public static double f3(double[] d) {
	double d12=1;
	double d13=d[0];
	double d14=d[1];
	double d23=d[2];
	double d24=d[3];
	double d34=d[4];

double y=-4*p(d13,2)*d23 + 4*p(d14,2)*d23 + 4*p(d13,2)*p(d14,2)*d23 - 
   4*p(d14,4)*d23 - 4*d13*p(d23,2) + 8*p(d13,2)*p(d23,2) + 
   4*d14*p(d23,2) + 4*p(d13,2)*d14*p(d23,2) - 
   8*p(d14,2)*p(d23,2) + 4*d13*p(d14,2)*p(d23,2) - 
   12*p(d13,2)*p(d14,2)*p(d23,2) - 8*p(d14,3)*p(d23,2) + 
   12*p(d14,4)*p(d23,2) - 8*p(d14,2)*p(d23,3) - 
   4*d14*p(d23,4) + 12*p(d14,2)*p(d23,4) + 4*p(d13,2)*d24 - 
   4*p(d13,4)*d24 - 4*p(d14,2)*d24 + 4*p(d13,2)*p(d14,2)*d24 + 
   4*p(d13,2)*p(d23,2)*d24 + 4*p(d14,2)*p(d23,2)*d24 + 
   4*d13*p(d24,2) - 8*p(d13,2)*p(d24,2) - 
   8*p(d13,3)*p(d24,2) + 12*p(d13,4)*p(d24,2) - 
   4*d14*p(d24,2) + 4*p(d13,2)*d14*p(d24,2) + 
   8*p(d14,2)*p(d24,2) + 4*d13*p(d14,2)*p(d24,2) - 
   12*p(d13,2)*p(d14,2)*p(d24,2) + 
   4*p(d13,2)*d23*p(d24,2) + 4*p(d14,2)*d23*p(d24,2) + 
   4*d13*p(d23,2)*p(d24,2) - 
   12*p(d13,2)*p(d23,2)*p(d24,2) + 
   4*d14*p(d23,2)*p(d24,2) - 
   12*p(d14,2)*p(d23,2)*p(d24,2) - 8*p(d13,2)*p(d24,3) - 
   4*d13*p(d24,4) + 12*p(d13,2)*p(d24,4) - 4*d34 + 
   4*p(d13,2)*d34 + 4*p(d14,2)*d34 - 4*p(d13,2)*p(d14,2)*d34 + 
   4*p(d23,2)*d34 + 4*p(d14,2)*p(d23,2)*d34 + 4*p(d24,2)*d34 + 
   4*p(d13,2)*p(d24,2)*d34 - 4*p(d23,2)*p(d24,2)*d34 + 
   4*p(d34,2) + 4*d13*p(d34,2) - 8*p(d13,2)*p(d34,2) + 
   4*d14*p(d34,2) - 4*p(d13,2)*d14*p(d34,2) - 
   8*p(d14,2)*p(d34,2) - 4*d13*p(d14,2)*p(d34,2) + 
   12*p(d13,2)*p(d14,2)*p(d34,2) + 4*d23*p(d34,2) + 
   4*p(d14,2)*d23*p(d34,2) - 8*p(d23,2)*p(d34,2) + 
   4*d14*p(d23,2)*p(d34,2) - 
   12*p(d14,2)*p(d23,2)*p(d34,2) + 4*d24*p(d34,2) + 
   4*p(d13,2)*d24*p(d34,2) - 4*p(d23,2)*d24*p(d34,2) - 
   8*p(d24,2)*p(d34,2) + 4*d13*p(d24,2)*p(d34,2) - 
   12*p(d13,2)*p(d24,2)*p(d34,2) - 
   4*d23*p(d24,2)*p(d34,2) + 
    12*p(d23,2)*p(d24,2)*p(d34,2) - 8*p(d34,3) + 8*p(d34,4);
return(y);
    }



    public static double p(double x,int k) {
	double y=Math.pow(x,k);
	return(y);
    }
}






