

/**This class contains the routines which support the
   two main functions in the CayleyMenger class*/


public class CayleyMengerDebug {

    /**Here are the main two routines in this class.  They
       are supposed to parallel the routines in the CayleyMenger class.*/


    public static double f1(double[] d) {
	return(f1(convert(d)));
    }

    public static double f2(double[] d,double h) {
	return(f2(convert(d),h));
    }

    /**This routine computes the Cayley Menger determinant of a
       4x4 symmetric matrix with 0's along the diagonal.  One
       squares the matrix entries, puts it into a 5x5 matrix
       and then takes the determinant*/

    public static Matrix cm(double[][] d) {
       Matrix m=new Matrix();
       m.a[0][0]=0;
       for(int i=1;i<5;++i) {
           m.a[0][i]=1;
	   m.a[i][0]=1;
       }

       for(int i=1;i<5;++i) {
	  for(int j=1;j<5;++j) { 
	      double t=d[i-1][j-1]; 
	      m.a[i][j]=t*t;
	  }
       }
       return(m);
    }


    public static double f1(double[][] d) {
       Matrix m=cm(d);
       double x=m.det();
       return(x);
    }

    public static double f2(double[][] d,double h) {
	double[][] dd=new double[4][4];
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		if(i!=j) dd[i][j]=d[i][j]+h;
		else dd[i][j]=0;
	    }
	}
	double y1=f1(d);
	double y2=f1(dd);
	double y3=(y2-y1)/h;
	return(y3);
    }




    /**keeps producing a random list until it satisfies all the
       triangle inequalities needed to be a pseudotetrahedron*/

    public static double[][] randomGoodList() {
	boolean test=false;
	while(test==false) {
	    double[][] d=randomList();
	    test=goodList(d);
	    if(test==true) return(d);
	}
	return(null);
    }


    /**random near 1*/

    public static double nearOne() {
	double s=Math.random();
	return(1-.001*s);
    }

    /**Makes a random symmetric matrix with entries in [0,1],
       and 0's along the diagonal.  The matrix is normalized
       so that d[0][1]=d[1][0]=1*/

    public static double[][] randomList() {
	double[][] d=new double[4][4];
	for(int i=0;i<4;++i) {
	    for(int j=i+1;j<4;++j) {
		d[i][j]=Math.random();
		d[j][i]=d[i][j];
	    }
	}
 	d[0][1]=1.0;
	d[1][0]=1.0;
	return(d);
    }

    public static  boolean goodList(double[] b) {
	return(goodList(convert(b)));
    }

    public static boolean goodList(double[][] d) {
	for(int i=0;i<4;++i) {
	    int j1=(i+1)%4;
	    int j2=(i+2)%4;
	    int j3=(i+3)%4;
	    if(d[j1][j2]+d[j2][j3]<d[j3][j1]) return(false);
	    if(d[j2][j3]+d[j3][j1]<d[j1][j2]) return(false);
	    if(d[j3][j1]+d[j1][j2]<d[j2][j3]) return(false);
	}
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		if(d[i][j]>1) return(false);
	    }
	}
	return(true);
    }

    /**converts from the vector format to the matrix format*/
    public static double[][] convert(double[] b) {
	double[][] d=new double[4][4];
	d[0][1]=1;
	d[0][2]=b[0];
	d[0][3]=b[1];
	d[1][2]=b[2];
	d[1][3]=b[3];
	d[2][3]=b[4];
	for(int i=0;i<4;++i) {
	    for(int j=i+1;j<4;++j) {
		d[j][i]=d[i][j];
	    }
	}
	return(d);
    }


    /**converts from the matrix format to the vector format.
       This assumes that b[0][1]=1;*/

         public static double[] convert(double[][] b) {
              double[] c={b[0][2],b[0][3],b[1][2],b[1][3],b[2][3]};
	      return(c);
	 }
}



