import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Debugger implements Runnable {
    PictureCanvas P;
    boolean HALT;
    int CHOICE;

    public Debugger() {
	HALT=true;
	CHOICE=0;
    }

    public Debugger(PictureCanvas PP) {
	HALT=true;
	this.P=PP;
    }

    /**Main routine*/
    public void run() {
	CHOICE=P.DEBUG.mode;
	if(CHOICE==0) cayleyMenger();
	if(CHOICE==1) functions();
	if(CHOICE==2) space();
	if(CHOICE==3) positivity();
	if(CHOICE==4) cubeFunction4();
	if(CHOICE==5) cubeFunction6();
	if(CHOICE==6) polynomialDilate();
	if(CHOICE==7) polynomialRotate();
	if(CHOICE==8) polynomialReflect();
	if(CHOICE==9) partitionCompleteness();
    }


    /**Here are some routines which generate random inputs*/

    public int random(int n) {
	double x=Math.random();
	int m=(int)(Math.floor(n*x));
	return(m);
    }

    public int[] random5(int n) {
	int[] a=new int[5];
	for(int i=0;i<5;++i) a[i]=random(n);
	return(a);
    }

    public Vector randomVector() {
	Vector V=new Vector();
	for(int i=0;i<3;++i) V.x[i]=Math.random();
	return(V);
    }


    /**This routine checks that we really have computed the
       Cayley-Menger determinant correctly*/

    public void cayleyMenger() {

	Vector V0=randomVector();
	Vector V1=randomVector();
	Vector V2=randomVector();
	Vector V3=randomVector();

	Vector[] V={V0,V1,V2,V3};
	/**computes the volume*/
	Vector[] W=new Vector[3];
	for(int i=0;i<3;++i) W[i]=Vector.minus(V[i],V[3]);
	double vol=(Vector.dot(Vector.cross(W[0],W[1]),W[2]))/6;
	System.out.println("volume "+vol);


	double d1=288*vol*vol;
	System.out.println("288 vol^2  "+d1);

	double[][] D=new double[4][4];
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		D[i][j]=Vector.dist(V[i],V[j]);
	    }
	}
	Matrix m=CayleyMengerDebug.cm(D);
	double d2=m.det();
	System.out.println("cm det     "+d2);

    }









    /**This routine compares the two versions of the CM functions.*/

    public void functions() {
	HALT=false;
	while(HALT==false) {
	    double[][] t=CayleyMengerDebug.randomGoodList();
	    double[] u=CayleyMengerDebug.convert(t);
	    double a1=CayleyMenger.f1(u);
	    double a2=CayleyMengerDebug.f1(u);
	    double b1=CayleyMenger.f2(u);
	    double b2=CayleyMengerDebug.f2(u,.00000001);
	    double a3=a2/a1;
	    double b3=b2/b1;
	    System.out.println("compare "+a3+" "+b3);
	}
    }



    public void space() {
	System.out.println("space test");
	HALT=false;
	long count=0;
	long bad=0;
	while(HALT==false) {
	    ++count;
	    if(count%10==0) System.out.println("       "+count);
	    double[][] c=CayleyMengerDebug.randomGoodList();
	    double[] b={c[0][2],c[0][3],c[1][2],c[1][3],c[2][3]};
	    int test=inside(b);
	    System.out.println(test);
	    if(test==-1) {
               System.out.println("fail "+bad+" "+count);
	       ++bad;
	       printout(b); 
               double d=1/0;
	       HALT=true;
	    }
	}
    }


    public static void printout(int[] t) {
	for(int i=0;i<t.length;++i) System.out.print(t[i]+" ");
	    System.out.println("");
    }

    public void printout(double[] t) {
	for(int i=0;i<t.length;++i) System.out.print(t[i]+"  ");
	    System.out.println("");
    }


    public static int inside(double[] b) { 
	for(int i=0;i<14;++i) {
	    int[] aa=ModuliSpace.code(i);
	    double[][] a=ModuliSpace.simplex(aa);
	    boolean test=Simplex5.inside(a,b);
	    if(test==true) {
                  return(i);
	    }
	}
	return(-1);
    }




    public void positivity() {
 	HALT=false;
	long count=0;
	while(HALT==false) {
	    if(count%100000==0) System.out.println(count);
	    ++count;
	    int k=random(14);
	    double[][] u=CayleyMengerDebug.randomGoodList();
	    double[] t=CayleyMengerDebug.convert(u);
	    double y1=CayleyMenger.f1(t);
	    double y2=CayleyMenger.f2(t);
	    boolean test=true;
	    double L1=y2 - 4*y1;
	    double L2=y2 - 6*y1;
	    if(L1<0) test=false;
	    if(L2<0) test=false;
	    if(test==false) {
	       printout(t);
	       System.out.println("   fail "+y1+" "+y2);
	       System.out.println(1/0);
	   }
	}
    }



    public void cubeFunction4() {
	HALT=false;
	while(HALT==false) {
	    double[] t={Math.random(),Math.random(),Math.random(),Math.random(),Math.random()};
	    int k=random(14);
	    double[] u=FunctionInterpreter.cubeToGeneral(k,t);
	    double y1=CayleyMenger.f2(u)-4*CayleyMenger.f1(u);
	    int[][] b=DataCube.main(4,k);
	    double y2=FunctionInterpreter.main(b,t);
	    double y3=y2-y1;
	    if(y2<0) {
                throw new ProofException("negative number");
	    }
	    if(Math.abs(y3)>.0000000001)  throw new ProofException("mismatch");
	    System.out.println("simplex "+k);
	    System.out.println(y3+"         "+y1+" "+y2);
	}
    }

    public void cubeFunction6() {
	HALT=false;
	while(HALT==false) {
	    double[] t={Math.random(),Math.random(),Math.random(),Math.random(),Math.random()};
	    int k=random(14);
	    double[] u=FunctionInterpreter.cubeToGeneral(k,t);
	    double y1=CayleyMenger.f2(u)-6*CayleyMenger.f1(u);
	    int[][] b=DataCube.main(6,k);
	    double y2=FunctionInterpreter.main(b,t);
	    double y3=y2-y1;
	    if(y2<0) {
                throw new ProofException("negative number");
	    }
	    if(Math.abs(y3)>.0000000001)  throw new ProofException("mismatch");
	    System.out.println("simplex "+k);
	    System.out.println(y3+"         "+y1+" "+y2);
	}
    }

    public void polynomialDilate() {
	Polynomial P=new Polynomial(DataCube.main(6,0));
	  Polynomial Q=P.dilate();
	  int[] x1=random5(10);
	  int[] x2={x1[0],x1[1],x1[2],x1[3],x1[4]};
	  x1[0]=2*x1[0];
	  BigInteger a=P.evaluate(x2);
	  BigInteger b=Q.evaluate(x1);
	  int m=P.exponentLimit(0);
	  m=(int)(Math.pow(2,m));
	  BigInteger cc=Monomial.copy(m);
	  a=a.multiply(cc);
	  System.out.println("----");
	  System.out.println(a.toString());
	  System.out.println(b.toString());
    }

    public void polynomialRotate() {
	Polynomial P=new Polynomial(DataCube.main(6,0));
	  Polynomial Q=P.rotate(2);
	  int[] x1=random5(10);
	  int[] x2={x1[2],x1[3],x1[4],x1[0],x1[1]};
	  BigInteger a=P.evaluate(x2);
	  BigInteger b=Q.evaluate(x1);
	  System.out.println("----");
	  System.out.println(a.toString());
	  System.out.println(b.toString());
    }



    public void polynomialReflect() {
	Polynomial P=new Polynomial(DataCube.main(6,0));
	  Polynomial Q=P.reflect();
          int[] x1=random5(20);
	  int[] x2={1-x1[0],x1[1],x1[2],x1[3],x1[4]};
	  BigInteger a=P.evaluate(x2);
	  BigInteger b=Q.evaluate(x1);
	  System.out.println(a.toString());
	  System.out.println(b.toString());
    }




    public void partitionCompleteness() {
	System.out.println("complete list");
	int[] a={0,1,2,3,4,5,6,7,8,9,10,11,12,13};
	printout(a);
	isComplete(a);
	System.out.println("*********");
	System.out.println("partial lists");
	for(int q=0;q<14;++q) {
	    int[] b=omittedList(q);
	    printout(b);
	    isComplete(b);
	}
    }

    public int[] omittedList(int q) {
	int[] c=new int[13];
	int count=0;
	for(int i=0;i<14;++i) {
	    if(i!=q) {
		c[count]=i;
		++count;
	    }
	}
	return(c);
    }


    public void isComplete(int[] b) {
	for(int k=0;k<b.length;++k) {
	    for(int j=0;j<6;++j) {
		boolean test=isComplete(k,b,j);
		if(test==false) {
		    System.out.println("false");
		    return;
		}
	    }
	}
    }

    public boolean isComplete(int k,int[] b,int f) {
	if(interiorFace(b[k],f)==false) {
	      System.out.println(k+" "+f);
	      return(true);
	}
	boolean test=false;
	for(int i=0;i<b.length;++i) {
	   if(i!=k) {
	      for(int j=0;j<6;++j) {
		 test=matchAcrossFace(b[k],f,b[i],j);
		 if(test==true) return(true);
	      }
	   }
	}
	return(false);
    }

    public boolean interiorFace(int k,int i) {
	double[][] a=ModuliSpace.simplex(ModuliSpace.code(k));
	double[] b=Simplex5.pastCenter(a,i);
	boolean test=CayleyMengerDebug.goodList(b);
	return(test);
    }

    public boolean matchAcrossFace(int a,int i,int b,int j) {
	int[] a0=code(a,i);
	int[] b0=code(b,j);
	for(int q=0;q<5;++q) {
	    if(a0[q]!=b0[q]) return(false);
	}
	double[][] a1=ModuliSpace.simplex(ModuliSpace.code(a));
	double[][] b1=ModuliSpace.simplex(ModuliSpace.code(b));
	return(Simplex5.abut(a1,i,b1));
    }

  public int[] code(int k,int j) {
      int[] a0=ModuliSpace.code(k);
	int[] a1=new int[5];
	int count=0;
	for(int i=0;i<6;++i) {
	    if(i!=j) {
               a1[count]=a0[i];
	       ++count;
	    }
	}
	return(a1);
    }

}


