

public class DocumentDebugger {

    public DocumentDebugger() {}



    public static void cayley(DocumentCanvas D) {
	String S="cayley-menger determinant:"; 
	S=S+"\n\nThis routine checks that we have correctly defined the Cayley-Menger determinant.  We choose 4 random vectors.  Let v be the volume of the tetrahedron having these vectors as vertices.  ";
	S=S+"\n\nWe subtract off the 4th vector and then use the triple product to compute v.  Then we compute 288*v^2";
	S=S+"\n\nWe compute the matrix of distances for the vectors and then use the Cayley-Menger determinant of these distances.  We check that, again, we get 288 v^2, as predicted by the fundamental theorem on the Cayley-Menger determinant.";



        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }

    public static void functions(DocumentCanvas D) {
	String S="functions:"; 
	S=S+"\n\n There are two main functions of interest to us:";
	S=S+"\n\n1. The Cayley-Menger determinant. Call this function f.";
	S=S+"\n\n2. The Directional derivative of the Cayley-Menger determinant in the direction of (1,1,1,1,1,1). Call this function g.";

	S=S+"\n\nThis routine checks that the version of these functions we computed symbolically in Mathematica agrees with the versions computed directly from the definitions. (The cayley-menger routine checks the definition of f.)  For the function f we just make the straightforward computation.";

	S=S+"\n\nFor the function g we do not really have an exact `definitional formula'.  We compute the difference quotient\n\n (f(x+h(1,1,1,1,1,1))/h, where h=.00000001\n\n  We see that this agrees to high precision with the polynomial formula for g we computed exactly in Mathematica.";

	S=S+"\n\nWe print out (symbolic calculation)/(definition calcalation) for the two functions and see that we get very close to the value of 1 in all cases.";
        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }

    public static void totalspace(DocumentCanvas D) {
	String S="total space:"; 
	S=S+"\n\n This routine checks numerically that the moduli space X of normalized pseudo tetrahedra indeed is contained in the union of the 14 simplices from the paper.  We pick random poits in X and then see that each point is contained in one of the simplices.  The program is designed to halt if there is a failure.  The program prints out the simplex number, and also prints out the count of the number of points tested.";
        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }

    public static void positivity(DocumentCanvas D) {
	String S="positivity:"; 
	S=S+"\n\n This routine checks numerically that our functions\n\nPhi4=g-4f\n\nPhi6=g-6f\n\nare non-negative on randomly chosen points in the space X of normalized pseudo-tetrahedra. The program halts if there is a failure and prints out the count of the number of points tested.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }

    public static void cubefunction4(DocumentCanvas D) {
	String S="g-4f:"; 
	S=S+"\n\n This routine checks numerically that our symbolically computed and stored versions of the functions Phi(4,1),...,Phi(4,14) from the paper agree with the functions  which are computed from the definitions.  On the one hand, we compute these functions as compositions of the geometrically defined maps in the paper.  On the other hand, we use the stored polynomials we got from Mathematica.  These stored polynomials are contained in the files DataCube4.java ... They are the functions which we show are recursively weak positive dominant.";
	S=S+"\n\nThe routine prints out the two values, and also their difference.  The routine halts if the difference is more than 10^{-10} in absolute value.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }
    public static void cubefunction6(DocumentCanvas D) {
	String S="g-6f:"; 
	S=S+"\n\n This routine checks numerically that our symbolically computed and stored versions of the functions Phi(6,1),...,Phi(6,14) from the paper agree with the functions  which are computed from the definitions.  On the one hand, we compute these functions as compositions of the geometrically defined maps in the paper.  On the other hand, we use the stored polynomials we got from Mathematica.  These stored polynomials are contained in the files DataCube6.java ... They are the functions which we show are recursively weak positive dominant.";

	S=S+"\n\nThe routine prints out the two values, and also their difference.  The routine halts if the difference is more than 10^{-10} in absolute value.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }


    public static void dilate(DocumentCanvas D) {
	String S="poly dilate:"; 
	S=S+"\n\n This routine checks that our operation of dilating a polynomial, defined in the paper, is correct.  Again, we compute this in two ways.  First we manipulate the monomials, and then we compute the actual polynomial composition.  We check that the two evaluations agree on randomly chosen integers.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }

    public static void rotate(DocumentCanvas D) {
	String S="poly rotate:"; 
	S=S+"\n\n This routine checks that our operation of rotating a polynomial, defined in the paper, is correct.  The rotation of a polynomial P(a,b,c,d,e) is the polynomial P(b,c,d,e,a), or some similar permutation.  The idea is that we compute the rotation of P in two ways.  On the one hand, we symbolically manipulate the monomials comprising P.  On the other hand, we do the computation straight from the definition just given.  We check that the two values agree on randomly chosen integer vectors.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }


    public static void reflect(DocumentCanvas D) {
	String S="poly reflect:"; 
	S=S+"\n\n This routine checks that our operation of reflecting a polynomial, defined in the paper, is correct.  Again, we compute this in two ways.  First we manipulate the monomials, and then we compute the actual polynomial composition.  We check that the two evaluations agree on randomly chosen integers.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }


    public static void partition(DocumentCanvas D) {
	String S="partition completeness:"; 
	S=S+"\n\n This routine makes the computation needed to prove that the moduli space X of normalized pseudo-tetrahedra is contained in the union of the 14 simplices.   Namely, we check that each interior face of each simplex in the list is the face of a second simplex on the list, and that the hyperplane containing the face separates the two simplices.  We also print out all the indices of the boundary faces.  Finally, we check that the completeness condition is false whenever we omit a simplex from the list.";


        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }



    public static void actionDebug(DocumentCanvas D) {
	String S="debugger";

	S=S+"\n\n This selection brings up the auxiliary menu of debugging features.  Click on the question boxes next to these features to see what they do.";


        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }


    public static void actionMain(DocumentCanvas D) {
	String S="main results";

	S=S+"\n\n This selection activates the 28 main calculations. You can do these calculations one at a time or several at a time.  When you select the `positive dominance' mode, you will see two columns of 14 magenta rectangles each.  The left column pertains to the function g-4f from the paper and the right column pertains to the function g-6f.  The rectangles correspond to the simplices.";

	S=S+"\n\nIf you want to certify the non-negativity of the function Phi_{4,3} from the paper, you click on the third rectangle on the left.  If you want to certify the non-negative of the function Phi_{6,7} you click on the 7th rectangle on the right.  Similarly for other index choices. After you have made your selection, press go. This will activate the program, and the results of the program will print out in the calculation monitor.";

	S=S+"\n\nWhen the calculation is running you cannot alter the columns of rectangles.  If you want to change which calculations are done, you should stop the program and then reselect.";

	S=S+"\n\nWhen the calculation is done, it will print out three numbers in the calculation record. The first number tells the number of steps taken in the algorithm.  The second and third numbers tell the minutes and seconds of elapsed time.  So 2.34 would be 2 minutes and 34 seconds.";


        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }


    public static void actionExtra(DocumentCanvas D) {
	String S="extra";

	S=S+"\n\n This selection activates the 2 calculations needed to prove the Selective Lengthening results in the paper.  This mode works just like the main results mode, except that you have 2 rather than 28 calculations to see.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;

    }




}