import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This class is used for the purposes of checking that
   the 14 cube functions are correct.  The routines here
   parallel the routines I wrote in Mathematica to 
   symbolically compute the cube functions.*/


public class FunctionInterpreter {

    public static double main(int[][] a,double[] t) {
	double tot=0;
	for(int i=0;i<a.length;++i) {
	    int[] b=a[i];
	    double y=b[0];
	    for(int j=1;j<6;++j) {
		y=y*Math.pow(t[j-1],b[j]);
	    }
	    tot=tot+y;
	}
	return(tot);
    }


    public static double[] cubeToStandard(double[] t) {
	double[] u={1,1,1,1,1};
	u[0]=t[0];
	for(int i=1;i<5;++i) u[i]=u[i-1]*t[i];
	return(u);
    }

    public static double[] standardToSymmetric(double[] t) {
	double a=t[0];
        double b=t[1];
        double c=t[2];
        double d=t[3];
        double e=t[4];
        double[] v={1 - a, a - b, b - c, c - d, d - e, e};
        return(v);
    }

    public static double[] symmetricToGeneral(double[][] a,double[] t) {
	double[] u={0,0,0,0,0};
	for(int i=0;i<5;++i) {
	    for(int j=0;j<6;++j) {
		u[i]=u[i]+a[j][i]*t[j];
	    }
	}
	return(u);
    }


    public static double[] cubeToGeneral(int k,double[] t) {
	int[] a=ModuliSpace.code(k);
	double[][] aa=ModuliSpace.simplex(a);
	double[] u1=cubeToStandard(t);
	double[] u2=standardToSymmetric(u1);
	double[] u3=symmetricToGeneral(aa,u2);
	return(u3);
    }


}



