import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.util.Arrays;

/**This class generates the triangulation of the moduli space into 5-simplices.
   The number of simplices depends mildly on the ordering of the vertices.  With
   the current ordering, you get 24 simplices.  The program prints out a subroutine
   which (if it was not already there) one could copy into the file ModuliSpace.java*/

public class GenerateSimplex implements Runnable {
    PictureCanvas P;
    boolean HALT;
    int[][] CODE=new int[1000][6];

    /**Constructors*/
    public GenerateSimplex() {
	HALT=true;
    }

    public GenerateSimplex(PictureCanvas PP) {
	HALT=true;
	this.P=PP;
    }

    /**Main routine*/
    public void run() {
	System.out.println("simplex generate");
	generateCode();
	HALT=false;
	int[] b={0};
	int history=0;
	while(HALT==false) {
	    b=augmentList(b);
	    if(history==b.length) HALT=true;
	    history=b.length;
	}
	Arrays.sort(b);
	printResult(b);
	HALT=true;
	P.repaint();
    }

    /**Prints out the final list of simplices in the
       format of a java program*/

    public void printResult(int[] b) {
	int h=b.length;
	System.out.println("");
	System.out.println("");
	System.out.println("public static int[] code(int k) {");
	System.out.println("int[][] list={");
	for(int i=0;i<h;++i) {
	    int[] a=CODE[b[i]];
	    if(i!=h-1) printoutFancy(a,true);
	    if(i==h-1) printoutFancy(a,false);
	}
	System.out.println("return(list[k]);}");
    }



    /**Checks if the ith face of the kth simplex is interior to the moduli space.*/

    public boolean interiorFace(int k,int i) {
	double[][] a=simplex(CODE[k]);
	double[] b=Simplex5.pastCenter(a,i);
	boolean test=CayleyMengerDebug.goodList(b);
	return(test);
    }

    /**This routine is the main step in the algorithm.  Given a list of simplices,
       it tries to find a free face and then add a new simplex which meets the given
       one across the free face.  The algorithm is done when all free faces are covered.*/

    public int[] augmentList(int[] b0) {
	int[] A=isComplete(b0);
	if(A[0]==-1) return(b0);
	int[] B=acquirePartner(b0,b0[A[0]],A[1]);
	int[] b1=new int[b0.length+1];
	for(int i=0;i<b0.length;++i) b1[i]=b0[i];
	b1[b0.length]=B[0];
	return(b1);
    }

    /**This finds the first non-listed simplex to match the
       ith face of the ath simplex on LIST*/

    public int[] acquirePartner(int[] LIST,int a,int i) {
	for(int b=0;b<604;++b) {
	    for(int j=0;j<6;++j) {
		 boolean test1=matchAcrossFace(a,i,b,j);
		 boolean test2=onList(b,LIST);   
		 if((test1==true)&&(test2==false)) {
		     int[] A={b,j};
		     return(A);
		 }
	    }
	}
	int[] A={-1,-1};
	return(A);
    }

    /**Just tests if a number a is on the list LIST of numbers*/

    public boolean onList(int a,int[] LIST) {
	for(int i=0;i<LIST.length;++i) {
	    if(a==LIST[i]) return(true);
	}
	return(false);
    }


    /**These test whether the simplices match*/

    public boolean matchAcrossFace(int a,int i,int b,int j) {
	int[] a0=code(a,i);
	int[] b0=code(b,j);
	for(int q=0;q<5;++q) {
	    if(a0[q]!=b0[q]) return(false);
	}
        double[][] a1=simplex(CODE[a]);
        double[][] b1=simplex(CODE[b]);
	return(Simplex5.abut(a1,i,b1));
    }


    /**The list of simplices is complete if there is no free
       face.  This either returns (-1,-1) to indicate that the
       list is complete or else returns the index of the first
       free face it fines.*/

    public int[] isComplete(int[] b) {
	for(int k=0;k<b.length;++k) {
	    for(int j=0;j<6;++j) {
		boolean test=isComplete(k,b,j);
		if(test==false) {
		    int[] A={k,j};
		    return(A);
		}
	    }
	}
	int[] A={-1,-1};
	return(A);
    }



    /**This picks the fth face of the kth simplex on the
       list b of simplices and tells whether or not it is 
       a free face.*/

    public boolean isComplete(int k,int[] b,int f) {
	if(interiorFace(b[k],f)==false) return(true);
	boolean test=false;
	for(int i=0;i<b.length;++i) {
	   if(i!=k) {
	      for(int j=0;j<6;++j) {
		 test=matchAcrossFace(b[k],f,b[i],j);
		 if(test==true) return(true);
	      }
	   }
	}
	return(false);
    }


    /**printouts*/

    public void printoutFancy(int[] t,boolean comma) {
	System.out.print("{");
	for(int i=0;i<t.length;++i) {
	    System.out.print(t[i]);
	    if(i!=t.length-1) System.out.print(",");
	}
	if(comma==true) System.out.println("},");
	if(comma==false) System.out.println("}};");
    }


    /**Generates the total list of simplices*/

     public static double[] vertex(int k) {
	 return(ModuliSpace.vertex(k));
     }

     /**Here is a simplex*/
     public static double[][] simplex(int[] a) {
	 double[][] b={vertex(a[0]),vertex(a[1]),vertex(a[2]),vertex(a[3]),vertex(a[4]),vertex(a[5])};
	 return(b);
     }

    /**The list of vertices associatd to the jth face of the kth simplex*/
    public int[] code(int k,int j) {
	int[] a0=CODE[k];
	int[] a1=new int[5];
	int count=0;
	for(int i=0;i<6;++i) {
	    if(i!=j) {
               a1[count]=a0[i];
	       ++count;
	    }
	}
	return(a1);
    }

    /**This generates all possible nontrivial 5-simplices.
       There are (12 choose 6) simplices, and it turns out
       that 604 of them are nontrivial -i.e. have nonzero volume.*/

    public void generateCode() {
	int count=0;
	for(int i0=0;i0<12;++i0) {
	for(int i1=i0+1;i1<12;++i1) {
	for(int i2=i1+1;i2<12;++i2) {
	for(int i3=i2+1;i3<12;++i3) {
	for(int i4=i3+1;i4<12;++i4) {
	for(int i5=i4+1;i5<12;++i5) {
	    int[] aa={i0,i1,i2,i3,i4,i5};
	    double[][] a=simplex(aa);
	    double v=Simplex5.volume(a);
	    if(Math.abs(v)>.01) {
		CODE[count]=aa;
		++count;
	    }
	}}}}}}
    }

}


